/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.shared.internal;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.ui.shared.contribution.SharedStateContribution;

@Singleton
public class SharedStateContributionRegistryImpl
implements ISharedStateContributionRegistry {
    private static final String EXTENSION_POINT = "org.eclipse.xtext.ui.shared.sharedStateContributingModule";
    private static final Logger logger = Logger.getLogger(SharedStateContributionRegistryImpl.class);
    private ImmutableList<? extends SharedStateContribution> contributions;
    private Injector injector;
    @Inject
    private IExtensionRegistry extensionRegistry;

    @Inject
    public SharedStateContributionRegistryImpl(Injector injector) {
        this.injector = injector;
    }

    public Injector createInjectorWithoutJITBindings(Module childModule) {
        Injector childInjector = this.injector.createChildInjector(new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.requireExplicitBindings();
            }
        }}).createChildInjector(new Module[]{this.getWrappedModule(childModule)});
        return childInjector;
    }

    public ImmutableList<? extends SharedStateContribution> getContributions() {
        if (this.contributions == null) {
            return this.initializeContributions();
        }
        return this.contributions;
    }

    public <T> ImmutableList<? extends T> getContributedInstances(Class<T> type) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (SharedStateContribution contribution : this.getContributions()) {
            if (!contribution.isContributionSupported(type)) continue;
            listBuilder.add(contribution.getContribution(type));
        }
        return listBuilder.build();
    }

    public <T> Provider<? extends T> getLazySingleContributedInstance(Class<T> type) {
        Provider result = null;
        for (SharedStateContribution contribution : this.getContributions()) {
            if (!contribution.isContributionSupported(type)) continue;
            if (result == null) {
                result = contribution.getLazyContribution(type);
                continue;
            }
            throw new IllegalStateException("Ambiguously contributed instances for type: " + type.getCanonicalName());
        }
        if (result == null) {
            throw new IllegalStateException("Missing contribution for type: " + type.getCanonicalName());
        }
        return result;
    }

    public <T> T getSingleContributedInstance(Class<T> type) {
        return (T)this.getLazySingleContributedInstance(type).get();
    }

    public <T> ImmutableList<? extends Provider<? extends T>> getLazyContributedInstances(Class<T> type) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (SharedStateContribution contribution : this.getContributions()) {
            if (!contribution.isContributionSupported(type)) continue;
            listBuilder.add((Object)contribution.getLazyContribution(type));
        }
        return listBuilder.build();
    }

    private synchronized ImmutableList<? extends SharedStateContribution> initializeContributions() {
        if (this.contributions == null) {
            IExtension[] extensions;
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            IExtensionPoint extensionPoint = this.extensionRegistry.getExtensionPoint(EXTENSION_POINT);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configurationElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
                int n3 = configurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    try {
                        Module childModule = (Module)configurationElement.createExecutableExtension("class");
                        SharedStateContribution contribution = this.createContribution(childModule);
                        listBuilder.add((Object)contribution);
                    }
                    catch (CoreException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (ProvisionException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    ++n4;
                }
                ++n2;
            }
            this.contributions = listBuilder.build();
        }
        return this.contributions;
    }

    public SharedStateContribution createContribution(Module childModule) {
        Injector childInjector = this.createInjectorWithoutJITBindings(childModule);
        SharedStateContribution contribution = (SharedStateContribution)childInjector.getInstance(SharedStateContribution.class);
        return contribution;
    }

    protected Module getWrappedModule(final Module childModule) {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(SharedStateContribution.class);
                binder.install(childModule);
            }
        };
    }
}

