/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeOutputCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteECActionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.ECCContentAndLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEvent;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.preferences.FBTypeEditorPreferenceConstants;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ComboCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.ComboDirectEditManager;
import org.eclipse.fordiac.ide.gef.policies.EmptyXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ComboBoxCellEditor;

public class ECActionOutputEventEditPart
extends AbstractDirectEditableEditPart {
    private static final Insets OUTPUT_EVENT_INSETS = new Insets(3, 6, 3, 6);
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            ECActionOutputEventEditPart.this.refreshEventLabel(ECActionOutputEventEditPart.this.getNameLabel());
        }
    };
    private final Adapter interfaceAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            switch (notification.getEventType()) {
                case 4: {
                    this.handleRemove(notification);
                    break;
                }
                case 1: {
                    this.handleSet(notification);
                    break;
                }
            }
        }

        private void handleSet(Notification notification) {
            if (ECActionOutputEventEditPart.this.getAction().getOutput() != null && notification.getNewValue() instanceof String && (this.isOutputEvent(notification) || this.isAdapterOutputEvent(notification))) {
                ECActionOutputEventEditPart.this.refreshEventLabel(ECActionOutputEventEditPart.this.getNameLabel());
            }
        }

        private boolean isOutputEvent(Notification notification) {
            return ECActionOutputEventEditPart.this.getAction().getOutput().getName().equals(notification.getNewValue());
        }

        private boolean isAdapterOutputEvent(Notification notification) {
            return ECActionOutputEventEditPart.isAdapterNotification(notification.getNewValue(), ECActionOutputEventEditPart.this.getAction().getOutput());
        }

        private void handleRemove(Notification notification) {
            if (notification.getOldValue() == ECActionOutputEventEditPart.this.getAction().getOutput() || ECActionOutputEventEditPart.isAdapterNotification(notification.getOldValue(), ECActionOutputEventEditPart.this.getAction().getOutput())) {
                ECActionOutputEventEditPart.executeCommand((Command)new ChangeOutputCommand(ECActionOutputEventEditPart.this.getAction(), null));
            }
        }
    };
    private final IPropertyChangeListener colorChangeListener = event -> {
        if (event.getProperty().equals("org.eclipse.fordiac.ide.fbtypeeditor.ecc.ECCEditorEventColor")) {
            this.getFigure().setBackgroundColor(FBTypeEditorPreferenceConstants.getEccEventColor());
        }
        if (event.getProperty().equals("org.eclipse.fordiac.ide.fbtypeeditor.ecc.ECCEditorEventTextColor")) {
            this.getFigure().setForegroundColor(FBTypeEditorPreferenceConstants.getEccEventTextColor());
        }
    };

    public static boolean isAdapterNotification(Object change, Event ev) {
        if (ev != null) {
            AdapterFB adapterFB;
            BlockFBNetworkElement fbNetworkElement = ev.getBlockFBNetworkElement();
            return fbNetworkElement instanceof AdapterFB && ((adapterFB = (AdapterFB)fbNetworkElement).getAdapterDecl() == change || fbNetworkElement.getName().equals(change));
        }
        return false;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getAction().eAdapters().add((Object)this.adapter);
            ECCContentAndLabelProvider.getFBType(this.getAction()).getInterfaceList().eAdapters().add((Object)this.interfaceAdapter);
            JFaceResources.getColorRegistry().addListener(this.colorChangeListener);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getAction().eAdapters().remove((Object)this.adapter);
            BasicFBType fbType = ECCContentAndLabelProvider.getFBType(this.getAction());
            if (fbType != null) {
                fbType.getInterfaceList().eAdapters().remove((Object)this.interfaceAdapter);
            }
            JFaceResources.getColorRegistry().removeListener(this.colorChangeListener);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new DeleteECActionCommand(ECActionOutputEventEditPart.this.getAction());
            }
        });
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                Integer value;
                if (this.getHost() instanceof AbstractDirectEditableEditPart && (value = (Integer)request.getCellEditor().getValue()) != null) {
                    int selected = value;
                    List<Event> events = ECCContentAndLabelProvider.getOutputEvents(ECCContentAndLabelProvider.getFBType(ECActionOutputEventEditPart.this.getAction()));
                    Event ev = null;
                    if (selected >= 0 && selected < events.size()) {
                        ev = events.get(selected);
                    }
                    return new ChangeOutputCommand(ECActionOutputEventEditPart.this.getAction(), ev);
                }
                return null;
            }

            protected void showCurrentEditValue(DirectEditRequest request) {
            }
        });
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EmptyXYLayoutEditPolicy());
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            request.setType((Object)"direct edit");
        }
        super.performRequest(request);
    }

    protected ComboDirectEditManager createDirectEditManager() {
        return new ComboDirectEditManager((GraphicalEditPart)this, ComboBoxCellEditor.class, (CellEditorLocator)new ComboCellEditorLocator(this.getNameLabel()), this.getNameLabel());
    }

    public void performDirectEdit() {
        List<String> eventNames = ECCContentAndLabelProvider.getOutputEventNames(ECCContentAndLabelProvider.getFBType(this.getAction()));
        int selected = this.getAction().getOutput() != null ? eventNames.indexOf(this.getAction().getOutput().getName()) : eventNames.size() - 1;
        ComboDirectEditManager editManager = this.createDirectEditManager();
        editManager.updateComboData(eventNames);
        editManager.setSelectedItem(selected);
        editManager.show();
    }

    public ECActionOutputEvent getCastedModel() {
        return (ECActionOutputEvent)this.getModel();
    }

    public ECAction getAction() {
        return this.getCastedModel().getAction();
    }

    public INamedElement getINamedElement() {
        return this.getAction().getOutput();
    }

    public Label getNameLabel() {
        return (Label)this.getFigure();
    }

    protected IFigure createFigure() {
        Label eventLabel = new Label();
        eventLabel.setBackgroundColor(FBTypeEditorPreferenceConstants.getEccEventColor());
        eventLabel.setForegroundColor(FBTypeEditorPreferenceConstants.getEccEventTextColor());
        eventLabel.setOpaque(true);
        this.refreshEventLabel(eventLabel);
        eventLabel.setBorder((Border)new MarginBorder(OUTPUT_EVENT_INSETS));
        eventLabel.setTextAlignment(1);
        eventLabel.setLabelAlignment(1);
        return eventLabel;
    }

    private void refreshEventLabel(Label eventLabel) {
        if (eventLabel != null) {
            eventLabel.setText(ECActionOutputEventEditPart.getActionOutputLabelText(this.getAction().getOutput()));
        }
    }

    private static String getActionOutputLabelText(Event event) {
        if (event == null) {
            return "";
        }
        if (event.getBlockFBNetworkElement() instanceof AdapterFB) {
            return event.getBlockFBNetworkElement().getName() + "." + event.getName();
        }
        return event.getName();
    }
}

