/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.internal.OCLFactoryImpl;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

public class UMLReflectionImpl
implements UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> {
    public static final UMLReflectionImpl INSTANCE = new UMLReflectionImpl();

    protected UMLReflectionImpl() {
    }

    public String getDescription(Object namedElement) {
        if (namedElement instanceof ETypedElement) {
            EClassifier type = ((ETypedElement)namedElement).getEType();
            return type == null ? OCLStandardLibraryImpl.INSTANCE.getOclVoid().getName() : type.getName();
        }
        if (namedElement instanceof EEnumLiteral) {
            return ((EEnumLiteral)namedElement).getEEnum().getName();
        }
        if (namedElement == null) {
            return null;
        }
        return ((EObject)namedElement).eClass().getName();
    }

    public String getName(Object namedElement) {
        return namedElement instanceof ENamedElement ? ((ENamedElement)namedElement).getName() : null;
    }

    public String getQualifiedName(Object namedElement) {
        return namedElement instanceof ENamedElement ? this.getQualifiedName((ENamedElement)namedElement) : null;
    }

    private String getQualifiedName(ENamedElement namedElement) {
        StringBuilder result = new StringBuilder();
        this.getQualifiedName(result, namedElement);
        return result.toString();
    }

    private void getQualifiedName(StringBuilder buf, ENamedElement namedElement) {
        EObject container = namedElement.eContainer();
        if (container instanceof ENamedElement) {
            this.getQualifiedName(buf, (ENamedElement)container);
            buf.append("::");
        }
        buf.append(namedElement.getName());
    }

    public EClassifier getOCLType(Object metaElement) {
        EClassifier result = null;
        if (metaElement == EcorePackage.Literals.ETYPED_ELEMENT__UPPER_BOUND) {
            return OCLStandardLibraryImpl.INSTANCE.getUnlimitedNatural();
        }
        if (metaElement instanceof ETypedElement) {
            ETypedElement typedElement = (ETypedElement)metaElement;
            result = typedElement.getEType();
            result = UMLReflectionImpl.isMany(typedElement) ? this.getOCLCollectionType(result, typedElement.isOrdered(), typedElement.isUnique()) : this.getOCLType(result);
        } else if (metaElement instanceof EClassifier) {
            result = this.getOCLType((EClassifier)metaElement);
        }
        return result;
    }

    public Collection<? extends EClassifier> getAllSupertypes(EClassifier classifier) {
        if (classifier instanceof EClass) {
            return ((EClass)classifier).getEAllSuperTypes();
        }
        return Collections.emptySet();
    }

    public boolean isMany(Object metaElement) {
        return metaElement instanceof ETypedElement && UMLReflectionImpl.isMany((ETypedElement)metaElement);
    }

    public EClassifier asOCLType(EClassifier modelType) {
        return this.getOCLType(modelType);
    }

    public EPackage getNestingPackage(EPackage pkg) {
        return pkg.getESuperPackage();
    }

    public List<EPackage> getNestedPackages(EPackage pkg) {
        return pkg.getESubpackages();
    }

    public EPackage getPackage(EClassifier classifier) {
        return classifier.getEPackage();
    }

    public List<EClassifier> getClassifiers(EPackage pkg) {
        return pkg.getEClassifiers();
    }

    public EClassifier getOwningClassifier(Object feature) {
        if (feature instanceof EOperation) {
            EOperation operation = (EOperation)feature;
            return OCLStandardLibraryImpl.getOwner(operation);
        }
        if (feature instanceof EStructuralFeature) {
            return OCLStandardLibraryImpl.getOwner((EStructuralFeature)feature);
        }
        return null;
    }

    public List<EParameter> getParameters(EOperation operation) {
        return operation.getEParameters();
    }

    public EOperation createOperation(String name, EClassifier resultType, List<String> paramNames, List<EClassifier> paramTypes) {
        EOperation result = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEOperation();
        result.setName(name);
        result.setEType(resultType);
        int i = 0;
        for (String pname : paramNames) {
            EParameter param = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEParameter();
            param.setName(pname);
            param.setEType(paramTypes.get(i++));
            result.getEParameters().add((Object)param);
        }
        return result;
    }

    public List<EOperation> getOperations(EClassifier classifier) {
        EList result = classifier instanceof EClass ? ((EClass)classifier).getEAllOperations() : Collections.emptyList();
        return result;
    }

    public EStructuralFeature createProperty(String name, EClassifier resultType) {
        Object result = resultType instanceof EClass ? org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEReference() : org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAttribute();
        result.setName(name);
        result.setEType(resultType);
        return result;
    }

    public List<EStructuralFeature> getAttributes(EClassifier classifier) {
        EList result = classifier instanceof EClass ? ((EClass)classifier).getEAllStructuralFeatures() : Collections.emptyList();
        return result;
    }

    public List<EClassifier> getSignals(EClassifier owner) {
        return Collections.emptyList();
    }

    public boolean isQuery(EOperation operation) {
        return true;
    }

    public boolean isStatic(Object feature) {
        return false;
    }

    public boolean isAssociationClass(EClassifier eclass) {
        return false;
    }

    public EClass getAssociationClass(EStructuralFeature reference) {
        return null;
    }

    public List<EStructuralFeature> getMemberEnds(EClassifier associationClass) {
        return Collections.emptyList();
    }

    public boolean isOperation(Object metaElement) {
        return metaElement instanceof EOperation;
    }

    public boolean isPackage(Object metaElement) {
        return metaElement instanceof EPackage;
    }

    public boolean isProperty(Object metaElement) {
        return metaElement instanceof EStructuralFeature;
    }

    public boolean isClassifier(Object metaElement) {
        return metaElement instanceof EClassifier;
    }

    public boolean isClass(Object metaElement) {
        return metaElement instanceof EClass;
    }

    public boolean isConstraint(Object metaElement) {
        return metaElement instanceof Constraint;
    }

    public boolean isDataType(Object metaElement) {
        return metaElement instanceof EDataType;
    }

    public boolean isEnumeration(EClassifier type) {
        return type instanceof EEnum;
    }

    public EClassifier getEnumeration(EEnumLiteral enumerationLiteral) {
        return enumerationLiteral.getEEnum();
    }

    public List<EEnumLiteral> getEnumerationLiterals(EClassifier enumerationType) {
        return ((EEnum)enumerationType).getELiterals();
    }

    public EEnumLiteral getEnumerationLiteral(EClassifier enumerationType, String literalName) {
        return ((EEnum)enumerationType).getEEnumLiteral(literalName);
    }

    public boolean isStereotype(EClassifier type) {
        return false;
    }

    public Object getStereotypeApplication(Object baseElement, EClassifier stereotype) {
        return null;
    }

    public boolean isComparable(EClassifier type) {
        Class javaClass = type.getInstanceClass();
        return javaClass != null && Comparable.class.isAssignableFrom(javaClass);
    }

    public CallOperationAction createCallOperationAction(EOperation operation) {
        CallOperationAction result = EcoreFactory.eINSTANCE.createCallOperationAction();
        result.setOperation(operation);
        return result;
    }

    public EOperation getOperation(CallOperationAction callOperationAction) {
        return callOperationAction.getOperation();
    }

    public SendSignalAction createSendSignalAction(EClassifier signal) {
        SendSignalAction result = EcoreFactory.eINSTANCE.createSendSignalAction();
        result.setSignal((EClass)signal);
        return result;
    }

    public EClass getSignal(SendSignalAction sendSignalAction) {
        return sendSignalAction.getSignal();
    }

    public Constraint createConstraint() {
        return EcoreFactory.eINSTANCE.createConstraint();
    }

    public String getStereotype(Constraint constraint) {
        return constraint.getStereotype();
    }

    public void setStereotype(Constraint constraint, String stereotype) {
        constraint.setStereotype(stereotype);
    }

    public String getConstraintName(Constraint constraint) {
        return constraint.getName();
    }

    public void setConstraintName(Constraint constraint, String name) {
        constraint.setName(name);
    }

    public ExpressionInOCL<EClassifier, EParameter> createExpressionInOCL() {
        return EcoreFactory.eINSTANCE.createExpressionInOCL();
    }

    public ExpressionInOCL<EClassifier, EParameter> getSpecification(Constraint constraint) {
        return constraint.getSpecification();
    }

    public void setSpecification(Constraint constraint, ExpressionInOCL<EClassifier, EParameter> specification) {
        constraint.setSpecification(specification);
    }

    public Constraint getConstraint(ExpressionInOCL<EClassifier, EParameter> specification) {
        EObject container = specification.eContainer();
        if (container instanceof Constraint) {
            return (Constraint)container;
        }
        return null;
    }

    public List<EModelElement> getConstrainedElements(Constraint constraint) {
        return constraint.getConstrainedElements();
    }

    public void addConstrainedElement(Constraint constraint, EObject constrainedElement) {
        constraint.getConstrainedElements().add((Object)((EModelElement)constrainedElement));
    }

    public List<EStructuralFeature> getQualifiers(EStructuralFeature property) {
        return ECollections.emptyEList();
    }

    public EClassifier getCommonSuperType(EClassifier type1, EClassifier type2) {
        if (ObjectUtil.equal((Object)type1, (Object)type2)) {
            return type2;
        }
        if (type1 instanceof EClass && type2 instanceof EClass) {
            EClass eClass1 = (EClass)type1;
            EClass eClass2 = (EClass)type2;
            if (eClass1.isSuperTypeOf(eClass2)) {
                return eClass1;
            }
            if (eClass2.isSuperTypeOf(eClass1)) {
                return eClass2;
            }
            ArrayList<EClass> allSuperAndSelf1 = new ArrayList<EClass>((Collection<EClass>)eClass1.getEAllSuperTypes());
            allSuperAndSelf1.add(eClass1);
            ArrayList<EClass> allSuperAndSelf2 = new ArrayList<EClass>((Collection<EClass>)eClass2.getEAllSuperTypes());
            allSuperAndSelf2.add(eClass2);
            allSuperAndSelf1.retainAll(allSuperAndSelf2);
            if (!allSuperAndSelf1.isEmpty()) {
                return (EClassifier)allSuperAndSelf1.get(allSuperAndSelf1.size() - 1);
            }
        }
        return null;
    }

    public int getRelationship(EClassifier type1, EClassifier type2) {
        if (ObjectUtil.equal((Object)type1, (Object)type2)) {
            return 1;
        }
        if (type1 instanceof EClass && type2 instanceof EClass) {
            EClass class1 = (EClass)type1;
            EClass class2 = (EClass)type2;
            if (class1.isSuperTypeOf(class2)) {
                return 4;
            }
            if (class2.isSuperTypeOf(class1)) {
                return 2;
            }
        }
        return 8;
    }

    private EClassifier getOCLTypeFor(EDataType dataType) {
        if (dataType instanceof EEnum) {
            return dataType;
        }
        if (dataType instanceof CollectionType) {
            return dataType;
        }
        if (dataType instanceof PrimitiveType) {
            return dataType;
        }
        Class instanceClass = dataType.getInstanceClass();
        if (instanceClass != null) {
            if (instanceClass == Boolean.class || instanceClass == Boolean.TYPE) {
                return OCLStandardLibraryImpl.INSTANCE.getBoolean();
            }
            if (instanceClass == Double.class || instanceClass == BigDecimal.class || instanceClass == Double.TYPE || instanceClass == Float.class || instanceClass == Float.TYPE) {
                return OCLStandardLibraryImpl.INSTANCE.getReal();
            }
            if (instanceClass == String.class) {
                return OCLStandardLibraryImpl.INSTANCE.getString();
            }
            if (instanceClass == Integer.class || instanceClass == Integer.TYPE || instanceClass == Long.class || instanceClass == Long.TYPE || instanceClass == Short.class || instanceClass == Short.TYPE || instanceClass == Byte.class || instanceClass == Byte.TYPE || instanceClass == BigInteger.class) {
                return OCLStandardLibraryImpl.INSTANCE.getInteger();
            }
            if (List.class.isAssignableFrom(instanceClass)) {
                return OCLStandardLibraryImpl.INSTANCE.getSequence();
            }
            if (Set.class.isAssignableFrom(instanceClass)) {
                return OCLStandardLibraryImpl.INSTANCE.getSet();
            }
            if (Collection.class.isAssignableFrom(instanceClass)) {
                return OCLStandardLibraryImpl.INSTANCE.getCollection();
            }
            if (instanceClass == Object.class) {
                return OCLStandardLibraryImpl.INSTANCE.getOclAny();
            }
        }
        return dataType;
    }

    EClassifier getOCLType(EClassifier type) {
        EClassifier resultType = type;
        if (resultType instanceof EDataType) {
            resultType = this.getOCLTypeFor((EDataType)resultType);
        }
        return resultType;
    }

    public EClassifier getOCLCollectionType(EClassifier type, boolean isOrdered, boolean isUnique) {
        EClassifier resultType = type;
        if (resultType instanceof EDataType) {
            resultType = this.getOCLTypeFor((EDataType)resultType);
        }
        OCLFactory oclFactory = OCLFactoryImpl.INSTANCE;
        resultType = isOrdered ? (isUnique ? (EClassifier)oclFactory.createOrderedSetType((Object)resultType) : (EClassifier)oclFactory.createSequenceType((Object)resultType)) : (isUnique ? (EClassifier)oclFactory.createSetType((Object)resultType) : (EClassifier)oclFactory.createBagType((Object)resultType));
        return resultType;
    }

    static boolean isMany(ETypedElement typedElement) {
        if (typedElement instanceof EStructuralFeature) {
            int upperBound = typedElement.getUpperBound();
            return upperBound > 1 || upperBound < 0;
        }
        return typedElement.isMany();
    }

    public static boolean isAncestor(EObject ancestor, EObject descendent) {
        while (descendent != null) {
            if (descendent == ancestor) {
                return true;
            }
            descendent = descendent.eContainer();
        }
        return false;
    }

    public void setName(TypedElement<EClassifier> element, String name) {
        element.setName(name);
    }

    public void setType(TypedElement<EClassifier> element, EClassifier type) {
        element.setType((Object)type);
    }

    public boolean setIsStatic(Object feature, boolean isStatic) {
        return false;
    }
}

