/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.st;

import com.google.common.collect.Iterables;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.export.forte_ng.st.VarDeclarationSupport;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STVarGlobalDeclarationBlock;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyElementaryType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.CharType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StringType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.data.WcharType;
import org.eclipse.fordiac.ide.model.data.WstringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.st.variable.STVariableOperations;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAssignment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryOperator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBuiltinFeature;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBuiltinFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallNamedOutputArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseCases;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STContinue;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateAndTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElementaryInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElseIfPart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElsePart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExit;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMemberAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMultiBitAccessSpecifier;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMultibitPartialExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNop;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNumericLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STReturn;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSingleArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStandardFunction;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStringLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStructInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeOfDayLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInOutDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarOutputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.AccessMode;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public abstract class StructuredTextSupport
implements ILanguageSupport {
    @Accessors
    private final List<String> errors = CollectionLiterals.newArrayList();
    @Accessors
    private final List<String> warnings = CollectionLiterals.newArrayList();
    @Accessors
    private final List<String> infos = CollectionLiterals.newArrayList();
    private final Map<VarDeclaration, ILanguageSupport> variableLanguageSupport = CollectionLiterals.newHashMap();
    private int uniqueVariableIndex = 0;

    protected CharSequence generateVariables(Iterable<? extends STVarDeclarationBlock> blocks, boolean decl) {
        StringConcatenation _builder = new StringConcatenation();
        for (STVarDeclarationBlock sTVarDeclarationBlock : blocks) {
            CharSequence _generateVariableBlock = this.generateVariableBlock(sTVarDeclarationBlock, decl);
            _builder.append((Object)_generateVariableBlock);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateVariableBlock(STVarDeclarationBlock block, boolean decl) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)block.getVarDeclarations(), STVarDeclaration.class);
        for (STVarDeclaration variable : _filter) {
            CharSequence _generateVariable = this.generateVariable(variable, decl, block.isConstant());
            _builder.append((Object)_generateVariable);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateVariable(STVarDeclaration variable, boolean decl, boolean const_) {
        boolean _tripleNotEquals;
        StringConcatenation _xifexpression = null;
        INamedElement _locatedAt = variable.getLocatedAt();
        boolean bl = _tripleNotEquals = _locatedAt != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            if (decl) {
                boolean _not;
                if (const_) {
                    _builder.append("const ");
                }
                CharSequence _generateFeatureTypeName = this.generateFeatureTypeName((ITypedElement)variable);
                _builder.append((Object)_generateFeatureTypeName);
                _builder.append(" ");
                boolean _isArray = variable.isArray();
                boolean bl2 = _not = !_isArray;
                if (_not) {
                    _builder.append("&");
                }
            }
            CharSequence _generateFeatureName = this.generateFeatureName((INamedElement)variable);
            _builder.append((Object)_generateFeatureName);
            _builder.append(" = ");
            CharSequence _generateFeatureName_1 = this.generateFeatureName(variable.getLocatedAt());
            _builder.append((Object)_generateFeatureName_1);
            _builder.append(";");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            if (decl) {
                if (const_) {
                    _builder_1.append("const ");
                }
                CharSequence _generateFeatureTypeName_1 = this.generateFeatureTypeName((ITypedElement)variable);
                _builder_1.append((Object)_generateFeatureTypeName_1);
                _builder_1.append(" ");
            }
            CharSequence _generateFeatureName_2 = this.generateFeatureName((INamedElement)variable);
            _builder_1.append((Object)_generateFeatureName_2);
            _builder_1.append(" = ");
            CharSequence _generateVariableDefaultValue = this.generateVariableDefaultValue((INamedElement)variable);
            _builder_1.append((Object)_generateVariableDefaultValue);
            _builder_1.append(";");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    protected CharSequence _generateInitializerExpression(STElementaryInitializerExpression expr) {
        return this.generateExpression(expr.getValue());
    }

    protected CharSequence _generateInitializerExpression(STArrayInitializerExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)STCoreUtil.getExpectedType((STInitializerExpression)expr));
        _builder.append((Object)_generateTypeName);
        _builder.append("{");
        EList _values = expr.getValues();
        boolean _hasElements = false;
        for (STArrayInitElement elem : _values) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateArrayInitElement = this.generateArrayInitElement(elem);
            _builder.append((Object)_generateArrayInitElement);
        }
        _builder.append("}");
        return _builder;
    }

    protected CharSequence _generateArrayInitElement(STSingleArrayInitElement elem) {
        return this.generateInitializerExpression(elem.getInitExpression());
    }

    protected CharSequence _generateArrayInitElement(STRepeatArrayInitElement elem) {
        StringConcatenation _builder = new StringConcatenation();
        int _intValueExact = elem.getRepetitions().intValueExact();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _intValueExact, true);
        boolean _hasElements = false;
        for (Integer i : _doubleDotLessThan) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            EList _initExpressions = elem.getInitExpressions();
            boolean _hasElements_1 = false;
            for (STInitializerExpression initExpression : _initExpressions) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _generateInitializerExpression = this.generateInitializerExpression(initExpression);
                _builder.append((Object)_generateInitializerExpression);
            }
        }
        return _builder;
    }

    protected CharSequence _generateInitializerExpression(STStructInitializerExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)STCoreUtil.getExpectedType((STInitializerExpression)expr));
        _builder.append((Object)_generateTypeName);
        _builder.append("(");
        Iterable<CharSequence> _generateStructInitElements = this.generateStructInitElements(expr);
        boolean _hasElements = false;
        for (CharSequence elem : _generateStructInitElements) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append((Object)elem);
        }
        _builder.append(")");
        return _builder;
    }

    protected Iterable<CharSequence> generateStructInitElements(STStructInitializerExpression expr) {
        Functions.Function1 _function = it -> this.generateStructInitElement((INamedElement)it.getKey(), (STInitializerExpression)it.getValue());
        return IterableExtensions.map(expr.getMappedStructInitElements().entrySet(), (Functions.Function1)_function);
    }

    protected CharSequence generateStructInitElement(INamedElement variable, STInitializerExpression value) {
        CharSequence _xifexpression = null;
        _xifexpression = value == null ? this.generateVariableDefaultValue(variable) : this.generateInitializerExpression(value);
        return _xifexpression;
    }

    protected CharSequence generateStatementList(List<STStatement> statements) {
        StringConcatenation _builder = new StringConcatenation();
        for (STStatement statement : statements) {
            CharSequence _generateLineDirective = this.generateLineDirective((EObject)statement);
            _builder.append((Object)_generateLineDirective);
            CharSequence _generateStatement = this.generateStatement(statement);
            _builder.append((Object)_generateStatement);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateStatement(STStatement stmt) {
        StringConcatenation _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The statement ");
        String _name = stmt.eClass().getName();
        _builder.append(_name);
        _builder.append(" is not supported");
        this.errors.add(_builder.toString());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("#error \"The statement ");
        String _name_1 = stmt.eClass().getName();
        _builder_1.append(_name_1);
        _builder_1.append(" is not supported\"");
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    protected CharSequence _generateStatement(STNop stmt) {
        return "";
    }

    protected CharSequence _generateStatement(STIfStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (");
        CharSequence _generateExpression = this.generateExpression(stmt.getCondition());
        _builder.append((Object)_generateExpression);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        EList _elseifs = stmt.getElseifs();
        for (STElseIfPart elseif : _elseifs) {
            _builder.append("else if (");
            CharSequence _generateExpression_1 = this.generateExpression(elseif.getCondition());
            _builder.append((Object)_generateExpression_1);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            CharSequence _generateStatementList_1 = this.generateStatementList((List<STStatement>)elseif.getStatements());
            _builder.append((Object)_generateStatementList_1, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        STElsePart _else = stmt.getElse();
        boolean bl = _tripleNotEquals = _else != null;
        if (_tripleNotEquals) {
            _builder.append("else {");
            _builder.newLine();
            _builder.append("  ");
            CharSequence _generateStatementList_2 = this.generateStatementList((List<STStatement>)stmt.getElse().getStatements());
            _builder.append((Object)_generateStatementList_2, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateStatement(STCaseStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence variable = this.generateUniqueVariableName();
        _builder.newLineIfNotEmpty();
        _builder.append("if (auto ");
        _builder.append((Object)variable);
        _builder.append(" = ");
        CharSequence _generateExpression = this.generateExpression(stmt.getSelector());
        _builder.append((Object)_generateExpression);
        _builder.append("; false) {");
        _builder.newLineIfNotEmpty();
        EList _cases = stmt.getCases();
        for (STCaseCases clause : _cases) {
            _builder.append("} else if (");
            EList _conditions = clause.getConditions();
            boolean _hasElements = false;
            for (STExpression value : _conditions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)" || ", "");
                }
                CharSequence _generateCaseCondition = this.generateCaseCondition(value, variable);
                _builder.append((Object)_generateCaseCondition);
            }
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)clause.getStatements());
            _builder.append((Object)_generateStatementList, "  ");
            _builder.newLineIfNotEmpty();
        }
        STElsePart _else = stmt.getElse();
        boolean bl = _tripleNotEquals = _else != null;
        if (_tripleNotEquals) {
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("  ");
            CharSequence _generateStatementList_1 = this.generateStatementList((List<STStatement>)stmt.getElse().getStatements());
            _builder.append((Object)_generateStatementList_1, "  ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateCaseCondition(STExpression expr, CharSequence variable) {
        boolean _isRange;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        if (expr instanceof STBinaryExpression && (_isRange = STCoreUtil.isRange((STBinaryOperator)((STBinaryExpression)expr).getOp()))) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("func_AND(func_GE(");
            _builder.append((Object)variable);
            _builder.append(", ");
            CharSequence _generateExpression = this.generateExpression(((STBinaryExpression)expr).getLeft());
            _builder.append((Object)_generateExpression);
            _builder.append("), func_LE(");
            _builder.append((Object)variable);
            _builder.append(", ");
            CharSequence _generateExpression_1 = this.generateExpression(((STBinaryExpression)expr).getRight());
            _builder.append((Object)_generateExpression_1);
            _builder.append("))");
            _switchResult = _builder;
        }
        if (!_matched) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("func_EQ(");
            _builder.append((Object)variable);
            _builder.append(", ");
            CharSequence _generateExpression = this.generateExpression(expr);
            _builder.append((Object)_generateExpression);
            _builder.append(")");
            _switchResult = _builder;
        }
        return _switchResult;
    }

    protected CharSequence _generateStatement(STForStatement stmt) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("for (auto ");
        CharSequence _generateUniqueVariableName = this.generateUniqueVariableName();
        _builder.append((Object)_generateUniqueVariableName);
        _builder.append(" : ST_FOR_ITER<");
        CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)stmt.getVariable().getResultType());
        _builder.append((Object)_generateTypeName);
        STExpression _by = stmt.getBy();
        boolean bl = _tripleNotEquals = _by != null;
        if (_tripleNotEquals) {
            _builder.append(", ");
            CharSequence _generateTypeName_1 = ForteNgExportUtil.generateTypeName((LibraryElement)stmt.getBy().getResultType());
            _builder.append((Object)_generateTypeName_1);
        }
        _builder.append(">(");
        CharSequence _generateExpression = this.generateExpression(stmt.getVariable());
        _builder.append((Object)_generateExpression);
        _builder.append(", ");
        CharSequence _generateExpression_1 = this.generateExpression(stmt.getFrom());
        _builder.append((Object)_generateExpression_1);
        _builder.append(", ");
        CharSequence _generateExpression_2 = this.generateExpression(stmt.getTo());
        _builder.append((Object)_generateExpression_2);
        STExpression _by_1 = stmt.getBy();
        boolean bl2 = _tripleNotEquals_1 = _by_1 != null;
        if (_tripleNotEquals_1) {
            _builder.append(", ");
            CharSequence _generateExpression_3 = this.generateExpression(stmt.getBy());
            _builder.append((Object)_generateExpression_3);
        }
        _builder.append(")) {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateStatement(STWhileStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("while (");
        CharSequence _generateExpression = this.generateExpression(stmt.getCondition());
        _builder.append((Object)_generateExpression);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateStatement(STRepeatStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("do {");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("} while (!((");
        CharSequence _generateExpression = this.generateExpression(stmt.getCondition());
        _builder.append((Object)_generateExpression);
        _builder.append(")));");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateStatement(STContinue stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("continue;");
        return _builder;
    }

    protected CharSequence _generateStatement(STReturn stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return;");
        return _builder;
    }

    protected CharSequence _generateStatement(STExit stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("break;");
        return _builder;
    }

    protected CharSequence _generateStatement(STExpression stmt) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression(stmt);
        _builder.append((Object)_generateExpression);
        _builder.append(";");
        return _builder;
    }

    protected CharSequence _generateExpression(STExpression expr) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The expression ");
        String _name = expr.eClass().getName();
        _builder.append(_name);
        _builder.append(" is not supported");
        this.errors.add(_builder.toString());
        _xblockexpression = "";
        return _xblockexpression;
    }

    protected CharSequence _generateExpression(STAssignment expr) {
        StringConcatenation _xifexpression = null;
        boolean _isAnyVariableReference = STCoreUtil.isAnyVariableReference((STExpression)expr.getRight());
        if (_isAnyVariableReference) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _generateExpression = this.generateExpression(expr.getLeft());
            _builder.append((Object)_generateExpression);
            _builder.append(".setValue(");
            CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
            _builder.append((Object)_generateExpression_1);
            _builder.append(".unwrap())");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            CharSequence _generateExpression_2 = this.generateExpression(expr.getLeft());
            _builder_1.append((Object)_generateExpression_2);
            _builder_1.append(" = ");
            CharSequence _generateExpression_3 = this.generateExpression(expr.getRight());
            _builder_1.append((Object)_generateExpression_3);
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    protected CharSequence _generateExpression(STBinaryExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _switchResult = null;
        STBinaryOperator _op = expr.getOp();
        if (_op != null) {
            switch (_op) {
                case AMPERSAND: {
                    _switchResult = "func_AND";
                    break;
                }
                case POWER: {
                    _switchResult = "func_EXPT";
                    break;
                }
                default: {
                    _builder_1 = new StringConcatenation();
                    _builder_1.append("func_");
                    _name = expr.getOp().getName();
                    _builder_1.append(_name);
                    _switchResult = _builder_1;
                    break;
                }
            }
        } else {
            _builder_1 = new StringConcatenation();
            _builder_1.append("func_");
            _name = expr.getOp().getName();
            _builder_1.append(_name);
            _switchResult = _builder_1;
        }
        _builder.append((Object)_switchResult);
        if (STCoreUtil.isArithmetic((STBinaryOperator)expr.getOp()) || STCoreUtil.isLogical((STBinaryOperator)expr.getOp())) {
            _builder.append("<");
            CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)expr.getResultType());
            _builder.append((Object)_generateTypeName);
            _builder.append(">");
        }
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(", ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(STUnaryExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("func_");
        String _name = expr.getOp().getName();
        _builder.append(_name);
        _builder.append("<");
        CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)expr.getResultType());
        _builder.append((Object)_generateTypeName);
        _builder.append(">(");
        CharSequence _generateExpression = this.generateExpression(expr.getExpression());
        _builder.append((Object)_generateExpression);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(STMemberAccessExpression expr) {
        StringConcatenation _switchResult = null;
        LibraryElement _resultType = expr.getReceiver().getResultType();
        boolean _matched = false;
        if (_resultType instanceof AdapterType) {
            _matched = true;
        }
        if (!_matched && _resultType instanceof FBType) {
            _matched = true;
        }
        if (_matched) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _generateExpression = this.generateExpression(expr.getReceiver());
            _builder.append((Object)_generateExpression);
            _builder.append("->");
            CharSequence _generateExpression_1 = this.generateExpression(expr.getMember());
            _builder.append((Object)_generateExpression_1);
            _switchResult = _builder;
        }
        if (!_matched) {
            StringConcatenation _builder_1 = new StringConcatenation();
            CharSequence _generateExpression_2 = this.generateExpression(expr.getReceiver());
            _builder_1.append((Object)_generateExpression_2);
            _builder_1.append(".");
            CharSequence _generateExpression_3 = this.generateExpression(expr.getMember());
            _builder_1.append((Object)_generateExpression_3);
            _switchResult = _builder_1;
        }
        return _switchResult;
    }

    protected CharSequence _generateExpression(STArrayAccessExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression(expr.getReceiver());
        _builder.append((Object)_generateExpression);
        EList _index = expr.getIndex();
        for (STExpression index : _index) {
            _builder.append(".at(");
            CharSequence _generateExpression_1 = this.generateExpression(index);
            _builder.append((Object)_generateExpression_1);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence _generateExpression(STFeatureExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateFeatureName = this.generateFeatureName(expr.getFeature());
        _builder.append((Object)_generateFeatureName);
        CharSequence _generateTemplateArguments = this.generateTemplateArguments(expr);
        _builder.append((Object)_generateTemplateArguments);
        boolean _isCall = expr.isCall();
        if (_isCall) {
            _builder.append("(");
            Iterable<CharSequence> _generateCallArguments = this.generateCallArguments(expr);
            boolean _hasElements = false;
            for (CharSequence arg : _generateCallArguments) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                _builder.append((Object)arg);
            }
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence generateTemplateArguments(STFeatureExpression expr) {
        boolean _isGenericReturnType;
        INamedElement _feature;
        String _switchResult = null;
        INamedElement feature = _feature = expr.getFeature();
        boolean _matched = false;
        if (feature instanceof STStandardFunction && (_isGenericReturnType = this.isGenericReturnType((STStandardFunction)feature))) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<");
            CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)expr.getResultType());
            _builder.append((Object)_generateTypeName);
            _builder.append(">");
            _switchResult = _builder;
        }
        if (!_matched) {
            _switchResult = "";
        }
        return _switchResult;
    }

    protected boolean isGenericReturnType(STStandardFunction standardFunction) {
        Type _genericReturnType;
        boolean _switchResult = false;
        Type type = _genericReturnType = standardFunction.getJavaMethod().getGenericReturnType();
        boolean _matched = false;
        if (type instanceof Class && !Objects.equals(type, Void.TYPE) && STCoreUtil.isAnyType((INamedElement)ValueOperations.dataType((Class)((Class)type)))) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    protected Iterable<CharSequence> generateCallArguments(STFeatureExpression expr) {
        Iterable _xtrycatchfinallyexpression = null;
        try {
            Functions.Function1 _function = it -> this.generateInputCallArgument((ITypedElement)it.getKey(), (STCallArgument)it.getValue(), expr);
            Iterable _map = IterableExtensions.map(expr.getMappedInputArguments().entrySet(), (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> this.generateInOutCallArgument((ITypedElement)it.getKey(), (STCallArgument)it.getValue());
            Iterable _map_1 = IterableExtensions.map(expr.getMappedInOutArguments().entrySet(), (Functions.Function1)_function_1);
            Iterable _plus = Iterables.concat((Iterable)_map, (Iterable)_map_1);
            Functions.Function1 _function_2 = it -> this.generateOutputCallArgument((ITypedElement)it.getKey(), (STCallArgument)it.getValue());
            Iterable _map_2 = IterableExtensions.map(expr.getMappedOutputArguments().entrySet(), (Functions.Function1)_function_2);
            _xtrycatchfinallyexpression = Iterables.concat((Iterable)_plus, (Iterable)_map_2);
        }
        catch (Throwable _t) {
            if (_t instanceof IndexOutOfBoundsException) {
                List _xblockexpression = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Not enough arguments for ");
                String _name = expr.getFeature().getName();
                _builder.append(_name);
                this.errors.add(_builder.toString());
                _xtrycatchfinallyexpression = _xblockexpression = CollectionLiterals.emptyList();
            }
            if (_t instanceof ClassCastException) {
                List _xblockexpression_1 = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mixing named and unnamed arguments is not allowed");
                this.errors.add(_builder.toString());
                _xtrycatchfinallyexpression = _xblockexpression_1 = CollectionLiterals.emptyList();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    protected CharSequence _generateExpression(STBuiltinFeatureExpression expr) {
        String _switchResult = null;
        STBuiltinFeature _feature = expr.getFeature();
        if (_feature != null) {
            switch (_feature) {
                case THIS: {
                    String _xifexpression = null;
                    boolean _isCall = expr.isCall();
                    if (_isCall) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("(*this)(");
                        Iterable<CharSequence> _generateCallArguments = this.generateCallArguments(expr);
                        boolean _hasElements = false;
                        for (CharSequence arg : _generateCallArguments) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            _builder.append((Object)arg);
                        }
                        _builder.append(")");
                        _xifexpression = _builder;
                    } else {
                        _xifexpression = "this";
                    }
                    _switchResult = _xifexpression;
                    break;
                }
            }
        }
        return _switchResult;
    }

    protected Iterable<CharSequence> generateCallArguments(STBuiltinFeatureExpression expr) {
        Iterable _xtrycatchfinallyexpression = null;
        try {
            Functions.Function1 _function = it -> this.generateInputCallArgument((ITypedElement)it.getKey(), (STCallArgument)it.getValue());
            Iterable _map = IterableExtensions.map(expr.getMappedInputArguments().entrySet(), (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> this.generateInOutCallArgument((ITypedElement)it.getKey(), (STCallArgument)it.getValue());
            Iterable _map_1 = IterableExtensions.map(expr.getMappedInOutArguments().entrySet(), (Functions.Function1)_function_1);
            Iterable _plus = Iterables.concat((Iterable)_map, (Iterable)_map_1);
            Functions.Function1 _function_2 = it -> this.generateOutputCallArgument((ITypedElement)it.getKey(), (STCallArgument)it.getValue());
            Iterable _map_2 = IterableExtensions.map(expr.getMappedOutputArguments().entrySet(), (Functions.Function1)_function_2);
            _xtrycatchfinallyexpression = Iterables.concat((Iterable)_plus, (Iterable)_map_2);
        }
        catch (Throwable _t) {
            if (_t instanceof IndexOutOfBoundsException) {
                List _xblockexpression = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Not enough arguments for ");
                String _name = expr.getFeature().getName();
                _builder.append(_name);
                this.errors.add(_builder.toString());
                _xtrycatchfinallyexpression = _xblockexpression = CollectionLiterals.emptyList();
            }
            if (_t instanceof ClassCastException) {
                List _xblockexpression_1 = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mixing named and unnamed arguments is not allowed");
                this.errors.add(_builder.toString());
                _xtrycatchfinallyexpression = _xblockexpression_1 = CollectionLiterals.emptyList();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    protected CharSequence generateInputCallArgument(ITypedElement parameter, STCallArgument argument, STFeatureExpression expr) {
        StringConcatenation _builder;
        CharSequence _switchResult = null;
        INamedElement _feature = expr.getFeature();
        boolean _matched = false;
        if (_feature instanceof FB && argument == null) {
            _matched = true;
            _builder = new StringConcatenation();
            CharSequence _generateFeatureName = this.generateFeatureName(expr.getFeature());
            _builder.append((Object)_generateFeatureName);
            _builder.append("->");
            CharSequence _generateFeatureName_1 = this.generateFeatureName((INamedElement)parameter);
            _builder.append((Object)_generateFeatureName_1);
            _switchResult = _builder;
        }
        if (!_matched && _feature instanceof Event && argument == null) {
            _matched = true;
            _builder = new StringConcatenation();
            EObject _eContainer = expr.eContainer();
            CharSequence _generateExpression = this.generateExpression(((STMemberAccessExpression)_eContainer).getReceiver());
            _builder.append((Object)_generateExpression);
            _builder.append("->");
            CharSequence _generateFeatureName = this.generateFeatureName((INamedElement)parameter);
            _builder.append((Object)_generateFeatureName);
            _switchResult = _builder;
        }
        if (!_matched) {
            _switchResult = this.generateInputCallArgument(parameter, argument);
        }
        return _switchResult;
    }

    protected CharSequence generateInputCallArgument(ITypedElement parameter, STCallArgument argument) {
        CharSequence _xifexpression = null;
        _xifexpression = argument == null ? this.generateVariableDefaultValue((INamedElement)parameter) : this.generateExpression(argument.getArgument());
        return _xifexpression;
    }

    protected CharSequence generateInOutCallArgument(ITypedElement parameter, STCallArgument argument) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (Objects.equals(argument, null)) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("ST_IGNORE_OUT_PARAM(");
            CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)STCoreUtil.getFeatureType((INamedElement)parameter));
            _builder.append((Object)_generateTypeName);
            _builder.append("(");
            CharSequence _generateVariableDefaultValue = this.generateVariableDefaultValue((INamedElement)parameter);
            _builder.append((Object)_generateVariableDefaultValue);
            _builder.append("))");
            _switchResult = _builder;
        }
        if (!_matched && argument.getArgument() instanceof STMemberAccessExpression && ((STMemberAccessExpression)argument.getArgument()).getMember() instanceof STMultibitPartialExpression) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("ST_EXTEND_LIFETIME(");
            CharSequence _generateExpression = this.generateExpression(argument.getArgument());
            _builder_1.append((Object)_generateExpression);
            _builder_1.append(")");
            _switchResult = _builder_1;
        }
        if (!_matched) {
            _switchResult = this.generateExpression(argument.getArgument());
        }
        return _switchResult;
    }

    protected CharSequence generateOutputCallArgument(ITypedElement parameter, STCallArgument argument) {
        boolean _isNot;
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (Objects.equals(argument, null)) {
            _matched = true;
            StringConcatenation _xifexpression = null;
            LibraryElement _featureType = STCoreUtil.getFeatureType((INamedElement)parameter);
            if (_featureType instanceof AnyBitType) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("CAnyBitOutputParameter<");
                CharSequence _generateFeatureTypeName = this.generateFeatureTypeName(parameter);
                _builder.append((Object)_generateFeatureTypeName);
                _builder.append(">()");
                _xifexpression = _builder;
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("COutputParameter<");
                CharSequence _generateFeatureTypeName_1 = this.generateFeatureTypeName(parameter);
                _builder_1.append((Object)_generateFeatureTypeName_1);
                _builder_1.append(">()");
                _xifexpression = _builder_1;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && argument instanceof STCallNamedOutputArgument && (_isNot = ((STCallNamedOutputArgument)argument).isNot())) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("CAnyBitOutputParameter<");
            CharSequence _generateFeatureTypeName_2 = this.generateFeatureTypeName(parameter);
            _builder_2.append((Object)_generateFeatureTypeName_2);
            _builder_2.append(">(");
            CharSequence _generateExpression = this.generateExpression(((STCallNamedOutputArgument)argument).getArgument());
            _builder_2.append((Object)_generateExpression);
            _builder_2.append(", true)");
            _switchResult = _builder_2;
        }
        if (!_matched && argument.getArgument() instanceof STMemberAccessExpression && ((STMemberAccessExpression)argument.getArgument()).getMember() instanceof STMultibitPartialExpression) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("ST_EXTEND_LIFETIME(");
            CharSequence _generateExpression = this.generateExpression(argument.getArgument());
            _builder_2.append((Object)_generateExpression);
            _builder_2.append(")");
            _switchResult = _builder_2;
        }
        if (!_matched) {
            _switchResult = this.generateExpression(argument.getArgument());
        }
        return _switchResult;
    }

    protected CharSequence _generateExpression(STMultibitPartialExpression expr) {
        boolean _tripleNotEquals;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        AccessMode _accessMode = STCoreUtil.getAccessMode((STExpression)expr);
        boolean bl = _notEquals = !Objects.equals(_accessMode, AccessMode.WRITE);
        if (_notEquals) {
            _builder.append("c");
        }
        _builder.append("partial<");
        CharSequence _generateMultiBitAccessSpecifier = this.generateMultiBitAccessSpecifier(expr.getSpecifier());
        _builder.append((Object)_generateMultiBitAccessSpecifier);
        _builder.append(">(");
        STExpression _expression = expr.getExpression();
        boolean bl2 = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            CharSequence _generateExpression = this.generateExpression(expr.getExpression());
            _builder.append((Object)_generateExpression);
        } else {
            BigInteger _index = expr.getIndex();
            _builder.append((Object)_index);
        }
        _builder.append(")");
        return _builder;
    }

    protected CharSequence generateMultiBitAccessSpecifier(STMultiBitAccessSpecifier spec) {
        String _switchResult = null;
        boolean _matched = false;
        if (Objects.equals(spec, null)) {
            _matched = true;
        }
        if (!_matched && Objects.equals(spec, STMultiBitAccessSpecifier.X)) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = "CIEC_BOOL";
        }
        if (!_matched && Objects.equals(spec, STMultiBitAccessSpecifier.B)) {
            _matched = true;
            _switchResult = "CIEC_BYTE";
        }
        if (!_matched && Objects.equals(spec, STMultiBitAccessSpecifier.W)) {
            _matched = true;
            _switchResult = "CIEC_WORD";
        }
        if (!_matched && Objects.equals(spec, STMultiBitAccessSpecifier.D)) {
            _matched = true;
            _switchResult = "CIEC_DWORD";
        }
        if (!_matched && Objects.equals(spec, STMultiBitAccessSpecifier.L)) {
            _matched = true;
            _switchResult = "CIEC_LWORD";
        }
        return _switchResult;
    }

    protected CharSequence _generateExpression(STNumericLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        Object _value = expr.getValue();
        _builder.append(_value);
        _builder.append("_");
        String _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain((LibraryElement)expr.getResultType());
        _builder.append(_generateTypeNamePlain);
        return _builder;
    }

    protected CharSequence _generateExpression(STStringLiteral expr) {
        String _convertToJavaString;
        StringConcatenation _builder;
        StringConcatenation _xblockexpression = null;
        LibraryElement type = expr.getResultType();
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        if (type instanceof StringType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("\"");
            _convertToJavaString = Strings.convertToJavaString((String)expr.getValue().toString());
            _builder.append(_convertToJavaString);
            _builder.append("\"_STRING");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof WstringType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("u\"");
            _convertToJavaString = Strings.convertToJavaString((String)expr.getValue().toString());
            _builder.append(_convertToJavaString);
            _builder.append("\"_WSTRING");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof CharType) {
            _matched = true;
            _builder = new StringConcatenation();
            String _format = String.format("0x%02x", expr.getValue().toString().getBytes(StandardCharsets.UTF_8)[0]);
            _builder.append(_format);
            _builder.append("_CHAR");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof WcharType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("u'");
            _convertToJavaString = Strings.convertToJavaString((String)expr.getValue().toString());
            _builder.append(_convertToJavaString);
            _builder.append("'_WCHAR");
            _switchResult = _builder;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected CharSequence _generateExpression(STDateLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        long _epochSecond = expr.getValue().toEpochSecond(LocalTime.MIDNIGHT, ZoneOffset.UTC);
        long _multiply = _epochSecond * 1000000000L;
        _builder.append((Object)_multiply);
        _builder.append("_");
        String _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain((LibraryElement)expr.getResultType());
        _builder.append(_generateTypeNamePlain);
        return _builder;
    }

    protected CharSequence _generateExpression(STTimeLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        long _nanos = expr.getValue().toNanos();
        _builder.append((Object)_nanos);
        _builder.append("_");
        String _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain((LibraryElement)expr.getResultType());
        _builder.append(_generateTypeNamePlain);
        return _builder;
    }

    protected CharSequence _generateExpression(STTimeOfDayLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        long _nanoOfDay = expr.getValue().toNanoOfDay();
        _builder.append((Object)_nanoOfDay);
        _builder.append("_");
        String _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain((LibraryElement)expr.getResultType());
        _builder.append(_generateTypeNamePlain);
        return _builder;
    }

    protected CharSequence _generateExpression(STDateAndTimeLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        long _until = LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC).until(expr.getValue(), ChronoUnit.NANOS);
        _builder.append((Object)_until);
        _builder.append("_");
        String _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain((LibraryElement)expr.getResultType());
        _builder.append(_generateTypeNamePlain);
        return _builder;
    }

    protected CharSequence _generateTemplateExpression(STBinaryExpression expr) {
        StringConcatenation _switchResult = null;
        STBinaryOperator _op = expr.getOp();
        if (_op != null) {
            switch (_op) {
                case RANGE: {
                    StringConcatenation _builder = new StringConcatenation();
                    CharSequence _generateTemplateExpression = this.generateTemplateExpression(expr.getLeft());
                    _builder.append((Object)_generateTemplateExpression);
                    _builder.append(", ");
                    CharSequence _generateTemplateExpression_1 = this.generateTemplateExpression(expr.getRight());
                    _builder.append((Object)_generateTemplateExpression_1);
                    _switchResult = _builder;
                    break;
                }
                case AMPERSAND: {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("AND(");
                    CharSequence _generateTemplateExpression_2 = this.generateTemplateExpression(expr.getLeft());
                    _builder_1.append((Object)_generateTemplateExpression_2);
                    _builder_1.append(", ");
                    CharSequence _generateTemplateExpression_3 = this.generateTemplateExpression(expr.getRight());
                    _builder_1.append((Object)_generateTemplateExpression_3);
                    _builder_1.append(")");
                    _switchResult = _builder_1;
                    break;
                }
                default: {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    String _name = expr.getOp().getName();
                    _builder_2.append(_name);
                    _builder_2.append("(");
                    CharSequence _generateTemplateExpression_4 = this.generateTemplateExpression(expr.getLeft());
                    _builder_2.append((Object)_generateTemplateExpression_4);
                    _builder_2.append(", ");
                    CharSequence _generateTemplateExpression_5 = this.generateTemplateExpression(expr.getRight());
                    _builder_2.append((Object)_generateTemplateExpression_5);
                    _builder_2.append(")");
                    _switchResult = _builder_2;
                    break;
                }
            }
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            String _name = expr.getOp().getName();
            _builder_2.append(_name);
            _builder_2.append("(");
            CharSequence _generateTemplateExpression_4 = this.generateTemplateExpression(expr.getLeft());
            _builder_2.append((Object)_generateTemplateExpression_4);
            _builder_2.append(", ");
            CharSequence _generateTemplateExpression_5 = this.generateTemplateExpression(expr.getRight());
            _builder_2.append((Object)_generateTemplateExpression_5);
            _builder_2.append(")");
            _switchResult = _builder_2;
        }
        return _switchResult;
    }

    protected CharSequence _generateTemplateExpression(STUnaryExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = expr.getOp().getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _generateTemplateExpression = this.generateTemplateExpression(expr.getExpression());
        _builder.append((Object)_generateTemplateExpression);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateTemplateExpression(STNumericLiteral expr) {
        return expr.getValue().toString();
    }

    protected CharSequence _generateVariableDefaultValue(INamedElement feature) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The variable ");
        String _name = feature.eClass().getName();
        _builder.append(_name);
        _builder.append(" is not supported");
        this.errors.add(_builder.toString());
        _xblockexpression = "0";
        return _xblockexpression;
    }

    protected CharSequence _generateVariableDefaultValue(VarDeclaration variable) {
        try {
            CharSequence _xblockexpression = null;
            Function<VarDeclaration, ILanguageSupport> _function = it -> new VarDeclarationSupport((VarDeclaration)it);
            ILanguageSupport support = this.variableLanguageSupport.computeIfAbsent(variable, _function);
            CharSequence result = support.generate(CollectionLiterals.emptyMap());
            this.errors.addAll(support.getErrors());
            this.warnings.addAll(support.getWarnings());
            this.infos.addAll(support.getInfos());
            _xblockexpression = result;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected CharSequence _generateVariableDefaultValue(STVarDeclaration variable) {
        CharSequence _xifexpression = null;
        STInitializerExpression _defaultValue = variable.getDefaultValue();
        boolean _tripleNotEquals = _defaultValue != null;
        _xifexpression = _tripleNotEquals ? this.generateInitializerExpression(variable.getDefaultValue()) : this.generateTypeDefaultValue((INamedElement)STCoreUtil.getFeatureType((INamedElement)variable));
        return _xifexpression;
    }

    protected CharSequence _generateFeatureName(INamedElement feature) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The feature ");
        String _name = feature.eClass().getName();
        _builder.append(_name);
        _builder.append(" is not supported");
        this.errors.add(_builder.toString());
        _xblockexpression = "";
        return _xblockexpression;
    }

    protected CharSequence _generateFeatureName(VarDeclaration feature) {
        return ForteNgExportUtil.generateName((IInterfaceElement)feature);
    }

    protected CharSequence _generateFeatureName(STVarDeclaration feature) {
        String _name;
        StringConcatenation _builder;
        StringConcatenation _switchResult = null;
        EObject _eContainer = feature.eContainer();
        boolean _matched = false;
        if (_eContainer instanceof STVarGlobalDeclarationBlock) {
            _matched = true;
            _builder = new StringConcatenation();
            CharSequence _generateDefiningTypeName = ForteNgExportUtil.generateDefiningTypeName((EObject)feature);
            _builder.append((Object)_generateDefiningTypeName);
            _builder.append("::var_");
            String _name2 = feature.getName();
            _builder.append(_name2);
            _switchResult = _builder;
        }
        if (!_matched && _eContainer instanceof STVarOutputDeclarationBlock) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("(*st_lv_");
            _name = feature.getName();
            _builder.append(_name);
            _builder.append(")");
            _switchResult = _builder;
        }
        if (!_matched) {
            _builder = new StringConcatenation();
            _builder.append("st_lv_");
            _name = feature.getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        return _switchResult;
    }

    protected CharSequence _generateFeatureName(STFunction feature) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("func_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateFeatureName(FunctionFBType feature) {
        StringConcatenation _builder = new StringConcatenation();
        String _generateTypeNamespace = ForteNgExportUtil.generateTypeNamespace((LibraryElement)feature);
        _builder.append(_generateTypeNamespace);
        _builder.append("::func_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateFeatureName(STStandardFunction feature) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("func_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateFeatureName(STMethod feature) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("method_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateFeatureName(FB feature) {
        return ForteNgExportUtil.generateName((BlockFBNetworkElement)feature);
    }

    protected CharSequence _generateFeatureName(Event feature) {
        return ForteNgExportUtil.generateName((IInterfaceElement)feature);
    }

    protected CharSequence _generateFeatureName(AdapterDeclaration feature) {
        return ForteNgExportUtil.generateName((IInterfaceElement)feature);
    }

    protected CharSequence _generateFeatureTypeName(VarDeclaration variable) {
        return ForteNgExportUtil.generateTypeName((LibraryElement)VariableOperations.evaluateResultType((VarDeclaration)variable));
    }

    protected CharSequence _generateFeatureTypeName(STVarDeclaration variable) {
        return ForteNgExportUtil.generateTypeName((LibraryElement)STVariableOperations.evaluateResultType((STVarDeclaration)variable));
    }

    protected CharSequence generateParameterName(STVarDeclaration feature) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("st_lv_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence generateParameterTypeName(STVarDeclaration variable) {
        StringConcatenation _builder;
        StringConcatenation _xblockexpression = null;
        LibraryElement type = STVariableOperations.evaluateResultType((STVarDeclaration)variable);
        StringConcatenation _switchResult = null;
        EObject _eContainer = variable.eContainer();
        boolean _matched = false;
        if (_eContainer instanceof STVarInputDeclarationBlock) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("const ");
            CharSequence _generateTypeNameAsInputParameter = ForteNgExportUtil.generateTypeNameAsInputParameter((LibraryElement)type);
            _builder.append((Object)_generateTypeNameAsInputParameter);
            _builder.append(" &");
            _switchResult = _builder;
        }
        if (!_matched && _eContainer instanceof STVarInOutDeclarationBlock) {
            _matched = true;
            _builder = new StringConcatenation();
            CharSequence _generateTypeNameAsInOutParameter = ForteNgExportUtil.generateTypeNameAsInOutParameter((LibraryElement)type);
            _builder.append((Object)_generateTypeNameAsInOutParameter);
            _builder.append(" &");
            _switchResult = _builder;
        }
        if (!_matched && _eContainer instanceof STVarOutputDeclarationBlock) {
            _matched = true;
            _builder = new StringConcatenation();
            CharSequence _generateTypeNameAsOutputParameter = ForteNgExportUtil.generateTypeNameAsOutputParameter((LibraryElement)type);
            _builder.append((Object)_generateTypeNameAsOutputParameter);
            _builder.append(" ");
            _switchResult = _builder;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected CharSequence generateOutputGuard(Iterable<? extends STVarDeclarationBlock> blocks) {
        StringConcatenation _builder = new StringConcatenation();
        for (STVarDeclarationBlock sTVarDeclarationBlock : blocks) {
            CharSequence _generateOutputGuard = this.generateOutputGuard(sTVarDeclarationBlock);
            _builder.append((Object)_generateOutputGuard);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateOutputGuard(STVarDeclarationBlock block) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)block.getVarDeclarations(), STVarDeclaration.class);
        for (STVarDeclaration variable : _filter) {
            CharSequence _generateOutputGuard = this.generateOutputGuard(variable);
            _builder.append((Object)_generateOutputGuard);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateOutputGuard(STVarDeclaration variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("COutputGuard st_guard_");
        String _name = variable.getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _generateParameterName = this.generateParameterName(variable);
        _builder.append((Object)_generateParameterName);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateTypeDefaultValue(INamedElement type) {
        CharSequence _generateTypeName;
        boolean _isAnyType;
        Object _switchResult = null;
        boolean _matched = false;
        if (type instanceof DataType && (_isAnyType = IecTypes.GenericTypes.isAnyType((DataType)((DataType)type)))) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _generateTypeName2 = ForteNgExportUtil.generateTypeName((LibraryElement)((LibraryElement)type));
            _builder.append((Object)_generateTypeName2);
            _builder.append("()");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof StringType) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\"\"_STRING");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof WstringType) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("u\"\"_WSTRING");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof CharType) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("'\\0'_CHAR");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof WcharType) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("u'\\0'_WCHAR");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof AnyElementaryType) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("0_");
            String _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain((LibraryElement)((LibraryElement)type));
            _builder.append(_generateTypeNamePlain);
            _switchResult = _builder;
        }
        if (!_matched && type instanceof ArrayType) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)((LibraryElement)type));
            _builder.append((Object)_generateTypeName);
            _builder.append("{}");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof StructuredType) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)((LibraryElement)type));
            _builder.append((Object)_generateTypeName);
            _builder.append("()");
            _switchResult = _builder;
        }
        if (!_matched) {
            _switchResult = "0";
        }
        return _switchResult;
    }

    protected int getIntegerFromConstantExpression(STExpression expr) {
        int _xtrycatchfinallyexpression = 0;
        try {
            Object _value = ((STNumericLiteral)expr).getValue();
            _xtrycatchfinallyexpression = ((BigInteger)_value).intValueExact();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                int _xblockexpression = 0;
                this.errors.add("Not a constant integer expression");
                _xtrycatchfinallyexpression = _xblockexpression = 1;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    protected Set<INamedElement> getContainedDependencies(EObject object) {
        Functions.Function1 _function = it -> this.getDependencies((EObject)it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IteratorExtensions.toIterable((Iterator)EcoreUtil.getAllProperContents((EObject)object, (boolean)true)), (Functions.Function1)_function));
    }

    protected Iterable<INamedElement> getDependencies(EObject object) {
        LibraryElement _resultType;
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        if (object instanceof STVarDeclaration) {
            _matched = true;
            LibraryElement _featureType = STCoreUtil.getFeatureType((INamedElement)((INamedElement)object));
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_featureType}));
        }
        if (!_matched && object instanceof STStructInitializerExpression) {
            _matched = true;
            Functions.Function1 _function = it -> {
                STInitializerExpression _value = (STInitializerExpression)it.getValue();
                return _value == null;
            };
            Functions.Function1 _function_1 = it -> this.getDefaultDependencies((INamedElement)it.getKey());
            _switchResult = IterableExtensions.flatMap((Iterable)IterableExtensions.filter(((STStructInitializerExpression)object).getMappedStructInitElements().entrySet(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        }
        if (!_matched && object instanceof STNumericLiteral) {
            _matched = true;
            _resultType = ((STNumericLiteral)object).getResultType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_resultType}));
        }
        if (!_matched && object instanceof STStringLiteral) {
            _matched = true;
            _resultType = ((STStringLiteral)object).getResultType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_resultType}));
        }
        if (!_matched && object instanceof STDateLiteral) {
            _matched = true;
            _resultType = ((STDateLiteral)object).getResultType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_resultType}));
        }
        if (!_matched && object instanceof STTimeLiteral) {
            _matched = true;
            _resultType = ((STTimeLiteral)object).getResultType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_resultType}));
        }
        if (!_matched && object instanceof STTimeOfDayLiteral) {
            _matched = true;
            _resultType = ((STTimeOfDayLiteral)object).getResultType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_resultType}));
        }
        if (!_matched && object instanceof STDateAndTimeLiteral) {
            _matched = true;
            _resultType = ((STDateAndTimeLiteral)object).getResultType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_resultType}));
        }
        if (!_matched && object instanceof STFeatureExpression) {
            _matched = true;
            _switchResult = this.getFeatureDependencies(((STFeatureExpression)object).getFeature());
        }
        if (!_matched && object instanceof STFunction) {
            boolean _tripleNotEquals;
            _matched = true;
            Collection<Object> _xifexpression = null;
            DataType _returnType = ((STFunction)object).getReturnType();
            boolean bl = _tripleNotEquals = _returnType != null;
            if (_tripleNotEquals) {
                DataType _returnType_1 = ((STFunction)object).getReturnType();
                _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_returnType_1}));
            } else {
                _xifexpression = CollectionLiterals.emptySet();
            }
            _switchResult = _xifexpression;
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.emptySet();
        }
        return _switchResult;
    }

    protected Iterable<INamedElement> getFeatureDependencies(INamedElement feature) {
        Iterable<INamedElement> _parameterDependencies;
        EObject _eContainer;
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        if (feature instanceof VarDeclaration) {
            _matched = true;
            Function<VarDeclaration, ILanguageSupport> _function = it -> new VarDeclarationSupport((VarDeclaration)it);
            Pair _mappedTo = Pair.of((Object)"header", (Object)Boolean.TRUE);
            _switchResult = this.variableLanguageSupport.computeIfAbsent((VarDeclaration)feature, _function).getDependencies(Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
        }
        if (!_matched && feature instanceof STVarDeclaration && (_eContainer = ((STVarDeclaration)feature).eContainer()) instanceof STVarGlobalDeclarationBlock) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{feature}));
        }
        if (!_matched && feature instanceof STVarDeclaration) {
            _matched = true;
            LibraryElement _featureType = STCoreUtil.getFeatureType((INamedElement)feature);
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_featureType}));
        }
        if (!_matched && feature instanceof STFunction) {
            _matched = true;
            _parameterDependencies = this.getParameterDependencies((ICallable)feature);
            _switchResult = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new STFunction[]{(STFunction)feature})), _parameterDependencies);
        }
        if (!_matched && feature instanceof FunctionFBType) {
            _matched = true;
            _parameterDependencies = this.getParameterDependencies((ICallable)feature);
            _switchResult = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new FunctionFBType[]{(FunctionFBType)feature})), _parameterDependencies);
        }
        if (!_matched && feature instanceof ICallable) {
            _matched = true;
            _switchResult = this.getParameterDependencies((ICallable)feature);
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.emptySet();
        }
        return _switchResult;
    }

    protected Iterable<INamedElement> getParameterDependencies(ICallable feature) {
        EList _inputParameters = feature.getInputParameters();
        EList _outputParameters = feature.getOutputParameters();
        Iterable _plus = Iterables.concat((Iterable)_inputParameters, (Iterable)_outputParameters);
        EList _inOutParameters = feature.getInOutParameters();
        Functions.Function1 _function = it -> this.getDefaultDependencies((INamedElement)it);
        Functions.Function1 _function_1 = it -> STCoreUtil.isAnyType((INamedElement)it);
        return IterableExtensions.reject((Iterable)IterableExtensions.flatMap((Iterable)Iterables.concat((Iterable)_plus, (Iterable)_inOutParameters), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    protected Iterable<INamedElement> getDefaultDependencies(INamedElement feature) {
        Iterable _switchResult = null;
        boolean _matched = false;
        if (feature instanceof VarDeclaration) {
            _matched = true;
            Function<VarDeclaration, ILanguageSupport> _function = it -> new VarDeclarationSupport((VarDeclaration)it);
            _switchResult = this.variableLanguageSupport.computeIfAbsent((VarDeclaration)feature, _function).getDependencies(CollectionLiterals.emptyMap());
        }
        if (!_matched && feature instanceof STVarDeclaration) {
            _matched = true;
            LibraryElement _featureType = STCoreUtil.getFeatureType((INamedElement)feature);
            Set<INamedElement> _containedDependencies = this.getContainedDependencies((EObject)feature);
            _switchResult = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new LibraryElement[]{_featureType})), _containedDependencies);
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.emptySet();
        }
        return _switchResult;
    }

    protected CharSequence generateLineDirective(EObject element) {
        String _xblockexpression = null;
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)element);
        Resource _eResource = element.eResource();
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        String _lastSegment = null;
        if (_uRI != null) {
            _lastSegment = _uRI.lastSegment();
        }
        String sourceName = _lastSegment;
        String _xifexpression = null;
        if (node != null && sourceName != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#line ");
            int _startLine = node.getStartLine();
            _builder.append((Object)_startLine);
            _builder.append(" \"");
            _builder.append(sourceName);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            String _xifexpression_1 = null;
            if (node != null) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("#line ");
                int _startLine_1 = node.getStartLine();
                _builder_1.append((Object)_startLine_1);
                _builder_1.append(" \"unknown\"");
                _builder_1.newLineIfNotEmpty();
                _xifexpression_1 = _builder_1;
            } else {
                _xifexpression_1 = "";
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected CharSequence generateUniqueVariableName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("st_lv_synthetic_");
        int _plusPlus = this.uniqueVariableIndex++;
        _builder.append((Object)_plusPlus);
        return _builder;
    }

    @XbaseGenerated
    protected CharSequence generateInitializerExpression(STInitializerExpression expr) {
        if (expr instanceof STArrayInitializerExpression) {
            return this._generateInitializerExpression((STArrayInitializerExpression)expr);
        }
        if (expr instanceof STElementaryInitializerExpression) {
            return this._generateInitializerExpression((STElementaryInitializerExpression)expr);
        }
        if (expr instanceof STStructInitializerExpression) {
            return this._generateInitializerExpression((STStructInitializerExpression)expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }

    @XbaseGenerated
    protected CharSequence generateArrayInitElement(STArrayInitElement elem) {
        if (elem instanceof STRepeatArrayInitElement) {
            return this._generateArrayInitElement((STRepeatArrayInitElement)elem);
        }
        if (elem instanceof STSingleArrayInitElement) {
            return this._generateArrayInitElement((STSingleArrayInitElement)elem);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(elem).toString());
    }

    @XbaseGenerated
    protected CharSequence generateStatement(STStatement stmt) {
        if (stmt instanceof STCaseStatement) {
            return this._generateStatement((STCaseStatement)stmt);
        }
        if (stmt instanceof STContinue) {
            return this._generateStatement((STContinue)stmt);
        }
        if (stmt instanceof STExit) {
            return this._generateStatement((STExit)stmt);
        }
        if (stmt instanceof STExpression) {
            return this._generateStatement((STExpression)stmt);
        }
        if (stmt instanceof STForStatement) {
            return this._generateStatement((STForStatement)stmt);
        }
        if (stmt instanceof STIfStatement) {
            return this._generateStatement((STIfStatement)stmt);
        }
        if (stmt instanceof STNop) {
            return this._generateStatement((STNop)stmt);
        }
        if (stmt instanceof STRepeatStatement) {
            return this._generateStatement((STRepeatStatement)stmt);
        }
        if (stmt instanceof STReturn) {
            return this._generateStatement((STReturn)stmt);
        }
        if (stmt instanceof STWhileStatement) {
            return this._generateStatement((STWhileStatement)stmt);
        }
        if (stmt != null) {
            return this._generateStatement(stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    @XbaseGenerated
    protected CharSequence generateExpression(STExpression expr) {
        if (expr instanceof STArrayAccessExpression) {
            return this._generateExpression((STArrayAccessExpression)expr);
        }
        if (expr instanceof STAssignment) {
            return this._generateExpression((STAssignment)expr);
        }
        if (expr instanceof STBinaryExpression) {
            return this._generateExpression((STBinaryExpression)expr);
        }
        if (expr instanceof STBuiltinFeatureExpression) {
            return this._generateExpression((STBuiltinFeatureExpression)expr);
        }
        if (expr instanceof STDateAndTimeLiteral) {
            return this._generateExpression((STDateAndTimeLiteral)expr);
        }
        if (expr instanceof STDateLiteral) {
            return this._generateExpression((STDateLiteral)expr);
        }
        if (expr instanceof STFeatureExpression) {
            return this._generateExpression((STFeatureExpression)expr);
        }
        if (expr instanceof STMemberAccessExpression) {
            return this._generateExpression((STMemberAccessExpression)expr);
        }
        if (expr instanceof STMultibitPartialExpression) {
            return this._generateExpression((STMultibitPartialExpression)expr);
        }
        if (expr instanceof STNumericLiteral) {
            return this._generateExpression((STNumericLiteral)expr);
        }
        if (expr instanceof STStringLiteral) {
            return this._generateExpression((STStringLiteral)expr);
        }
        if (expr instanceof STTimeLiteral) {
            return this._generateExpression((STTimeLiteral)expr);
        }
        if (expr instanceof STTimeOfDayLiteral) {
            return this._generateExpression((STTimeOfDayLiteral)expr);
        }
        if (expr instanceof STUnaryExpression) {
            return this._generateExpression((STUnaryExpression)expr);
        }
        if (expr != null) {
            return this._generateExpression(expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }

    @XbaseGenerated
    protected CharSequence generateTemplateExpression(STExpression expr) {
        if (expr instanceof STBinaryExpression) {
            return this._generateTemplateExpression((STBinaryExpression)expr);
        }
        if (expr instanceof STNumericLiteral) {
            return this._generateTemplateExpression((STNumericLiteral)expr);
        }
        if (expr instanceof STUnaryExpression) {
            return this._generateTemplateExpression((STUnaryExpression)expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }

    @XbaseGenerated
    protected CharSequence generateVariableDefaultValue(INamedElement variable) {
        if (variable instanceof VarDeclaration) {
            return this._generateVariableDefaultValue((VarDeclaration)variable);
        }
        if (variable instanceof STVarDeclaration) {
            return this._generateVariableDefaultValue((STVarDeclaration)variable);
        }
        if (variable != null) {
            return this._generateVariableDefaultValue(variable);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(variable).toString());
    }

    @XbaseGenerated
    protected CharSequence generateFeatureName(INamedElement feature) {
        if (feature instanceof FB) {
            return this._generateFeatureName((FB)feature);
        }
        if (feature instanceof AdapterDeclaration) {
            return this._generateFeatureName((AdapterDeclaration)feature);
        }
        if (feature instanceof Event) {
            return this._generateFeatureName((Event)feature);
        }
        if (feature instanceof FunctionFBType) {
            return this._generateFeatureName((FunctionFBType)feature);
        }
        if (feature instanceof VarDeclaration) {
            return this._generateFeatureName((VarDeclaration)feature);
        }
        if (feature instanceof STMethod) {
            return this._generateFeatureName((STMethod)feature);
        }
        if (feature instanceof STStandardFunction) {
            return this._generateFeatureName((STStandardFunction)feature);
        }
        if (feature instanceof STVarDeclaration) {
            return this._generateFeatureName((STVarDeclaration)feature);
        }
        if (feature instanceof STFunction) {
            return this._generateFeatureName((STFunction)feature);
        }
        if (feature != null) {
            return this._generateFeatureName(feature);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(feature).toString());
    }

    @XbaseGenerated
    protected CharSequence generateFeatureTypeName(ITypedElement variable) {
        if (variable instanceof VarDeclaration) {
            return this._generateFeatureTypeName((VarDeclaration)variable);
        }
        if (variable instanceof STVarDeclaration) {
            return this._generateFeatureTypeName((STVarDeclaration)variable);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(variable).toString());
    }

    @Pure
    public List<String> getErrors() {
        return this.errors;
    }

    @Pure
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Pure
    public List<String> getInfos() {
        return this.infos;
    }
}

