/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.rectpacking.options.OptimizationGoal;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.elk.alg.rectpacking.p1widthapproximation.WidthApproximationStrategy;
import org.eclipse.elk.alg.rectpacking.p2packing.PackingStrategy;
import org.eclipse.elk.alg.rectpacking.p3whitespaceelimination.WhiteSpaceEliminationStrategy;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class RectPackingMetaDataProvider
implements ILayoutMetaDataProvider {
    private static final boolean TRYBOX_DEFAULT = false;
    public static final IProperty<Boolean> TRYBOX = new Property("org.eclipse.elk.rectpacking.trybox", (Object)false, null, null);
    private static final int CURRENT_POSITION_DEFAULT = -1;
    private static final Comparable<? super Integer> CURRENT_POSITION_LOWER_BOUND = -1;
    public static final IProperty<Integer> CURRENT_POSITION = new Property("org.eclipse.elk.rectpacking.currentPosition", (Object)-1, CURRENT_POSITION_LOWER_BOUND, null);
    private static final int DESIRED_POSITION_DEFAULT = -1;
    private static final Comparable<? super Integer> DESIRED_POSITION_LOWER_BOUND = -1;
    public static final IProperty<Integer> DESIRED_POSITION = new Property("org.eclipse.elk.rectpacking.desiredPosition", (Object)-1, DESIRED_POSITION_LOWER_BOUND, null);
    private static final boolean IN_NEW_ROW_DEFAULT = false;
    public static final IProperty<Boolean> IN_NEW_ROW = new Property("org.eclipse.elk.rectpacking.inNewRow", (Object)false, null, null);
    private static final boolean ORDER_BY_SIZE_DEFAULT = false;
    public static final IProperty<Boolean> ORDER_BY_SIZE = new Property("org.eclipse.elk.rectpacking.orderBySize", (Object)false, null, null);
    private static final WidthApproximationStrategy WIDTH_APPROXIMATION_STRATEGY_DEFAULT = WidthApproximationStrategy.GREEDY;
    public static final IProperty<WidthApproximationStrategy> WIDTH_APPROXIMATION_STRATEGY = new Property("org.eclipse.elk.rectpacking.widthApproximation.strategy", (Object)WIDTH_APPROXIMATION_STRATEGY_DEFAULT, null, null);
    private static final double WIDTH_APPROXIMATION_TARGET_WIDTH_DEFAULT = -1.0;
    public static final IProperty<Double> WIDTH_APPROXIMATION_TARGET_WIDTH = new Property("org.eclipse.elk.rectpacking.widthApproximation.targetWidth", (Object)-1.0, null, null);
    private static final OptimizationGoal WIDTH_APPROXIMATION_OPTIMIZATION_GOAL_DEFAULT = OptimizationGoal.MAX_SCALE_DRIVEN;
    public static final IProperty<OptimizationGoal> WIDTH_APPROXIMATION_OPTIMIZATION_GOAL = new Property("org.eclipse.elk.rectpacking.widthApproximation.optimizationGoal", (Object)WIDTH_APPROXIMATION_OPTIMIZATION_GOAL_DEFAULT, null, null);
    private static final boolean WIDTH_APPROXIMATION_LAST_PLACE_SHIFT_DEFAULT = true;
    public static final IProperty<Boolean> WIDTH_APPROXIMATION_LAST_PLACE_SHIFT = new Property("org.eclipse.elk.rectpacking.widthApproximation.lastPlaceShift", (Object)true, null, null);
    private static final PackingStrategy PACKING_STRATEGY_DEFAULT = PackingStrategy.COMPACTION;
    public static final IProperty<PackingStrategy> PACKING_STRATEGY = new Property("org.eclipse.elk.rectpacking.packing.strategy", (Object)PACKING_STRATEGY_DEFAULT, null, null);
    private static final boolean PACKING_COMPACTION_ROW_HEIGHT_REEVALUATION_DEFAULT = false;
    public static final IProperty<Boolean> PACKING_COMPACTION_ROW_HEIGHT_REEVALUATION = new Property("org.eclipse.elk.rectpacking.packing.compaction.rowHeightReevaluation", (Object)false, null, null);
    private static final int PACKING_COMPACTION_ITERATIONS_DEFAULT = 1;
    private static final Comparable<? super Integer> PACKING_COMPACTION_ITERATIONS_LOWER_BOUND = 1;
    public static final IProperty<Integer> PACKING_COMPACTION_ITERATIONS = new Property("org.eclipse.elk.rectpacking.packing.compaction.iterations", (Object)1, PACKING_COMPACTION_ITERATIONS_LOWER_BOUND, null);
    private static final WhiteSpaceEliminationStrategy WHITE_SPACE_ELIMINATION_STRATEGY_DEFAULT = WhiteSpaceEliminationStrategy.NONE;
    public static final IProperty<WhiteSpaceEliminationStrategy> WHITE_SPACE_ELIMINATION_STRATEGY = new Property("org.eclipse.elk.rectpacking.whiteSpaceElimination.strategy", (Object)WHITE_SPACE_ELIMINATION_STRATEGY_DEFAULT, null, null);

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.trybox").group("").name("Try box layout first").description("Whether one should check whether the regions are stackable to see whether box layout would do the job. For example, nodes with the same height are not stackable inside a row. Therefore, box layout will perform better and faster.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.currentPosition").group("").name("Current position of a node in the order of nodes").description("The rectangles are ordered. Normally according to their definition the the model. This option specifies the current position of a node.").defaultValue((Object)-1).lowerBound(CURRENT_POSITION_LOWER_BOUND).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.HIDDEN).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.desiredPosition").group("").name("Desired index of node").description("The rectangles are ordered. Normally according to their definition the the model. This option allows to specify a desired position that has preference over the original position.").defaultValue((Object)-1).lowerBound(DESIRED_POSITION_LOWER_BOUND).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.inNewRow").group("").name("In new Row").description("If set to true this node begins in a new row. Consequently this node cannot be moved in a previous layer during compaction. Width approximation does does not take this into account.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.orderBySize").group("").name("Order nodes by height").description("If set to true the nodes will be sorted by their height before computing the layout. The largest node will be in the first position.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.widthApproximation.strategy").group("widthApproximation").name("Width Approximation Strategy").description("Strategy for finding an initial width of the drawing.").defaultValue((Object)WIDTH_APPROXIMATION_STRATEGY_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(WidthApproximationStrategy.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.widthApproximation.targetWidth").group("widthApproximation").name("Target Width").description("Option to place the rectangles in the given target width instead of approximating the width using the desired aspect ratio. The padding is not included in this. Meaning a drawing will have width of targetwidth + horizontal padding.").defaultValue((Object)-1.0).type(LayoutOptionData.Type.DOUBLE).optionClass(Double.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.widthApproximation.optimizationGoal").group("widthApproximation").name("Optimization Goal").description("Optimization goal for approximation of the bounding box given by the first iteration. Determines whether layout is sorted by the maximum scaling, aspect ratio, or area. Depending on the strategy the aspect ratio might be nearly ignored.").defaultValue((Object)WIDTH_APPROXIMATION_OPTIMIZATION_GOAL_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(OptimizationGoal.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.widthApproximation.lastPlaceShift").group("widthApproximation").name("Shift Last Placed.").description("When placing a rectangle behind or below the last placed rectangle in the first iteration, it is sometimes possible to shift the rectangle further to the left or right, resulting in less whitespace. True (default) enables the shift and false disables it. Disabling the shift produces a greater approximated area by the first iteration and a layout, when using ONLY the first iteration (default not the case), where it is sometimes impossible to implement a size transformation of rectangles that will fill the bounding box and eliminate empty spaces.").defaultValue((Object)true).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.packing.strategy").group("packing").name("Compaction Strategy").description("Strategy for finding an initial placement on nodes.").defaultValue((Object)PACKING_STRATEGY_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(PackingStrategy.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.packing.compaction.rowHeightReevaluation").group("packing.compaction").name("Row Height Reevaluation").description("During the compaction step the height of a row is normally not changed. If this options is set, the blocks of other rows might be added if they exceed the row height. If this is the case the whole row has to be packed again to be optimal regarding the new row height. This option should, therefore, be used with care since it might be computation heavy.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.packing.compaction.iterations").group("packing.compaction").name("Compaction iterations").description("Defines the number of compaction iterations. E.g. if set to 2 the width is initially approximated, then the drawing is compacted and based on the resulting drawing the target width is decreased or increased and a second compaction step is executed and the result compared to the first one. The best run is used based on the scale measure.").defaultValue((Object)1).lowerBound(PACKING_COMPACTION_ITERATIONS_LOWER_BOUND).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.whiteSpaceElimination.strategy").group("whiteSpaceElimination").name("White Space Approximation Strategy").description("Strategy for expanding nodes such that whitespace in the parent is eliminated.").defaultValue((Object)WHITE_SPACE_ELIMINATION_STRATEGY_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(WhiteSpaceEliminationStrategy.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        new RectPackingOptions().apply(registry);
    }
}

