/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.attributetypeeditor.editors;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.attributetypeeditor.Messages;
import org.eclipse.fordiac.ide.attributetypeeditor.widgets.DirectlyDerivedTypeComposite;
import org.eclipse.fordiac.ide.datatypeeditor.widgets.StructEditingComposite;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeDeclarationTypeCommand;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.typeeditor.AbstractTypeEditorPage;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorSite;

public class AttributeTypeEditorPage
extends AbstractTypeEditorPage {
    private static final int STRUCT_EDITOR_INDEX = 0;
    private static final int DIRECTLYDERIVEDTYPE_EDITOR_INDEX = 1;
    private GraphicalAnnotationModel annotationModel;
    private StructEditingComposite structComposite;
    private DirectlyDerivedTypeComposite directlyDerivedTypeComposite;
    private Combo comboBox;
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getOldValue() instanceof AnyDerivedType && notification.getNewValue() instanceof AnyDerivedType) {
                if (notification.getNewValue() instanceof StructuredType) {
                    AttributeTypeEditorPage.this.comboBox.select(0);
                } else {
                    AttributeTypeEditorPage.this.comboBox.select(1);
                }
                AttributeTypeEditorPage.this.changeEditingComposite();
            }
        }
    };

    public void dispose() {
        this.removeListenerFromAttributeDeclaration();
        if (this.structComposite != null) {
            this.structComposite.dispose();
        }
        if (this.directlyDerivedTypeComposite != null) {
            this.directlyDerivedTypeComposite.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.addListenerToAttributeDeclaration();
        this.setPartName(Messages.AttributeTypeEditorPage_Title);
        this.setTitleImage(FordiacImage.ICON_ATTRIBUTE_DECLARATION.getImage());
    }

    public void setInput(IEditorInput input) {
        this.checkEditorInput(input);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite mpes = (MultiPageEditorSite)iWorkbenchPartSite;
            this.annotationModel = (GraphicalAnnotationModel)mpes.getMultiPageEditor().getAdapter(GraphicalAnnotationModel.class);
        }
        if (this.structComposite != null) {
            this.structComposite.setAnnotationModel(this.annotationModel);
        }
        super.setInputWithNotify(input);
    }

    private void addListenerToAttributeDeclaration() {
        if (this.getType() != null) {
            this.getType().eAdapters().add((Object)this.adapter);
        }
    }

    private void removeListenerFromAttributeDeclaration() {
        if (this.getType() != null) {
            this.getType().eAdapters().remove((Object)this.adapter);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Composite editorComposite = new Composite(parent, 0);
        editorComposite.setLayout((Layout)new GridLayout(1, false));
        this.comboBox = new Combo(editorComposite, 12);
        this.comboBox.add(Messages.AttributeTypeEditorPage_ComboBox_StructEditingComposite, 0);
        this.comboBox.add(Messages.AttributeTypeEditorPage_ComboBox_DirectlyDerivedTypeComposite, 1);
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnyDerivedType type = AttributeTypeEditorPage.this.getType().getType();
                if (AttributeTypeEditorPage.this.comboBox.getSelectionIndex() == 0 && type instanceof DirectlyDerivedType || AttributeTypeEditorPage.this.comboBox.getSelectionIndex() == 1 && type instanceof StructuredType) {
                    AttributeTypeEditorPage.this.getCommandStack().execute((Command)new ChangeAttributeDeclarationTypeCommand(AttributeTypeEditorPage.this.getType()));
                }
            }
        });
        AnyDerivedType type = this.getType().getType();
        if (type instanceof StructuredType) {
            StructuredType structType = (StructuredType)type;
            this.createStructComposite(editorComposite, structType);
            this.comboBox.select(0);
        } else if (type instanceof DirectlyDerivedType) {
            DirectlyDerivedType directlyDerivedType = (DirectlyDerivedType)type;
            this.createDirectlyDerivedComposite(editorComposite, directlyDerivedType);
            this.comboBox.select(1);
        }
    }

    private void changeEditingComposite() {
        AnyDerivedType type = this.getType().getType();
        if (this.structComposite != null && type instanceof DirectlyDerivedType) {
            DirectlyDerivedType directlyDerivedType = (DirectlyDerivedType)type;
            this.createDirectlyDerivedComposite(this.structComposite.getParent(), directlyDerivedType);
            if (!this.structComposite.isDisposed()) {
                this.structComposite.dispose();
            }
            this.structComposite = null;
            this.directlyDerivedTypeComposite.requestLayout();
        } else if (this.directlyDerivedTypeComposite != null && type instanceof StructuredType) {
            StructuredType structType = (StructuredType)type;
            this.createStructComposite(this.directlyDerivedTypeComposite.getParent(), structType);
            if (!this.directlyDerivedTypeComposite.isDisposed()) {
                this.directlyDerivedTypeComposite.dispose();
            }
            this.directlyDerivedTypeComposite = null;
            this.structComposite.requestLayout();
        }
    }

    private void createStructComposite(Composite parent, StructuredType structType) {
        this.structComposite = new StructEditingComposite(parent, this.getCommandStack(), structType, this.annotationModel, (IWorkbenchSite)this.getSite());
        this.getSite().setSelectionProvider(this.structComposite.getSelectionProvider());
    }

    private void createDirectlyDerivedComposite(Composite parent, DirectlyDerivedType directlyDerivedType) {
        this.directlyDerivedTypeComposite = new DirectlyDerivedTypeComposite(parent, directlyDerivedType, this.getCommandStack());
        this.getSite().setSelectionProvider((ISelectionProvider)this.directlyDerivedTypeComposite);
    }

    public void setFocus() {
        if (this.structComposite != null) {
            this.structComposite.setFocus();
        } else if (this.directlyDerivedTypeComposite != null) {
            this.directlyDerivedTypeComposite.setFocus();
        }
    }

    public void reloadType() {
        this.removeListenerFromAttributeDeclaration();
        this.changeEditingComposite();
        AnyDerivedType type = this.getType().getType();
        if (type instanceof StructuredType) {
            StructuredType structType = (StructuredType)type;
            this.structComposite.setStructType(structType);
        }
        if (type instanceof DirectlyDerivedType) {
            DirectlyDerivedType directlyDerivedType = (DirectlyDerivedType)type;
            this.directlyDerivedTypeComposite.setDirectlyDerivedType(directlyDerivedType);
        }
        this.addListenerToAttributeDeclaration();
    }

    public AttributeDeclaration getType() {
        return (AttributeDeclaration)super.getType();
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        return false;
    }

    public boolean isMarkerTarget(IMarker marker) {
        return false;
    }

    public Object getSelectableObject() {
        return null;
    }
}

