/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugElement;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugStackFrame;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugTarget;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugThread;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.debug.breakpoint.EvaluatorLineBreakpoint;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorDebugger;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.EvaluatorThreadPoolExecutor;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableEvaluator;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class CommonEvaluatorDebugger
implements EvaluatorDebugger {
    private final EvaluatorDebugTarget debugTarget;
    private final ConcurrentHashMap<Thread, EvaluatorDebugThread> threads = new ConcurrentHashMap();
    private final ConcurrentHashMap<Evaluator, EvaluatorDebugStackFrame> stackFrames = new ConcurrentHashMap();
    private final ConcurrentHashMap<Variable<?>, EvaluatorDebugVariable> variables = new ConcurrentHashMap();
    private final Set<IBreakpoint> breakpoints = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean suspendOnFirstLine = new AtomicBoolean();

    public CommonEvaluatorDebugger(EvaluatorDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
    }

    public void trap(Object context, Evaluator eval) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (eval instanceof VariableEvaluator) {
            return;
        }
        EvaluatorDebugThread thread = this.getThread(Thread.currentThread());
        EvaluatorDebugStackFrame frame = this.getStackFrame(eval, thread);
        DebugEvent request = thread.peekRequest();
        if (this.shouldSuspend(request, frame, context)) {
            frame.setCurrentContext(context);
            thread.setCurrentEvaluator(eval);
            thread.suspended(request != null ? request.getDetail() : 16);
            try {
                request = thread.awaitResumeRequest();
                this.handleResumeRequest(request, thread, frame);
            }
            catch (Throwable throwable) {
                thread.setCurrentEvaluator(CommonEvaluatorDebugger.getPersistentEvaluator(eval));
                thread.resumed(request != null ? request.getDetail() : 0);
                throw throwable;
            }
            thread.setCurrentEvaluator(CommonEvaluatorDebugger.getPersistentEvaluator(eval));
            thread.resumed(request != null ? request.getDetail() : 0);
        }
    }

    protected boolean shouldSuspend(DebugEvent request, EvaluatorDebugStackFrame frame, Object context) {
        if (request != null && request.getKind() == 2) {
            if (request.getDetail() == 8) {
                return CommonEvaluatorDebugger.shouldSuspendAfterStepEnd(request.getSource(), frame);
            }
            return true;
        }
        return this.anyBreakpointMatches(frame, context);
    }

    protected static boolean shouldSuspendAfterStepEnd(Object source, EvaluatorDebugStackFrame frame) {
        if (source instanceof EvaluatorDebugThread) {
            return true;
        }
        if (source instanceof EvaluatorDebugStackFrame) {
            EvaluatorDebugStackFrame edsf = (EvaluatorDebugStackFrame)((Object)source);
            if (source == frame) {
                return true;
            }
            if (!edsf.isAncestorOf(frame)) {
                return true;
            }
        }
        return false;
    }

    protected boolean anyBreakpointMatches(EvaluatorDebugStackFrame frame, Object context) {
        return DebugPlugin.getDefault().getBreakpointManager().isEnabled() && this.breakpoints.stream().anyMatch(breakpoint -> this.breakpointMatches((IBreakpoint)breakpoint, frame, context));
    }

    protected boolean breakpointMatches(IBreakpoint breakpoint, EvaluatorDebugStackFrame frame, Object context) {
        block5: {
            if (breakpoint.isEnabled()) break block5;
            return false;
        }
        try {
            EvaluatorLineBreakpoint evaluatorLineBreakpoint;
            IResource resource = this.getResource(context);
            int lineNumber = this.getLineNumber(context);
            if (breakpoint instanceof EvaluatorLineBreakpoint && (evaluatorLineBreakpoint = (EvaluatorLineBreakpoint)breakpoint).isApplicable(frame.getEvaluator()) && Objects.equals(breakpoint.getMarker().getResource(), resource) && evaluatorLineBreakpoint.getLineNumber() == lineNumber) {
                if (evaluatorLineBreakpoint.isConditionEnabled()) {
                    return CommonEvaluatorDebugger.evaluateBreakpointCondition(evaluatorLineBreakpoint, frame);
                }
                return true;
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
        return false;
    }

    protected static boolean evaluateBreakpointCondition(EvaluatorLineBreakpoint breakpoint, EvaluatorDebugStackFrame frame) {
        try {
            Evaluator evaluator = EvaluatorFactory.createEvaluator((Object)breakpoint.getCondition(), String.class, null, null, (Evaluator)frame.getEvaluator());
            Value result = evaluator.evaluate();
            return ValueOperations.asBoolean((Value)result);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (Exception e) {
            FordiacLogHelper.logWarning((String)("Couldn't evaluate breakpoint condition: " + e.getMessage()), (Exception)e);
            return false;
        }
    }

    protected void handleResumeRequest(DebugEvent request, EvaluatorDebugThread thread, EvaluatorDebugStackFrame frame) {
        if (request.isStepStart()) {
            switch (request.getDetail()) {
                default: {
                    thread.request((Object)thread, 2, 8);
                    break;
                }
                case 2: {
                    Object resumeSource = request.getSource();
                    Object suspendSource = resumeSource instanceof EvaluatorDebugStackFrame ? resumeSource : frame;
                    thread.request(suspendSource, 2, 8);
                    break;
                }
                case 4: {
                    EvaluatorDebugStackFrame evaluatorDebugStackFrame;
                    Object resumeSource = request.getSource();
                    if (resumeSource instanceof EvaluatorDebugStackFrame) {
                        EvaluatorDebugStackFrame edsf = (EvaluatorDebugStackFrame)((Object)resumeSource);
                        evaluatorDebugStackFrame = edsf.getParent();
                    } else {
                        evaluatorDebugStackFrame = frame.getParent();
                    }
                    EvaluatorDebugStackFrame resumeSourceParent = evaluatorDebugStackFrame;
                    EvaluatorDebugElement suspendSource = resumeSourceParent != null ? resumeSourceParent : this.debugTarget;
                    thread.request((Object)suspendSource, 2, 8);
                }
            }
        }
    }

    protected IResource getResource(Object context) {
        Resource resource;
        URI uri;
        if (context instanceof EObject) {
            EObject eo = (EObject)context;
            EObject root = EcoreUtil.getRootContainer((EObject)eo);
            if (root instanceof FBType) {
                FBType fbType = (FBType)root;
                return fbType.getTypeEntry().getFile();
            }
            return this.getResource(((EObject)context).eResource());
        }
        if (context instanceof Resource && (uri = (resource = (Resource)context).getURI()).isPlatformResource()) {
            String path = uri.toPlatformString(true);
            return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        }
        return null;
    }

    protected static Evaluator getPersistentEvaluator(Evaluator eval) {
        while (eval != null && !eval.isPersistent()) {
            eval = eval.getParent();
        }
        return eval;
    }

    public int getLineNumber(Object context) {
        if (context instanceof EObject) {
            EObject eo = (EObject)context;
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)eo);
            if (context instanceof ICallable) {
                return node.getEndLine();
            }
            if (node != null) {
                return node.getStartLine();
            }
        }
        return -1;
    }

    public void addBreakpoint(IBreakpoint breakpoint) {
        this.breakpoints.add(breakpoint);
    }

    public void removeBreakpoint(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpoints.remove(breakpoint);
    }

    public void updateBreakpoint(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean isSuspendOnFirstLine() {
        return this.suspendOnFirstLine.get();
    }

    public void setSuspendOnFirstLine(boolean suspendOnFirstLine) {
        this.suspendOnFirstLine.set(suspendOnFirstLine);
    }

    public List<EvaluatorDebugThread> getThreads() {
        return List.copyOf(this.threads.values());
    }

    public EvaluatorDebugThread getThread(Thread thread) {
        return this.threads.computeIfAbsent(thread, key -> new EvaluatorDebugThread((Thread)key, this.debugTarget));
    }

    protected EvaluatorDebugStackFrame getStackFrame(Evaluator evaluator, EvaluatorDebugThread thread) {
        return this.stackFrames.computeIfAbsent(evaluator, key -> new EvaluatorDebugStackFrame((Evaluator)key, thread));
    }

    public EvaluatorDebugVariable getVariable(Variable<?> variable) {
        return this.variables.computeIfAbsent(variable, key -> this.debugTarget.createVariable((Variable)key, key.getName()));
    }

    public void beforeExecute(Thread thread, Runnable runnable, EvaluatorThreadPoolExecutor executor) {
        EvaluatorDebugThread debugThread = this.getThread(thread);
        if (this.suspendOnFirstLine.getAndSet(false)) {
            debugThread.suspend();
        }
    }

    public void afterExecute(Thread thread, Runnable runnable, Throwable throwable, EvaluatorThreadPoolExecutor executor) {
        EvaluatorDebugThread debugThread = this.threads.remove(thread);
        if (debugThread != null) {
            debugThread.terminated();
        }
    }

    public void terminated(EvaluatorThreadPoolExecutor executor) {
        this.debugTarget.terminated();
    }
}

