/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.runtime;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.fordiac.ide.runtime.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class RuntimeLaunchTab
extends AbstractLaunchConfigurationTab {
    public static final String ATTR_TOOL_ARGUMENTS = "org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS";
    public static final String ATTR_LOCATION = "org.eclipse.ui.externaltools.ATTR_LOCATION";
    public static final String ATTR_WORKING_DIRECTORY = "org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY";
    public static final String ATTR_BUILD_SCOPE = "org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE";
    public static final String ATTR_APPEND_ENVIRONMENT_VARIABLES = "org.eclipse.debug.core.appendEnvironmentVariables";
    public static final String ATTR_LUNCH_IN_BACKGROUND = "org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND";
    private Text portField;

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.removeAttribute(ATTR_TOOL_ARGUMENTS);
        configuration.removeAttribute(ATTR_WORKING_DIRECTORY);
        configuration.removeAttribute(RefreshUtil.ATTR_REFRESH_SCOPE);
        configuration.setAttribute(ATTR_BUILD_SCOPE, "NONE");
        configuration.setAttribute(ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        configuration.setAttribute(ATTR_LUNCH_IN_BACKGROUND, false);
        configuration.setAttribute("org.eclipse.debug.core.ATTR_MERGE_OUTPUT", true);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        try {
            int port = Integer.parseInt(this.portField.getText());
            if (port < 1024 || port > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.setErrorMessage(Messages.RuntimeLaunchTab_ERROR_WrongPort);
            return false;
        }
        return true;
    }

    protected String getPortValue() {
        return this.portField.getText();
    }

    protected void setPortValue(String portValue) {
        this.portField.setText(portValue);
    }

    protected void createPortSelection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.RuntimeLaunchTab_Port);
        this.portField = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 2).applyTo((Control)this.portField);
        this.portField.addVerifyListener(RuntimeLaunchTab::ensureTextIsValidPortNumber);
        this.portField.addModifyListener(ev -> this.scheduleUpdateJob());
    }

    private static void ensureTextIsValidPortNumber(VerifyEvent e) {
        String portFieldValue = e.text;
        e.doit = portFieldValue.matches("\\d*");
        if (e.doit && !portFieldValue.isBlank()) {
            int port = Integer.parseInt(portFieldValue);
            e.doit = port < 65535;
        }
    }
}

