/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.handles;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.fordiac.ide.gef.tools.ScrollingConnectionEndpointTracker;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.handles.ConnectionEndpointHandle;
import org.eclipse.gef.tools.ConnectionEndpointTracker;

public class ScrollingConnectionEndpointHandle
extends ConnectionEndpointHandle {
    public ScrollingConnectionEndpointHandle(ConnectionEditPart owner, int endPoint) {
        super(owner, endPoint);
    }

    protected void init() {
        super.init();
        this.setPreferredSize(13, 13);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension dim = super.getPreferredSize(wHint, hHint).getCopy();
        double zoomFactor = this.getZoomFactor();
        if ((double)dim.height * zoomFactor < 5.0) {
            dim.height = (int)(5.0 / zoomFactor);
        }
        if ((double)dim.width * zoomFactor < 5.0) {
            dim.width = (int)(5.0 / zoomFactor);
        }
        return dim;
    }

    protected double getZoomFactor() {
        return ((ScalableFreeformRootEditPart)this.getOwner().getRoot()).getZoomManager().getZoom();
    }

    protected ConnectionEditPart getOwner() {
        return (ConnectionEditPart)super.getOwner();
    }

    protected DragTracker createDragTracker() {
        if (this.isFixed()) {
            return null;
        }
        ConnectionEndpointTracker tracker = this.createConnectionEndPointTracker(this.getCoSelectedConnections());
        this.configureConnTracker(tracker);
        return tracker;
    }

    private void configureConnTracker(ConnectionEndpointTracker tracker) {
        if (this.getEndPoint() == 2) {
            tracker.setCommandName("Reconnection source");
        } else {
            tracker.setCommandName("Reconnection target");
        }
        tracker.setDefaultCursor(this.getCursor());
    }

    protected ConnectionEndpointTracker createConnectionEndPointTracker(List<ConnectionEditPart> coSelectedConnections) {
        return new ScrollingConnectionEndpointTracker(coSelectedConnections.get(0));
    }

    public void paintFigure(Graphics g) {
        g.setLineStyle(1);
        g.setLineWidth(2);
        g.setXORMode(false);
        g.setForegroundColor(ModifiedMoveHandle.getSelectionColor());
        g.setBackgroundColor(ModifiedMoveHandle.getSelectionColor());
        int radius = this.getCornerRadius();
        Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds()).shrink(1, 1);
        if (this.isPrimary()) {
            g.drawRoundRectangle(r, radius, radius);
        }
        g.setAlpha(50);
        g.fillRoundRectangle(r, radius, radius);
        g.setAlpha(255);
        this.paintHandleCenter(g, r);
    }

    protected int getCornerRadius() {
        return 5;
    }

    protected void paintHandleCenter(Graphics g, Rectangle r) {
        int shrinkVal = this.getInnerShrinkVal();
        r.shrink(shrinkVal, shrinkVal);
        g.fillRoundRectangle(r, r.height / 2, r.height / 2);
    }

    protected int getInnerShrinkVal() {
        int shrinkVal = 2;
        if ((double)shrinkVal * this.getZoomFactor() < 2.0) {
            shrinkVal = (int)(2.0 / this.getZoomFactor());
        }
        return shrinkVal;
    }

    private List<ConnectionEditPart> getCoSelectedConnections() {
        EditPart refEndPoint = this.getEndPoint(this.getOwner());
        return this.getOwner().getViewer().getSelectedEditParts().stream().filter(ConnectionEditPart.class::isInstance).map(ConnectionEditPart.class::cast).filter(ep -> this.sameTarget((ConnectionEditPart)ep, refEndPoint)).toList();
    }

    private boolean sameTarget(ConnectionEditPart ep, EditPart refEndPoint) {
        EditPart endPoint = this.getEndPoint(ep);
        return endPoint == refEndPoint;
    }

    private EditPart getEndPoint(ConnectionEditPart ep) {
        return this.getEndPoint() == 2 ? ep.getSource() : ep.getTarget();
    }
}

