/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;

public class DateCellEditor
extends AbstractCellEditor {
    private DateTime dateTime;
    private final boolean moveSelectionOnEnter;
    private Calendar currentEditorValue;

    public DateCellEditor() {
        this(false);
    }

    public DateCellEditor(boolean moveSelectionOnEnter) {
        this.moveSelectionOnEnter = moveSelectionOnEnter;
    }

    @Override
    public Object getEditorValue() {
        this.currentEditorValue.set(this.dateTime.getYear(), this.dateTime.getMonth(), this.dateTime.getDay());
        return this.currentEditorValue;
    }

    @Override
    public void setEditorValue(Object value) {
        if (value instanceof Calendar) {
            this.currentEditorValue = (Calendar)value;
            this.dateTime.setDate(this.currentEditorValue.get(1), this.currentEditorValue.get(2), this.currentEditorValue.get(5));
        }
    }

    @Override
    public Object getCanonicalValue() {
        if (this.layerCell.getDataValue() instanceof Calendar) {
            return this.getEditorValue();
        }
        if (this.layerCell.getDataValue() instanceof Date) {
            return ((Calendar)this.getEditorValue()).getTime();
        }
        return null;
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        Calendar editorValue = null;
        if (canonicalValue instanceof Calendar) {
            editorValue = (Calendar)canonicalValue;
        } else if (canonicalValue instanceof Date) {
            editorValue = Calendar.getInstance();
            editorValue.setTime((Date)canonicalValue);
        }
        if (editorValue != null) {
            this.setEditorValue(editorValue);
        }
    }

    public DateTime getEditorControl() {
        return this.dateTime;
    }

    public DateTime createEditorControl(final Composite parent) {
        DateTime dateControl = new DateTime(parent, 36);
        dateControl.setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        dateControl.setForeground(this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        dateControl.setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        dateControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    boolean commit = event.stateMask != SWT.MOD3;
                    SelectionLayer.MoveDirectionEnum move = SelectionLayer.MoveDirectionEnum.NONE;
                    if (DateCellEditor.this.moveSelectionOnEnter && DateCellEditor.this.editMode == EditModeEnum.INLINE) {
                        if (event.stateMask == 0) {
                            move = SelectionLayer.MoveDirectionEnum.DOWN;
                        } else if (event.stateMask == SWT.MOD2) {
                            move = SelectionLayer.MoveDirectionEnum.UP;
                        }
                    }
                    if (commit) {
                        DateCellEditor.this.commit(move);
                    }
                    if (DateCellEditor.this.editMode == EditModeEnum.DIALOG) {
                        parent.forceFocus();
                    }
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    DateCellEditor.this.close();
                }
            }
        });
        return dateControl;
    }

    @Override
    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.dateTime = this.createEditorControl(parent);
        this.setCanonicalValue(originalCanonicalValue);
        parent.getDisplay().asyncExec(() -> {
            if (!this.dateTime.isDisposed()) {
                this.dateTime.forceFocus();
            }
        });
        return this.dateTime;
    }

    @Override
    public void close() {
        super.close();
        this.currentEditorValue = null;
    }
}

