/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.model.ui.editors.GraphicalViewerNavigationLocationData;
import org.eclipse.fordiac.ide.model.ui.widgets.BreadcrumbWidget;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;

public class BreadcrumbNavigationLocation
extends NavigationLocation {
    private final AbstractBreadCrumbEditor breadCrumbEditor;
    private final String breadcrumbPath;
    private GraphicalViewerNavigationLocationData viewerData = null;

    protected BreadcrumbNavigationLocation(AbstractBreadCrumbEditor editorPart) {
        super((IEditorPart)editorPart);
        this.breadCrumbEditor = editorPart;
        this.breadcrumbPath = editorPart.getBreadcrumb().serializePath();
        GraphicalViewer viewer = editorPart.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            this.viewerData = new GraphicalViewerNavigationLocationData(viewer);
        }
    }

    public String getText() {
        return BreadcrumbNavigationLocation.generateItemPath(this.breadCrumbEditor.getBreadcrumb()).substring(1);
    }

    public static String generateItemPath(BreadcrumbWidget breadcrumb) {
        return breadcrumb.serializePath().replace('/', '.');
    }

    private String getBreadCrumbPath() {
        return this.breadcrumbPath;
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public void restoreLocation() {
        this.breadCrumbEditor.getBreadcrumb().validateAndOpenPath(this.breadcrumbPath, (INamedElement)this.breadCrumbEditor.getAdapter(LibraryElement.class));
        GraphicalViewer viewer = this.breadCrumbEditor.getAdapter(GraphicalViewer.class);
        if (viewer != null && this.viewerData != null) {
            this.viewerData.restoreGraphicalViewerData((EditPartViewer)viewer);
        }
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        BreadcrumbNavigationLocation loc;
        if (currentLocation instanceof BreadcrumbNavigationLocation && this.breadcrumbPath.equals((loc = (BreadcrumbNavigationLocation)currentLocation).getBreadCrumbPath())) {
            if (this.viewerData != null) {
                return this.viewerData.equals(loc.viewerData);
            }
            return true;
        }
        return false;
    }

    public void update() {
    }
}

