/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.presentation;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;

public class SequentialPaletteProvider
implements IPaletteProvider {
    private final List<RGBAColor> fColors;

    private SequentialPaletteProvider() {
        this.fColors = Collections.emptyList();
    }

    private SequentialPaletteProvider(Collection<RGBAColor> colors) {
        this.fColors = ImmutableList.copyOf(colors);
    }

    public static IPaletteProvider create(RGBAColor startingColor, int nbColors) {
        float[] components = startingColor.getHSBA();
        float stepBright = (1.0f - components[2]) / (float)nbColors;
        float stepSat = components[1] / (float)nbColors;
        float hue = components[0];
        float brightness = 1.0f;
        float saturation = 0.0f;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        int i = 0;
        while (i < nbColors) {
            builder.add((Object)RGBAColor.fromHSBA(hue, saturation, brightness, components[3]));
            saturation += stepSat;
            brightness -= stepBright;
            ++i;
        }
        return new SequentialPaletteProvider((Collection<RGBAColor>)builder.build());
    }

    @Override
    public List<RGBAColor> get() {
        return this.fColors;
    }
}

