/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.symbols;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.callstack.MappingFile;
import org.eclipse.tracecompass.internal.tmf.core.callstack.SizedMappingFile;
import org.eclipse.tracecompass.tmf.core.symbols.IMappingFile;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;
import org.junit.Assert;
import org.junit.Test;

public class MappingFileTest {
    @Test
    public void testValidTextFile() {
        IMappingFile mf = MappingFileTest.getMappingFile("nm-output-example");
        Assert.assertNotNull((String)"global symbol file", (Object)mf);
        Assert.assertTrue((boolean)(mf instanceof MappingFile));
        Assert.assertTrue((mf.getPid() < 0 ? 1 : 0) != 0);
        mf = MappingFileTest.getMappingFile("symbol123.map");
        Assert.assertNotNull((String)"Global symbol numbered file", (Object)mf);
        Assert.assertTrue((mf.getPid() < 0 ? 1 : 0) != 0);
        mf = MappingFileTest.getMappingFile("symbol-123.map");
        Assert.assertNotNull((String)"Symbol file with pid", (Object)mf);
        Assert.assertTrue((boolean)(mf instanceof MappingFile));
        Assert.assertEquals((long)123L, (long)mf.getPid());
        Path nmOutput = Paths.get("..", "..", "tmf", "org.eclipse.tracecompass.tmf.core.tests", "testfiles", "callstack", "symbol-123.map");
        Assert.assertTrue((boolean)Files.exists(nmOutput, new LinkOption[0]));
        String filePath = nmOutput.toFile().getAbsolutePath();
        Assert.assertNotNull((Object)filePath);
        mf = IMappingFile.create((String)filePath, (boolean)false, (int)2);
        Assert.assertNotNull((String)"Symbol file for different pid", (Object)mf);
        Assert.assertEquals((long)2L, (long)mf.getPid());
        mf = MappingFileTest.getMappingFile("withsize-123.map");
        Assert.assertNotNull((String)"Symbol file with sizes and pid", (Object)mf);
        Assert.assertTrue((boolean)(mf instanceof SizedMappingFile));
        Assert.assertEquals((long)123L, (long)mf.getPid());
    }

    private static @Nullable IMappingFile getMappingFile(String fileName) {
        Path nmOutput = Paths.get("..", "..", "tmf", "org.eclipse.tracecompass.tmf.core.tests", "testfiles", "callstack", fileName);
        Assert.assertTrue((boolean)Files.exists(nmOutput, new LinkOption[0]));
        String filePath = nmOutput.toFile().getAbsolutePath();
        Assert.assertNotNull((Object)filePath);
        return IMappingFile.create((String)filePath, (boolean)false);
    }

    public static @NonNull List<@NonNull IMappingFile> getMappingFiles() {
        ArrayList<@NonNull IMappingFile> list = new ArrayList<IMappingFile>();
        IMappingFile mf = MappingFileTest.getMappingFile("nm-output-example");
        if (mf != null) {
            list.add(mf);
        }
        if ((mf = MappingFileTest.getMappingFile("symbol-123.map")) != null) {
            list.add(mf);
        }
        if ((mf = MappingFileTest.getMappingFile("withsize-123.map")) != null) {
            list.add(mf);
        }
        return list;
    }

    @Test
    public void testGettingSymbolMapFile() {
        Path nmOutput = Paths.get("..", "..", "tmf", "org.eclipse.tracecompass.tmf.core.tests", "testfiles", "callstack", "nm-output-example");
        Assert.assertTrue((boolean)Files.exists(nmOutput, new LinkOption[0]));
        String filePath = nmOutput.toFile().getAbsolutePath();
        Assert.assertNotNull((Object)filePath);
        IMappingFile mf = IMappingFile.create((String)filePath, (boolean)false);
        Assert.assertNotNull((Object)mf);
        TmfResolvedSymbol symbol = mf.getSymbolEntry(Long.valueOf("601191", 16).longValue());
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"std::__ioinit", (Object)symbol.getSymbolName());
        symbol = mf.getSymbolEntry(Long.valueOf("601191", 16) + 4L);
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"std::__ioinit", (Object)symbol.getSymbolName());
        symbol = mf.getSymbolEntry(Long.valueOf("400", 16).longValue());
        Assert.assertNull((Object)symbol);
        symbol = mf.getSymbolEntry(Long.valueOf("400a28", 16).longValue());
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"__FRAME_END__", (Object)symbol.getSymbolName());
        symbol = mf.getSymbolEntry(Long.valueOf("400a28", 16) + 8L);
        Assert.assertNull((Object)symbol);
    }

    @Test
    public void testExtremeValues() {
        Path nmOutput = Paths.get("..", "..", "tmf", "org.eclipse.tracecompass.tmf.core.tests", "testfiles", "callstack", "longOverflow.map");
        Assert.assertTrue((boolean)Files.exists(nmOutput, new LinkOption[0]));
        String filePath = nmOutput.toFile().getAbsolutePath();
        Assert.assertNotNull((Object)filePath);
        IMappingFile mf = IMappingFile.create((String)filePath, (boolean)false);
        Assert.assertNotNull((Object)mf);
        TmfResolvedSymbol symbol = mf.getSymbolEntry(Long.parseUnsignedLong("0ffffffffffffe00", 16));
        Assert.assertNull((Object)symbol);
        symbol = mf.getSymbolEntry(Long.parseUnsignedLong("0ffffffffffffff0", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"Positive long symbol", (Object)symbol.getSymbolName());
        symbol = mf.getSymbolEntry(Long.parseUnsignedLong("affffffffffffff0", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"Positive long symbol", (Object)symbol.getSymbolName());
        symbol = mf.getSymbolEntry(Long.parseUnsignedLong("ffeeddccbbaa0101", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"Overflowing symbol", (Object)symbol.getSymbolName());
        symbol = mf.getSymbolEntry(Long.parseUnsignedLong("ffeeddccbbaa0115", 16));
        Assert.assertNull((Object)symbol);
    }

    @Test
    public void testInvalidFiles() {
        IMappingFile mf = IMappingFile.create((String)"test", (boolean)false);
        Assert.assertNull((Object)mf);
        mf = MappingFileTest.getMappingFile("emptyFile");
        Assert.assertNull((Object)mf);
    }

    @Test
    public void testGettingSymbolWithSize() {
        Path nmOutput = Paths.get("..", "..", "tmf", "org.eclipse.tracecompass.tmf.core.tests", "testfiles", "callstack", "withsize-123.map");
        Assert.assertTrue((boolean)Files.exists(nmOutput, new LinkOption[0]));
        String filePath = nmOutput.toFile().getAbsolutePath();
        Assert.assertNotNull((Object)filePath);
        IMappingFile mf = IMappingFile.create((String)filePath, (boolean)false);
        Assert.assertNotNull((Object)mf);
        TmfResolvedSymbol symbol = mf.getSymbolEntry(Long.parseUnsignedLong("ff00000000000100", 16));
        Assert.assertNull((Object)symbol);
        symbol = mf.getSymbolEntry(Long.parseUnsignedLong("ffeeddccbbaa0102", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"Outer function with size", (Object)symbol.getSymbolName());
        symbol = mf.getSymbolEntry(Long.parseUnsignedLong("ffeeddccbbaa0120", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"Inner function with size", (Object)symbol.getSymbolName());
        symbol = mf.getSymbolEntry(Long.parseUnsignedLong("ffeeddccbbaa0200", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"Outer function with size", (Object)symbol.getSymbolName());
        symbol = mf.getSymbolEntry(Long.parseUnsignedLong("ffeeddccbbaa0400", 16));
        Assert.assertNull((Object)symbol);
    }
}

