/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.ui.tracemarker;

import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;

public class TraceMarker {
    public static final String DEFAULT_COLOR = "FF0000";
    private static final int HEX = 16;
    private final String fLabel;
    private final String fCategory;
    private final RGBAColor fRGBAColor;
    private final long fStartTime;
    private final long fDuration;
    private final long fEndTime;

    public TraceMarker(String label, String category, long startTime, long endTime, String color) {
        this.fLabel = label;
        this.fCategory = category;
        this.fRGBAColor = TraceMarker.convertToRGBA(color);
        this.fStartTime = startTime;
        this.fEndTime = endTime;
        this.fDuration = this.fEndTime - this.fStartTime;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public String getCategory() {
        return this.fCategory;
    }

    public RGBAColor getRGBAColor() {
        return this.fRGBAColor;
    }

    public static RGBAColor convertToRGBA(String color) {
        String hexColor = color;
        hexColor = hexColor != null && (hexColor = X11ColorUtils.toHexColor((String)hexColor)) != null ? hexColor.substring(1) : DEFAULT_COLOR;
        int intColor = Integer.parseInt(hexColor, 16);
        return new RGBAColor(intColor);
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public long getDuration() {
        return this.fDuration;
    }

    public long getEndTime() {
        return this.fEndTime;
    }
}

