/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.builder;

import com.microsoft.java.builder.JavaProblemChecker;
import com.microsoft.java.builder.jdtbuilder.BatchImageBuilder;
import com.microsoft.java.builder.jdtbuilder.ClasspathMultiDirectory;
import com.microsoft.java.builder.jdtbuilder.JavaBuilder;
import com.microsoft.java.builder.jdtbuilder.ProblemFactory;
import com.microsoft.java.builder.jdtbuilder.SourceFile;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.CompilationGroup;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.Util;

public class JavaBatchImageBuilder
extends BatchImageBuilder {
    public JavaBatchImageBuilder(BatchImageBuilder batchImageBuilder, boolean buildStarting, CompilationGroup compilationGroup) {
        super(batchImageBuilder, buildStarting, compilationGroup);
    }

    public JavaBatchImageBuilder(JavaBuilder javaBuilder, boolean buildStarting, CompilationGroup compilationGroup) {
        super(javaBuilder, buildStarting, compilationGroup);
    }

    @Override
    protected void addAllSourceFiles(final LinkedHashSet<SourceFile> sourceFiles) throws CoreException {
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            final ClasspathMultiDirectory sourceLocation = this.sourceLocations[i];
            final char[][] exclusionPatterns = sourceLocation.exclusionPatterns;
            final char[][] inclusionPatterns = sourceLocation.inclusionPatterns;
            IContainer sourceFolder = sourceLocation.sourceFolder;
            final boolean isAlsoProject = sourceFolder.equals((Object)((JavaProblemChecker)this.javaBuilder).currentProject);
            sourceFolder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    switch (proxy.getType()) {
                        case 1: {
                            if (Util.isJavaLikeFileName((String)proxy.getName())) {
                                IResource resource = proxy.requestResource();
                                if ((exclusionPatterns != null || inclusionPatterns != null) && Util.isExcluded((IPath)resource.getFullPath(), (char[][])inclusionPatterns, (char[][])exclusionPatterns, (boolean)false)) {
                                    return false;
                                }
                                SourceFile unit = new SourceFile((IFile)resource, sourceLocation);
                                sourceFiles.add(unit);
                            }
                            return false;
                        }
                        case 2: {
                            IPath folderPath = null;
                            if (isAlsoProject && JavaBatchImageBuilder.this.isExcludedFromProject(folderPath = proxy.requestFullPath())) {
                                return false;
                            }
                            if (exclusionPatterns == null) break;
                            if (folderPath == null) {
                                folderPath = proxy.requestFullPath();
                            }
                            if (!Util.isExcluded((IPath)folderPath, (char[][])inclusionPatterns, (char[][])exclusionPatterns, (boolean)true)) break;
                            return inclusionPatterns != null;
                        }
                    }
                    return true;
                }
            }, 0);
            this.notifier.checkCancel();
            ++i;
        }
    }

    @Override
    protected Compiler newCompiler() {
        Map projectOptions = ((JavaProblemChecker)this.javaBuilder).javaProject.getOptions(true);
        String option = (String)projectOptions.get("org.eclipse.jdt.core.compiler.problem.invalidJavadoc");
        if (!(option != null && !option.equals("ignore") || (option = (String)projectOptions.get("org.eclipse.jdt.core.compiler.problem.missingJavadocTags")) != null && !option.equals("ignore") || (option = (String)projectOptions.get("org.eclipse.jdt.core.compiler.problem.missingJavadocComments")) != null && !option.equals("ignore") || (option = (String)projectOptions.get("org.eclipse.jdt.core.compiler.problem.unusedImport")) != null && !option.equals("ignore"))) {
            projectOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "disabled");
        }
        CompilerOptions compilerOptions = new CompilerOptions(projectOptions);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        Compiler newCompiler = this.createCompiler(compilerOptions);
        CompilerOptions options = newCompiler.options;
        String setting = System.getProperty("jdt.compiler.useSingleThread");
        newCompiler.useSingleThread = setting != null && setting.equals("true");
        options.produceReferenceInfo = true;
        if (options.complianceLevel >= 0x320000L && options.processAnnotations) {
            this.initializeAnnotationProcessorManager(newCompiler);
        }
        return newCompiler;
    }

    private Compiler createCompiler(CompilerOptions compilerOptions) {
        return new Compiler((INameEnvironment)this.nameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, this, (IProblemFactory)ProblemFactory.getProblemFactory(Locale.getDefault())){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
                if (sourceTypes[0] instanceof SourceTypeElementInfo) {
                    while (sourceTypes[0].getEnclosingType() != null) {
                        sourceTypes[0] = sourceTypes[0].getEnclosingType();
                    }
                    CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
                    long savedComplianceLevel = this.options.complianceLevel;
                    long savedSourceLevel = this.options.sourceLevel;
                    LookupEnvironment environment = packageBinding.environment;
                    if (environment == null) {
                        environment = this.lookupEnvironment;
                    }
                    try {
                        IJavaProject project = ((SourceTypeElementInfo)sourceTypes[0]).getHandle().getJavaProject();
                        this.options.complianceLevel = CompilerOptions.versionToJdkLevel((String)project.getOption("org.eclipse.jdt.core.compiler.compliance", true));
                        this.options.sourceLevel = CompilerOptions.versionToJdkLevel((String)project.getOption("org.eclipse.jdt.core.compiler.source", true));
                        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit((ISourceType[])sourceTypes, (int)31, (ProblemReporter)environment.problemReporter, (CompilationResult)result);
                        if (unit == null) return;
                        environment.buildTypeBindings(unit, accessRestriction);
                        CompilationUnitDeclaration previousUnitBeingCompleted = this.lookupEnvironment.unitBeingCompleted;
                        environment.completeTypeBindings(unit);
                        this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
                        return;
                    }
                    finally {
                        this.options.complianceLevel = savedComplianceLevel;
                        this.options.sourceLevel = savedSourceLevel;
                    }
                } else {
                    super.accept(sourceTypes, packageBinding, accessRestriction);
                }
            }
        };
    }

    @Override
    protected char[] writeClassFile(ClassFile classFile, SourceFile compilationUnit, boolean isTopLevelType) throws CoreException {
        IContainer outputFolder;
        String fileName = new String(classFile.fileName());
        Path filePath = new Path(fileName);
        IContainer container = outputFolder = compilationUnit.sourceLocation.binaryFolder;
        if (filePath.segmentCount() > 1) {
            container = outputFolder.getFolder(filePath.removeLastSegments(1));
            filePath = new Path(filePath.lastSegment());
        }
        IFile file = container.getFile(filePath.addFileExtension("class"));
        this.writeClassFileContents(classFile, file, fileName, isTopLevelType, compilationUnit);
        return filePath.lastSegment().toCharArray();
    }

    @Override
    protected void writeClassFileContents(ClassFile classFile, IFile file, String qualifiedFileName, boolean isTopLevelType, SourceFile compilationUnit) throws CoreException {
    }

    @Override
    protected void cleanOutputFolders(boolean copyBack) throws CoreException {
    }

    @Override
    protected void copyExtraResourcesBack(ClasspathMultiDirectory sourceLocation, boolean deletedAll) throws CoreException {
    }

    @Override
    protected void copyResource(IResource source, IResource destination) throws CoreException {
    }
}

