/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.htmlcss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.html.core.internal.htmlcss.URLHelper;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.util.PathHelper;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class URLModelProvider {
    private static final int GET_MODEL_FOR_READ = 1;
    private static final int GET_MODEL_FOR_EDIT = 3;
    private IModelManager modelManager = StructuredModelManager.getModelManager();

    private static String calculateId(IPath fullIPath) {
        return fullIPath.toString();
    }

    private IStructuredModel getCommonModelFor(IStructuredModel baseModel, String ref, int which) throws IOException {
        IStructuredModel model;
        Path fullIPath;
        block30: {
            String absURL = URLModelProvider.resolveURI(baseModel, ref, true);
            if (absURL == null || absURL.length() == 0) {
                return null;
            }
            try {
                Path ipath;
                String device;
                URL aURL = new URL(absURL);
                if (!aURL.getProtocol().equals("platform") && aURL.getProtocol().equals("file") && (aURL.getHost().equals("localhost") || aURL.getHost().length() == 0) && (device = (ipath = new Path(absURL = aURL.getFile())).getDevice()) != null && device.length() > 0 && device.charAt(0) == '/') {
                    String newDevice = device.substring(1);
                    absURL = ipath.setDevice(newDevice).toString();
                }
            }
            catch (MalformedURLException malformedURLException) {}
            IProject project = null;
            fullIPath = new Path(absURL);
            IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
            IContainer container = workspace.getContainerForLocation((IPath)fullIPath);
            if (container != null) {
                project = container.getProject();
            }
            if (project != null && !project.getLocation().isPrefixOf((IPath)fullIPath)) {
                return null;
            }
            model = null;
            if (project != null) {
                IFile file;
                IPath filePath = fullIPath.removeFirstSegments(project.getLocation().segmentCount());
                IFile iFile = file = filePath != null && !filePath.isEmpty() ? project.getFile(filePath) : null;
                if (file == null) {
                    return null;
                }
                if (which == 3) {
                    model = this.getModelForEdit(file);
                } else if (which == 1) {
                    model = this.getModelForRead(file);
                }
                if (model != null && model.getSynchronizationStamp() == -1L) {
                    model.resetSynchronizationStamp((IResource)file);
                }
            } else {
                URIResolver resolver;
                String id = null;
                FileInputStream inStream = null;
                URIResolver uRIResolver = resolver = project != null ? (URIResolver)project.getAdapter(URIResolver.class) : null;
                if (resolver == null) {
                    resolver = new ProjectResolver(project);
                }
                if (resolver == null) {
                    return null;
                }
                File file = fullIPath.toFile();
                id = URLModelProvider.calculateId((IPath)fullIPath);
                try {
                    inStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
                try {
                    if (which == 3) {
                        model = this.getModelManager().getModelForEdit(id, (InputStream)inStream, resolver);
                    } else if (which == 1) {
                        model = this.getModelManager().getModelForRead(id, (InputStream)inStream, resolver);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (inStream != null) {
                        ((InputStream)inStream).close();
                    }
                    break block30;
                }
                catch (IOException iOException) {
                    try {
                        break block30;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (inStream != null) {
                            ((InputStream)inStream).close();
                        }
                    }
                }
                if (inStream == null) break block30;
                ((InputStream)inStream).close();
            }
        }
        if (model != null && model.getBaseLocation() == null) {
            model.setBaseLocation(fullIPath.toString());
        }
        return model;
    }

    public IStructuredModel getModelForEdit(IStructuredModel baseModel, String ref) throws IOException {
        return this.getCommonModelFor(baseModel, ref, 3);
    }

    private IStructuredModel getModelForEdit(IFile file) throws IOException {
        if (file == null) {
            return null;
        }
        IModelManager manager = this.getModelManager();
        IStructuredModel model = null;
        try {
            model = manager.getModelForEdit(file);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            try {
                model = manager.getModelForEdit(file, EncodingRule.FORCE_DEFAULT);
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        catch (CoreException coreException) {}
        return model;
    }

    public IStructuredModel getModelForRead(IStructuredModel baseModel, String ref) throws UnsupportedEncodingException, IOException {
        return this.getCommonModelFor(baseModel, ref, 1);
    }

    private IStructuredModel getModelForRead(IFile file) throws IOException {
        if (file == null) {
            return null;
        }
        IModelManager manager = this.getModelManager();
        IStructuredModel model = null;
        try {
            model = manager.getModelForRead(file);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            try {
                model = manager.getModelForRead(file, EncodingRule.FORCE_DEFAULT);
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        catch (CoreException coreException) {}
        return model;
    }

    private IModelManager getModelManager() {
        return this.modelManager;
    }

    public IStructuredModel getNewModelForEdit(IFile iFile) {
        if (iFile == null) {
            return null;
        }
        IModelManager manager = this.getModelManager();
        if (manager == null) {
            return null;
        }
        IStructuredModel model = null;
        try {
            model = manager.getNewModelForEdit(iFile, false);
        }
        catch (IOException iOException) {
        }
        catch (ResourceInUse resourceInUse) {
        }
        catch (ResourceAlreadyExists resourceAlreadyExists) {
        }
        catch (CoreException coreException) {}
        return model;
    }

    public IStructuredModel getNewModelForRead(IFile iFile) {
        if (iFile == null) {
            return null;
        }
        IModelManager manager = this.getModelManager();
        if (manager == null) {
            return null;
        }
        IStructuredModel model = null;
        try {
            model = manager.getNewModelForEdit(iFile, false);
        }
        catch (IOException iOException) {
        }
        catch (ResourceInUse resourceInUse) {
        }
        catch (ResourceAlreadyExists resourceAlreadyExists) {
        }
        catch (CoreException coreException) {}
        return model;
    }

    private static boolean isHTMLFamily(IStructuredModel model) {
        IDOMDocument document;
        DocumentTypeAdapter adapter;
        if (model instanceof IDOMModel && (adapter = (DocumentTypeAdapter)(document = ((IDOMModel)model).getDocument()).getAdapterFor(DocumentTypeAdapter.class)) != null) {
            return adapter.hasFeature("HTML");
        }
        return false;
    }

    public static String resolveURI(IStructuredModel baseModel, String ref, boolean resolveCrossProjectLinks) {
        String absurl;
        URIResolver resolver;
        IDOMModel xmlmodel;
        IDOMDocument doc;
        NodeList nl;
        if (baseModel == null) {
            return null;
        }
        String baseHref = null;
        if (URLModelProvider.isHTMLFamily(baseModel) && (nl = (doc = (xmlmodel = (IDOMModel)baseModel).getDocument()).getElementsByTagName("BASE")) != null && nl.getLength() > 0) {
            int i = 0;
            while (i < nl.getLength()) {
                String attrValue;
                Node attrNode;
                NamedNodeMap attrNodes;
                Node baseNode = nl.item(i);
                if (baseNode != null && (attrNodes = baseNode.getAttributes()) != null && (attrNode = attrNodes.getNamedItem("HREF")) != null && (attrValue = attrNode.getNodeValue()) != null) {
                    baseHref = attrValue.trim();
                }
                if (baseHref != null) break;
                ++i;
            }
        }
        String string = (resolver = baseModel.getResolver()) != null ? (baseHref != null ? resolver.getLocationByURI(ref, baseHref, resolveCrossProjectLinks) : resolver.getLocationByURI(ref, resolveCrossProjectLinks)) : (absurl = null);
        if (resolver != null && absurl == null && ref != null && ref.trim().length() > 0 && ref.trim().charAt(0) == '/') {
            return null;
        }
        if (absurl != null && absurl.length() > 0) {
            return absurl;
        }
        IContainer container = resolver != null ? resolver.getRootLocation() : null;
        String docroot = null;
        if (container != null) {
            IPath containerLocation = container.getLocation();
            if (containerLocation != null) {
                docroot = containerLocation.toString();
            } else if (container.getLocationURI() != null) {
                docroot = container.getLocationURI().toString();
            }
        }
        if (docroot == null) {
            docroot = baseModel.getBaseLocation();
        }
        if (docroot == null) {
            return null;
        }
        String modelBaseLocation = baseModel.getBaseLocation();
        if (modelBaseLocation == null || modelBaseLocation.length() == 0) {
            modelBaseLocation = baseModel.getId();
        }
        if (modelBaseLocation == null || modelBaseLocation.length() == 0) {
            return null;
        }
        URLHelper helper = new URLHelper(PathHelper.getContainingFolderPath((String)modelBaseLocation), PathHelper.getContainingFolderPath((String)PathHelper.appendTrailingURLSlash((String)docroot)));
        return helper.toAbsolute(ref);
    }
}

