/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryListener;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.OutputDirectoryCreator;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.hierarchical.OpenTest4JAwareThrowableCollector;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.junit.platform.suite.api.Suite;
import org.junit.platform.suite.api.SuiteDisplayName;
import org.junit.platform.suite.engine.LifecycleMethodUtils;
import org.junit.platform.suite.engine.NoTestsDiscoveredException;
import org.junit.platform.suite.engine.SuiteLauncher;
import org.junit.platform.suite.engine.SuiteLauncherDiscoveryRequestBuilder;

final class SuiteTestDescriptor
extends AbstractTestDescriptor {
    static final String SEGMENT_TYPE = "suite";
    private final SuiteLauncherDiscoveryRequestBuilder discoveryRequestBuilder = SuiteLauncherDiscoveryRequestBuilder.request();
    private final ConfigurationParameters configurationParameters;
    private final OutputDirectoryCreator outputDirectoryCreator;
    private final Boolean failIfNoTests;
    private final Class<?> suiteClass;
    private final LifecycleMethods lifecycleMethods;
    private @Nullable LauncherDiscoveryResult launcherDiscoveryResult;
    private @Nullable SuiteLauncher launcher;

    SuiteTestDescriptor(UniqueId id, Class<?> suiteClass, ConfigurationParameters configurationParameters, OutputDirectoryCreator outputDirectoryCreator, EngineDiscoveryListener discoveryListener, DiscoveryIssueReporter issueReporter) {
        super(id, SuiteTestDescriptor.getSuiteDisplayName(suiteClass, issueReporter), (TestSource)ClassSource.from(suiteClass));
        this.configurationParameters = configurationParameters;
        this.outputDirectoryCreator = outputDirectoryCreator;
        this.failIfNoTests = SuiteTestDescriptor.getFailIfNoTests(suiteClass);
        this.suiteClass = suiteClass;
        this.lifecycleMethods = new LifecycleMethods(suiteClass, issueReporter);
        this.discoveryRequestBuilder.listener(DiscoveryIssueForwardingListener.create(id, discoveryListener));
    }

    private static Boolean getFailIfNoTests(Class<?> suiteClass) {
        return AnnotationSupport.findAnnotation(suiteClass, Suite.class).map(Suite::failIfNoTests).orElseThrow(() -> new JUnitException("Suite [%s] was not annotated with @Suite".formatted(suiteClass.getName())));
    }

    SuiteTestDescriptor addDiscoveryRequestFrom(Class<?> suiteClass) {
        Preconditions.condition((this.launcherDiscoveryResult == null ? 1 : 0) != 0, (String)"discovery request cannot be modified after discovery");
        this.discoveryRequestBuilder.applySelectorsAndFiltersFromSuite(suiteClass);
        return this;
    }

    SuiteTestDescriptor addDiscoveryRequestFrom(UniqueId uniqueId) {
        Preconditions.condition((this.launcherDiscoveryResult == null ? 1 : 0) != 0, (String)"discovery request cannot be modified after discovery");
        this.discoveryRequestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectUniqueId((UniqueId)uniqueId)});
        return this;
    }

    void discover() {
        if (this.launcherDiscoveryResult != null) {
            return;
        }
        LauncherDiscoveryRequest request = this.discoveryRequestBuilder.filterStandardClassNamePatterns().disableImplicitConfigurationParameters().parentConfigurationParameters(this.configurationParameters).applyConfigurationParametersFromSuite(this.suiteClass).outputDirectoryCreator(this.outputDirectoryCreator).build();
        this.launcher = SuiteLauncher.create();
        this.launcherDiscoveryResult = this.launcher.discover(request, this.getUniqueId());
        this.launcherDiscoveryResult.getTestEngines().stream().map(testEngine -> this.launcherDiscoveryResult.getEngineTestDescriptor(testEngine)).forEach(arg_0 -> ((SuiteTestDescriptor)this).addChild(arg_0));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    private static String getSuiteDisplayName(Class<?> suiteClass, DiscoveryIssueReporter issueReporter) {
        Predicate nonBlank = issueReporter.createReportingCondition(StringUtils::isNotBlank, __ -> {
            String message = "@SuiteDisplayName on %s must be declared with a non-blank value.".formatted(suiteClass.getName());
            return DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)message).source((TestSource)ClassSource.from((Class)suiteClass)).build();
        }).toPredicate();
        return AnnotationSupport.findAnnotation(suiteClass, SuiteDisplayName.class).map(SuiteDisplayName::value).filter(nonBlank).orElse(suiteClass.getSimpleName());
    }

    void execute(EngineExecutionListener executionListener, NamespacedHierarchicalStore<Namespace> requestLevelStore, CancellationToken cancellationToken) {
        if (cancellationToken.isCancellationRequested()) {
            executionListener.executionSkipped((TestDescriptor)this, "Execution cancelled");
            return;
        }
        executionListener.executionStarted((TestDescriptor)this);
        OpenTest4JAwareThrowableCollector throwableCollector = new OpenTest4JAwareThrowableCollector();
        this.executeBeforeSuiteMethods((ThrowableCollector)throwableCollector);
        TestExecutionSummary summary = this.executeTests(executionListener, requestLevelStore, cancellationToken, (ThrowableCollector)throwableCollector);
        this.executeAfterSuiteMethods((ThrowableCollector)throwableCollector);
        TestExecutionResult testExecutionResult = this.computeTestExecutionResult(summary, (ThrowableCollector)throwableCollector);
        executionListener.executionFinished((TestDescriptor)this, testExecutionResult);
    }

    private void executeBeforeSuiteMethods(ThrowableCollector throwableCollector) {
        if (throwableCollector.isNotEmpty()) {
            return;
        }
        for (Method beforeSuiteMethod : this.lifecycleMethods.beforeSuite) {
            throwableCollector.execute(() -> ReflectionSupport.invokeMethod((Method)beforeSuiteMethod, null, (Object[])new Object[0]));
            if (!throwableCollector.isNotEmpty()) continue;
            return;
        }
    }

    private @Nullable TestExecutionSummary executeTests(EngineExecutionListener executionListener, NamespacedHierarchicalStore<Namespace> requestLevelStore, CancellationToken cancellationToken, ThrowableCollector throwableCollector) {
        if (throwableCollector.isNotEmpty()) {
            return null;
        }
        LauncherDiscoveryResult discoveryResult = Objects.requireNonNull(this.launcherDiscoveryResult).withRetainedEngines(this.getChildren()::contains);
        return Objects.requireNonNull(this.launcher).execute(discoveryResult, executionListener, requestLevelStore, cancellationToken);
    }

    private void executeAfterSuiteMethods(ThrowableCollector throwableCollector) {
        for (Method afterSuiteMethod : this.lifecycleMethods.afterSuite) {
            throwableCollector.execute(() -> ReflectionSupport.invokeMethod((Method)afterSuiteMethod, null, (Object[])new Object[0]));
        }
    }

    private TestExecutionResult computeTestExecutionResult(@Nullable TestExecutionSummary summary, ThrowableCollector throwableCollector) {
        Throwable throwable = throwableCollector.getThrowable();
        if (throwable != null) {
            return TestExecutionResult.failed((Throwable)throwable);
        }
        if (this.failIfNoTests.booleanValue() && Objects.requireNonNull(summary).getTestsFoundCount() == 0L) {
            return TestExecutionResult.failed((Throwable)((Object)new NoTestsDiscoveredException(this.suiteClass)));
        }
        return TestExecutionResult.successful();
    }

    public boolean mayRegisterTests() {
        return true;
    }

    private static class LifecycleMethods {
        final List<Method> beforeSuite;
        final List<Method> afterSuite;

        LifecycleMethods(Class<?> suiteClass, DiscoveryIssueReporter issueReporter) {
            this.beforeSuite = LifecycleMethodUtils.findBeforeSuiteMethods(suiteClass, issueReporter);
            this.afterSuite = LifecycleMethodUtils.findAfterSuiteMethods(suiteClass, issueReporter);
        }
    }

    private record DiscoveryIssueForwardingListener(EngineDiscoveryListener discoveryListener, BiFunction<UniqueId, DiscoveryIssue, DiscoveryIssue> issueTransformer) implements LauncherDiscoveryListener
    {
        private static final Predicate<UniqueId.Segment> SUITE_SEGMENTS = FunctionUtils.where(UniqueId.Segment::getType, Predicate.isEqual("suite"));

        static DiscoveryIssueForwardingListener create(UniqueId id, EngineDiscoveryListener discoveryListener) {
            boolean isNestedSuite;
            boolean bl = isNestedSuite = id.getSegments().stream().filter(SUITE_SEGMENTS).count() > 1L;
            if (isNestedSuite) {
                return new DiscoveryIssueForwardingListener(discoveryListener, (__, issue) -> issue);
            }
            return new DiscoveryIssueForwardingListener(discoveryListener, (engineUniqueId, issue) -> issue.withMessage(message -> {
                String engineId = engineUniqueId.getLastSegment().getValue();
                if ("junit-platform-suite".equals(engineId)) {
                    return message;
                }
                String suitePath = engineUniqueId.getSegments().stream().filter(SUITE_SEGMENTS).map(UniqueId.Segment::getValue).collect(Collectors.joining(" > "));
                if (message.endsWith(".")) {
                    message = message.substring(0, message.length() - 1);
                }
                return "[%s] %s (via @Suite %s).".formatted(engineId, message, suitePath);
            }));
        }

        public void issueEncountered(UniqueId engineUniqueId, DiscoveryIssue issue) {
            DiscoveryIssue transformedIssue = this.issueTransformer.apply(engineUniqueId, issue);
            this.discoveryListener.issueEncountered(engineUniqueId, transformedIssue);
        }
    }
}

