/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.launch;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.launch.BaseRunConfigurationAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public final class GradleRunConfigurationAttributes
extends BaseRunConfigurationAttributes {
    private static final String TASKS = "tasks";
    private final ImmutableList<String> tasks;

    public GradleRunConfigurationAttributes(List<String> tasks, String workingDirExpression, String gradleDistribution, String gradleUserHomeExpression, String javaHomeExpression, List<String> jvmArgumentExpressions, List<String> argumentExpressions, boolean showExecutionView, boolean showConsoleView, boolean overrideWorkspaceSettings, boolean isOffline, boolean isBuildScansEnabled) {
        super(workingDirExpression, gradleDistribution, gradleUserHomeExpression, javaHomeExpression, jvmArgumentExpressions, argumentExpressions, showExecutionView, showConsoleView, overrideWorkspaceSettings, isOffline, isBuildScansEnabled);
        this.tasks = ImmutableList.copyOf(tasks);
    }

    public ImmutableList<String> getTasks() {
        return this.tasks;
    }

    public boolean hasSameUniqueAttributes(ILaunchConfiguration launchConfiguration) {
        try {
            return this.tasks.equals((Object)launchConfiguration.getAttribute(TASKS, (List)ImmutableList.of())) && this.workingDirExpression.equals(launchConfiguration.getAttribute("working_dir", ""));
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read Gradle launch configuration %s.", launchConfiguration), e);
        }
    }

    @Override
    public void apply(ILaunchConfigurationWorkingCopy launchConfiguration) {
        super.apply(launchConfiguration);
        GradleRunConfigurationAttributes.applyTasks(this.tasks, launchConfiguration);
    }

    public static void applyTasks(List<String> tasks, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(TASKS, tasks);
    }

    public static GradleRunConfigurationAttributes from(ILaunchConfiguration launchConfiguration) {
        Preconditions.checkNotNull((Object)launchConfiguration);
        List<String> tasks = GradleRunConfigurationAttributes.getListAttribute(TASKS, launchConfiguration);
        String workingDirExpression = GradleRunConfigurationAttributes.getStringAttribute("working_dir", "", launchConfiguration);
        String gradleDistribution = GradleRunConfigurationAttributes.getStringAttribute("gradle_distribution", GradleDistribution.fromBuild().toString(), launchConfiguration);
        String gradleUserHomeExpression = GradleRunConfigurationAttributes.getStringAttribute("gradle_user_home", null, launchConfiguration);
        String javaHomeExpression = GradleRunConfigurationAttributes.getStringAttribute("java_home", null, launchConfiguration);
        List<String> jvmArgumentExpressions = GradleRunConfigurationAttributes.getListAttribute("jvm_arguments", launchConfiguration);
        List<String> argumentExpressions = GradleRunConfigurationAttributes.getListAttribute("arguments", launchConfiguration);
        boolean showExecutionView = GradleRunConfigurationAttributes.getBooleanAttribute("show_execution_view", true, launchConfiguration);
        boolean showConsoleView = GradleRunConfigurationAttributes.getBooleanAttribute("show_console_view", true, launchConfiguration);
        boolean overrideWorkspaceSettings = GradleRunConfigurationAttributes.getBooleanAttribute("override_workspace_settings", false, launchConfiguration);
        boolean isOffline = GradleRunConfigurationAttributes.getBooleanAttribute("offline_mode", false, launchConfiguration);
        boolean isBuildScansEnabled = GradleRunConfigurationAttributes.getBooleanAttribute("build_scans_enabled", false, launchConfiguration);
        return new GradleRunConfigurationAttributes(tasks, workingDirExpression, gradleDistribution, gradleUserHomeExpression, javaHomeExpression, jvmArgumentExpressions, argumentExpressions, showExecutionView, showConsoleView, overrideWorkspaceSettings, isOffline, isBuildScansEnabled);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GradleRunConfigurationAttributes) {
            GradleRunConfigurationAttributes other = (GradleRunConfigurationAttributes)obj;
            return super.equals(obj) && Objects.equal(this.tasks, other.tasks);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.tasks});
    }
}

