/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.analysis.hunspell.AffixCondition;
import org.apache.lucene.analysis.hunspell.AffixKind;
import org.apache.lucene.analysis.hunspell.AffixedWord;
import org.apache.lucene.analysis.hunspell.DictEntries;
import org.apache.lucene.analysis.hunspell.DictEntry;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.EntrySuggestion;
import org.apache.lucene.analysis.hunspell.FlagEnumerator;
import org.apache.lucene.analysis.hunspell.Stemmer;
import org.apache.lucene.analysis.hunspell.WordContext;
import org.apache.lucene.internal.hppc.CharHashSet;
import org.apache.lucene.internal.hppc.CharObjectHashMap;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.IntsRefFSTEnum;

public class WordFormGenerator {
    private final Dictionary dictionary;
    private final CharObjectHashMap<List<AffixEntry>> affixes = new CharObjectHashMap();
    private final Stemmer stemmer;

    public WordFormGenerator(Dictionary dictionary) {
        this.dictionary = dictionary;
        this.fillAffixMap(dictionary.prefixes, AffixKind.PREFIX);
        this.fillAffixMap(dictionary.suffixes, AffixKind.SUFFIX);
        this.stemmer = new Stemmer(dictionary);
    }

    private void fillAffixMap(FST<IntsRef> fst, AffixKind kind) {
        if (fst == null) {
            return;
        }
        IntsRefFSTEnum fstEnum = new IntsRefFSTEnum(fst);
        try {
            IntsRefFSTEnum.InputOutput io;
            while ((io = fstEnum.next()) != null) {
                IntsRef affixIds = (IntsRef)io.output;
                for (int j = 0; j < affixIds.length; ++j) {
                    List<AffixEntry> entries;
                    int id = affixIds.ints[affixIds.offset + j];
                    char flag = this.dictionary.affixData(id, 0);
                    AffixEntry entry = new AffixEntry(id, flag, kind, this.toString(kind, io.input), this.strip(id), this.condition(id));
                    int index = this.affixes.indexOf(flag);
                    if (index < 0) {
                        entries = new ArrayList();
                        this.affixes.indexInsert(index, flag, entries);
                    } else {
                        entries = (List)this.affixes.indexGet(index);
                    }
                    entries.add(entry);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String toString(AffixKind kind, IntsRef input) {
        char[] affixChars = new char[input.length];
        for (int i = 0; i < affixChars.length; ++i) {
            affixChars[kind == AffixKind.PREFIX ? i : affixChars.length - i - 1] = (char)input.ints[input.offset + i];
        }
        return new String(affixChars);
    }

    private AffixCondition condition(int affixId) {
        int condition = this.dictionary.getAffixCondition(affixId);
        return condition == 0 ? AffixCondition.ALWAYS_TRUE : this.dictionary.patterns.get(condition);
    }

    private String strip(int affixId) {
        char stripOrd = this.dictionary.affixData(affixId, 1);
        int stripStart = this.dictionary.stripOffsets[stripOrd];
        int stripEnd = this.dictionary.stripOffsets[stripOrd + '\u0001'];
        return new String(this.dictionary.stripData, stripStart, stripEnd - stripStart);
    }

    public List<AffixedWord> getAllWordForms(String root, Runnable checkCanceled) {
        ArrayList<AffixedWord> result = new ArrayList<AffixedWord>();
        DictEntries entries = this.dictionary.lookupEntries(root);
        if (entries != null) {
            for (DictEntry entry : entries) {
                result.addAll(this.getAllWordForms(root, entry.getFlags(), checkCanceled));
            }
        }
        return result;
    }

    public List<AffixedWord> getAllWordForms(String stem, String flags, Runnable checkCanceled) {
        char[] encodedFlags = this.dictionary.flagParsingStrategy.parseUtfFlags(flags);
        if (!this.shouldConsiderAtAll(encodedFlags)) {
            return List.of();
        }
        return this.getAllWordForms(DictEntry.create(stem, flags), encodedFlags, checkCanceled);
    }

    private List<AffixedWord> getAllWordForms(DictEntry entry, char[] encodedFlags, Runnable checkCanceled) {
        encodedFlags = WordFormGenerator.sortAndDeduplicate(encodedFlags);
        ArrayList<AffixedWord> result = new ArrayList<AffixedWord>();
        AffixedWord bare = new AffixedWord(entry.getStem(), entry, List.of(), List.of());
        checkCanceled.run();
        if (!FlagEnumerator.hasFlagInSortedArray(this.dictionary.needaffix, encodedFlags, 0, encodedFlags.length)) {
            result.add(bare);
        }
        result.addAll(this.expand(bare, encodedFlags, checkCanceled));
        return result;
    }

    private static char[] sortAndDeduplicate(char[] flags) {
        Arrays.sort(flags);
        for (int i = 1; i < flags.length; ++i) {
            if (flags[i] != flags[i - 1]) continue;
            return WordFormGenerator.deduplicate(flags);
        }
        return flags;
    }

    private static char[] deduplicate(char[] flags) {
        return Dictionary.toSortedCharArray(CharHashSet.from((char[])flags));
    }

    protected boolean canStemToOriginal(AffixedWord derived) {
        String word = derived.getWord();
        char[] chars = word.toCharArray();
        if (this.isForbiddenWord(chars, 0, chars.length)) {
            return false;
        }
        final String stem = derived.getDictEntry().getStem();
        var processor = new Stemmer.StemCandidateProcessor(WordContext.SIMPLE_WORD){
            boolean foundStem;
            boolean foundForbidden;
            {
                super(context);
                this.foundStem = false;
                this.foundForbidden = false;
            }

            @Override
            boolean processStemCandidate(char[] chars, int offset, int length, int lastAffix, int outerPrefix, int innerPrefix, int outerSuffix, int innerSuffix) {
                if (WordFormGenerator.this.isForbiddenWord(chars, offset, length)) {
                    this.foundForbidden = true;
                    return false;
                }
                this.foundStem |= length == stem.length() && stem.equals(new String(chars, offset, length));
                return !this.foundStem;
            }
        };
        this.stemmer.removeAffixes(chars, 0, chars.length, true, -1, -1, -1, processor);
        return processor.foundStem && !processor.foundForbidden;
    }

    private boolean isForbiddenWord(char[] chars, int offset, int length) {
        IntsRef forms;
        if (this.dictionary.forbiddenword != '\u0000' && (forms = this.dictionary.lookupWord(chars, offset, length)) != null) {
            for (int i = 0; i < forms.length; i += this.dictionary.formStep()) {
                if (!this.dictionary.hasFlag(forms.ints[forms.offset + i], this.dictionary.forbiddenword)) continue;
                return true;
            }
        }
        return false;
    }

    private List<AffixedWord> expand(AffixedWord stem, char[] flags, Runnable checkCanceled) {
        ArrayList<AffixedWord> result = new ArrayList<AffixedWord>();
        for (char flag : flags) {
            AffixKind kind;
            List entries = (List)this.affixes.get(flag);
            if (entries == null || !this.isCompatibleWithPreviousAffixes(stem, kind = ((AffixEntry)entries.get((int)0)).kind, flag)) continue;
            for (AffixEntry affix : entries) {
                char[] append;
                checkCanceled.run();
                AffixedWord derived = affix.apply(stem, this.dictionary);
                if (derived == null || !this.shouldConsiderAtAll(append = this.appendFlags(affix))) continue;
                if (this.canStemToOriginal(derived)) {
                    result.add(derived);
                }
                if (!this.dictionary.isCrossProduct(affix.id)) continue;
                result.addAll(this.expand(derived, this.updateFlags(flags, flag, append), checkCanceled));
            }
        }
        return result;
    }

    private boolean shouldConsiderAtAll(char[] flags) {
        for (char flag : flags) {
            if (flag != this.dictionary.compoundBegin && flag != this.dictionary.compoundMiddle && flag != this.dictionary.compoundEnd && flag != this.dictionary.forbiddenword && flag != this.dictionary.onlyincompound) continue;
            return false;
        }
        return true;
    }

    private char[] updateFlags(char[] flags, char toRemove, char[] toAppend) {
        char[] result = new char[flags.length + toAppend.length - 1];
        int index = 0;
        for (char flag : flags) {
            if (flag == toRemove || flag == this.dictionary.needaffix) continue;
            result[index++] = flag;
        }
        for (char flag : toAppend) {
            result[index++] = flag;
        }
        return WordFormGenerator.sortAndDeduplicate(result);
    }

    private char[] appendFlags(AffixEntry affix) {
        char appendId = this.dictionary.affixData(affix.id, 3);
        return appendId == '\u0000' ? new char[]{} : this.dictionary.flagLookup.getFlags(appendId);
    }

    public void generateAllSimpleWords(Consumer<AffixedWord> consumer, Runnable checkCanceled) {
        this.dictionary.words.processAllWords(1, Integer.MAX_VALUE, false, e -> {
            String rootStr = e.root().toString();
            IntsRef forms = e.forms();
            for (int i = 0; i < forms.length; i += this.dictionary.formStep()) {
                char[] encodedFlags = this.dictionary.flagLookup.getFlags(forms.ints[forms.offset + i]);
                if (!this.shouldConsiderAtAll(encodedFlags)) continue;
                String presentableFlags = this.dictionary.flagParsingStrategy.printFlags(encodedFlags);
                DictEntry entry = DictEntry.create(rootStr, presentableFlags);
                for (AffixedWord aw : this.getAllWordForms(entry, encodedFlags, checkCanceled)) {
                    consumer.accept(aw);
                }
            }
        });
    }

    public EntrySuggestion compress(List<String> words, Set<String> forbidden, Runnable checkCanceled) {
        if (words.isEmpty()) {
            return null;
        }
        if (words.stream().anyMatch(forbidden::contains)) {
            throw new IllegalArgumentException("'words' and 'forbidden' shouldn't intersect");
        }
        return new WordCompressor(words, forbidden, checkCanceled).compress();
    }

    private boolean isCompatibleWithPreviousAffixes(AffixedWord stem, AffixKind kind, char flag) {
        boolean isPrefix = kind == AffixKind.PREFIX;
        List<AffixedWord.Affix> sameAffixes = isPrefix ? stem.getPrefixes() : stem.getSuffixes();
        int size = sameAffixes.size();
        if (size == 2) {
            return false;
        }
        if (isPrefix && size == 1 && !this.dictionary.complexPrefixes) {
            return false;
        }
        if (!isPrefix && !stem.getPrefixes().isEmpty()) {
            return false;
        }
        return size != 1 || this.dictionary.isFlagAppendedByAffix(sameAffixes.get((int)0).affixId, flag);
    }

    private record AffixEntry(int id, char flag, AffixKind kind, String affix, String strip, AffixCondition condition) {
        AffixedWord apply(AffixedWord stem, Dictionary dictionary) {
            String stripped;
            boolean isPrefix;
            String word = stem.getWord();
            boolean bl = isPrefix = this.kind == AffixKind.PREFIX;
            if (!(!isPrefix ? word.endsWith(this.strip) : word.startsWith(this.strip))) {
                return null;
            }
            String string = stripped = isPrefix ? word.substring(this.strip.length()) : word.substring(0, word.length() - this.strip.length());
            if (!this.condition.acceptsStem(stripped)) {
                return null;
            }
            String applied = isPrefix ? this.affix + stripped : stripped + this.affix;
            List<AffixedWord.Affix> prefixes = isPrefix ? new ArrayList<AffixedWord.Affix>(stem.getPrefixes()) : stem.getPrefixes();
            ArrayList<AffixedWord.Affix> suffixes = isPrefix ? stem.getSuffixes() : new ArrayList<AffixedWord.Affix>(stem.getSuffixes());
            (isPrefix ? prefixes : suffixes).add(0, new AffixedWord.Affix(dictionary, this.id));
            return new AffixedWord(applied, stem.getDictEntry(), prefixes, suffixes);
        }
    }

    private class WordCompressor {
        private final Comparator<State> solutionFitness = Comparator.comparingInt(s -> -s.potentialCoverage).thenComparingInt(s -> s.stemToFlags.size()).thenComparingInt(s -> s.underGenerated).thenComparingInt(s -> s.overGenerated);
        private final Set<String> forbidden;
        private final Runnable checkCanceled;
        private final Set<String> wordSet;
        private final Set<String> existingStems;
        private final Map<String, Set<FlagSet>> stemToPossibleFlags = new HashMap<String, Set<FlagSet>>();
        private final Map<String, Set<String>> stemsToForms = new LinkedHashMap<String, Set<String>>();
        private final Map<StemWithFlags, List<String>> expansionCache = new HashMap<StemWithFlags, List<String>>();

        WordCompressor(List<String> words, final Set<String> forbidden, Runnable checkCanceled) {
            this.forbidden = forbidden;
            this.checkCanceled = checkCanceled;
            this.wordSet = new HashSet<String>(words);
            for (final String word : words) {
                checkCanceled.run();
                this.stemToPossibleFlags.computeIfAbsent(word, __ -> new LinkedHashSet());
                var processor = new Stemmer.StemCandidateProcessor(WordContext.SIMPLE_WORD){

                    @Override
                    boolean processStemCandidate(char[] chars, int offset, int length, int lastAffix, int outerPrefix, int innerPrefix, int outerSuffix, int innerSuffix) {
                        block8: {
                            FlagSet flagSet;
                            String candidate;
                            block7: {
                                candidate = new String(chars, offset, length);
                                CharHashSet flags = new CharHashSet();
                                if (outerPrefix >= 0) {
                                    flags.add(WordFormGenerator.this.dictionary.affixData(outerPrefix, 0));
                                }
                                if (innerPrefix >= 0) {
                                    flags.add(WordFormGenerator.this.dictionary.affixData(innerPrefix, 0));
                                }
                                if (outerSuffix >= 0) {
                                    flags.add(WordFormGenerator.this.dictionary.affixData(outerSuffix, 0));
                                }
                                if (innerSuffix >= 0) {
                                    flags.add(WordFormGenerator.this.dictionary.affixData(innerSuffix, 0));
                                }
                                flagSet = new FlagSet(flags, WordFormGenerator.this.dictionary);
                                StemWithFlags swf = new StemWithFlags(candidate, Set.of(flagSet));
                                if (forbidden.isEmpty()) break block7;
                                if (!WordCompressor.this.allGenerated(swf).stream().noneMatch(forbidden::contains)) break block8;
                            }
                            this.registerStem(candidate);
                            WordCompressor.this.stemToPossibleFlags.computeIfAbsent(candidate, __ -> new LinkedHashSet()).add(flagSet);
                        }
                        return true;
                    }

                    void registerStem(String stem) {
                        WordCompressor.this.stemsToForms.computeIfAbsent(stem, __ -> new LinkedHashSet()).add(word);
                    }
                };
                processor.registerStem(word);
                WordFormGenerator.this.stemmer.removeAffixes(word.toCharArray(), 0, word.length(), true, -1, -1, -1, processor);
            }
            this.existingStems = this.stemsToForms.keySet().stream().filter(stem -> WordFormGenerator.this.dictionary.lookupEntries((String)stem) != null).collect(Collectors.toSet());
        }

        EntrySuggestion compress() {
            Comparator<String> stemSorter = Comparator.comparing(s -> this.existingStems.contains(s)).thenComparing(s -> this.stemsToForms.get(s).size()).reversed();
            List<String> sortedStems = this.stemsToForms.keySet().stream().sorted(stemSorter).toList();
            PriorityQueue<State> queue = new PriorityQueue<State>(this.solutionFitness);
            HashSet<Map<String, Set<FlagSet>>> visited = new HashSet<Map<String, Set<FlagSet>>>();
            queue.offer(new State(Map.of(), this.wordSet.size(), 0, 0));
            State result = null;
            while (!queue.isEmpty()) {
                State state = queue.poll();
                if (state.underGenerated == 0) {
                    result = state;
                    break;
                }
                for (String string : sortedStems) {
                    State next;
                    Map<String, Set<FlagSet>> withStem;
                    if (state.stemToFlags.containsKey(string) || !visited.add(withStem = this.addStem(state, string)) || (next = this.newState(withStem)) == null || state.underGenerated <= next.underGenerated && next.potentialCoverage <= state.potentialCoverage) continue;
                    queue.offer(next);
                }
                if (state.potentialCoverage < this.wordSet.size()) continue;
                for (Map.Entry entry : state.stemToFlags.entrySet()) {
                    for (FlagSet flags : this.stemToPossibleFlags.get(entry.getKey())) {
                        State next;
                        Map<String, Set<FlagSet>> withFlags;
                        if (((Set)entry.getValue()).contains(flags) || !visited.add(withFlags = this.addFlags(state, (String)entry.getKey(), flags)) || (next = this.newState(withFlags)) == null || state.underGenerated <= next.underGenerated) continue;
                        queue.offer(next);
                    }
                }
            }
            return result == null ? null : this.toSuggestion(result);
        }

        EntrySuggestion toSuggestion(State state) {
            ArrayList<DictEntry> toEdit = new ArrayList<DictEntry>();
            ArrayList<DictEntry> toAdd = new ArrayList<DictEntry>();
            for (Map.Entry<String, Set<FlagSet>> entry : state.stemToFlags.entrySet()) {
                this.addEntry(toEdit, toAdd, entry.getKey(), FlagSet.flatten(entry.getValue()));
            }
            ArrayList<String> extraGenerated = new ArrayList<String>();
            for (String extra : this.allGenerated(state.stemToFlags).distinct().sorted().toList()) {
                if (this.wordSet.contains(extra) || this.existingStems.contains(extra)) continue;
                if (this.forbidden.contains(extra) && WordFormGenerator.this.dictionary.forbiddenword != '\u0000') {
                    this.addEntry(toEdit, toAdd, extra, CharHashSet.from((char[])new char[]{WordFormGenerator.this.dictionary.forbiddenword}));
                    continue;
                }
                extraGenerated.add(extra);
            }
            return new EntrySuggestion(toEdit, toAdd, extraGenerated);
        }

        private void addEntry(List<DictEntry> toEdit, List<DictEntry> toAdd, String stem, CharHashSet flags) {
            String flagString = this.toFlagString(flags);
            (this.existingStems.contains(stem) ? toEdit : toAdd).add(DictEntry.create(stem, flagString));
        }

        private Map<String, Set<FlagSet>> addStem(State state, String stem) {
            LinkedHashMap<String, Set<FlagSet>> stemToFlags = new LinkedHashMap<String, Set<FlagSet>>(state.stemToFlags);
            stemToFlags.put(stem, Set.of());
            return stemToFlags;
        }

        private Map<String, Set<FlagSet>> addFlags(State state, String stem, FlagSet flags) {
            LinkedHashMap<String, Set<FlagSet>> stemToFlags = new LinkedHashMap<String, Set<FlagSet>>(state.stemToFlags);
            LinkedHashSet<FlagSet> flagSets = new LinkedHashSet<FlagSet>((Collection)stemToFlags.get(stem));
            flagSets.add(flags);
            stemToFlags.put(stem, flagSets);
            return stemToFlags;
        }

        private State newState(Map<String, Set<FlagSet>> stemToFlags) {
            Set allGenerated = this.allGenerated(stemToFlags).collect(Collectors.toSet());
            int overGenerated = 0;
            for (String s2 : allGenerated) {
                if (this.forbidden.contains(s2)) {
                    return null;
                }
                if (this.wordSet.contains(s2)) continue;
                ++overGenerated;
            }
            int potentialCoverage = (int)stemToFlags.keySet().stream().flatMap(s -> this.stemsToForms.get(s).stream()).distinct().count();
            return new State(stemToFlags, (int)this.wordSet.stream().filter(s -> !allGenerated.contains(s)).count(), overGenerated, potentialCoverage);
        }

        private List<String> allGenerated(StemWithFlags swc) {
            Function<StemWithFlags, List> expandToWords = e -> this.expand(e.stem, FlagSet.flatten(e.flags)).stream().map(w -> w.getWord()).toList();
            return this.expansionCache.computeIfAbsent(swc, expandToWords);
        }

        private Stream<String> allGenerated(Map<String, Set<FlagSet>> stemToFlags) {
            return stemToFlags.entrySet().stream().flatMap(entry -> this.allGenerated(new StemWithFlags((String)entry.getKey(), (Set)entry.getValue())).stream());
        }

        private List<AffixedWord> expand(String stem, CharHashSet flagSet) {
            return WordFormGenerator.this.getAllWordForms(stem, this.toFlagString(flagSet), this.checkCanceled);
        }

        private String toFlagString(CharHashSet flagSet) {
            return WordFormGenerator.this.dictionary.flagParsingStrategy.printFlags(Dictionary.toSortedCharArray(flagSet));
        }

        private record StemWithFlags(String stem, Set<FlagSet> flags) {
        }
    }

    private record State(Map<String, Set<FlagSet>> stemToFlags, int underGenerated, int overGenerated, int potentialCoverage) {
    }

    private record FlagSet(CharHashSet flags, Dictionary dictionary) {
        static CharHashSet flatten(Set<FlagSet> flagSets) {
            CharHashSet set = new CharHashSet(flagSets.size() << 1);
            flagSets.forEach(flagSet -> set.addAll(flagSet.flags));
            return set;
        }

        @Override
        public String toString() {
            return this.dictionary.flagParsingStrategy.printFlags(Dictionary.toSortedCharArray(this.flags));
        }
    }
}

