/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features.fieldsfiltering;

import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.fieldsfiltering.FieldsFilter;
import org.eclipse.persistence.jpa.rs.features.fieldsfiltering.FieldsFilterType;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;

public final class FieldsFilteringValidator {
    public static final String FIELDS_PARAM_NAME = "fields";
    public static final String EXCL_FIELDS_PARAM_NAME = "excludeFields";
    private final Map<String, Object> queryParameters;
    private FieldsFilter filter;

    public FieldsFilteringValidator(UriInfo uri) {
        this.queryParameters = AbstractResource.getQueryParameters(uri);
    }

    public boolean isFeatureApplicable() throws JPARSException {
        if (!this.queryParameters.containsKey(FIELDS_PARAM_NAME) && !this.queryParameters.containsKey(EXCL_FIELDS_PARAM_NAME)) {
            return false;
        }
        if (this.queryParameters.containsKey(FIELDS_PARAM_NAME) && this.queryParameters.containsKey(EXCL_FIELDS_PARAM_NAME)) {
            throw JPARSException.fieldsFilteringBothParametersPresent();
        }
        this.filter = this.queryParameters.containsKey(FIELDS_PARAM_NAME) ? new FieldsFilter(FieldsFilterType.INCLUDE, (String)this.queryParameters.get(FIELDS_PARAM_NAME)) : new FieldsFilter(FieldsFilterType.EXCLUDE, (String)this.queryParameters.get(EXCL_FIELDS_PARAM_NAME));
        return true;
    }

    public FieldsFilter getFilter() {
        return this.filter;
    }
}

