/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.EnvironmentMessages;
import org.eclipse.wst.command.internal.env.common.FileResourceOutputStream;
import org.eclipse.wst.command.internal.env.context.PersistentResourceContext;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.environment.StatusException;

public final class FileResourceUtils {
    private static IWorkspace workspace_ = null;
    private static IWorkspaceRoot root_ = null;

    public static IWorkspaceRoot getWorkspaceRoot() {
        if (root_ == null) {
            root_ = ResourcesPlugin.getWorkspace().getRoot();
        }
        return root_;
    }

    public static IWorkspace getWorkspace() {
        if (workspace_ == null) {
            if (root_ == null) {
                root_ = ResourcesPlugin.getWorkspace().getRoot();
            }
            workspace_ = root_.getWorkspace();
        }
        return workspace_;
    }

    public static Choice[] getThreeStateFileOptions() {
        Vector<Choice> choices = new Vector<Choice>();
        choices.add(new Choice('Y', EnvironmentMessages.LABEL_YES));
        choices.add(new Choice('A', EnvironmentMessages.LABEL_YES_TO_ALL));
        choices.add(new Choice('C', EnvironmentMessages.LABEL_CANCEL));
        return choices.toArray(new Choice[choices.size()]);
    }

    public static IResource findResource(String absolutePathname) {
        if (absolutePathname == null) {
            return null;
        }
        return FileResourceUtils.findResource((IPath)new Path(absolutePathname));
    }

    public static IResource findResource(IPath absolutePath) {
        if (absolutePath == null) {
            return null;
        }
        return FileResourceUtils.getWorkspaceRoot().findMember(absolutePath);
    }

    public static void copyFile(ResourceContext resourceContext, Plugin plugin, IPath sourcePath, IPath pathname, IPath targetPath, IProgressMonitor progressMonitor, IStatusHandler statusMonitor) throws CoreException {
        try {
            IPath target = targetPath.append(pathname);
            IPath source = sourcePath == null ? pathname : sourcePath.append(pathname);
            InputStream input = plugin.openStream(source);
            FileResourceUtils.createFile(resourceContext, target, input, progressMonitor, statusMonitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, EnvironmentMessages.MSG_ERROR_IO, (Throwable)e));
        }
    }

    public static boolean deleteFile(ResourceContext resourceContext, IFile file, IProgressMonitor progressMonitor, IStatusHandler statusMonitor) throws CoreException {
        if (file.exists()) {
            Choice choice;
            IStatus status;
            if (!resourceContext.isOverwriteFilesEnabled()) {
                status = StatusUtils.warningStatus((String)NLS.bind((String)EnvironmentMessages.MSG_ERROR_FILE_OVERWRITE_DISABLED, (Object[])new Object[]{file.getParent().getFullPath().toString(), file.getName()}));
                choice = statusMonitor.report(status, FileResourceUtils.getThreeStateFileOptions());
                if (choice.getShortcut() == 'C') {
                    return false;
                }
                if (choice.getShortcut() == 'A') {
                    resourceContext.setOverwriteFilesEnabled(true);
                    PersistentResourceContext.getInstance().setOverwriteFilesEnabled(true);
                }
            }
            if (file.isReadOnly()) {
                if (!resourceContext.isCheckoutFilesEnabled()) {
                    status = StatusUtils.warningStatus((String)NLS.bind((String)EnvironmentMessages.MSG_ERROR_FILE_CHECKOUT_DISABLED, (Object[])new Object[]{file.getParent().getFullPath().toString(), file.getName()}));
                    choice = statusMonitor.report(status, FileResourceUtils.getThreeStateFileOptions());
                    if (choice.getShortcut() == 'C') {
                        return false;
                    }
                    if (choice.getShortcut() == 'A') {
                        resourceContext.setCheckoutFilesEnabled(true);
                        PersistentResourceContext.getInstance().setCheckoutFilesEnabled(true);
                    }
                }
                IFile[] files = new IFile[]{file};
                IStatus status2 = FileResourceUtils.getWorkspace().validateEdit(files, null);
                if (status2.getSeverity() == 4) {
                    statusMonitor.reportError(status2);
                    return false;
                }
            }
            file.delete(true, null);
        }
        return true;
    }

    public static boolean deleteFolder(ResourceContext resourceContext, IFolder folder, IProgressMonitor progressMonitor, IStatusHandler statusMonitor) throws CoreException {
        if (!folder.exists()) {
            return true;
        }
        boolean deleted = true;
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource instanceof IFile) {
                deleted = FileResourceUtils.deleteFile(resourceContext, (IFile)resource, progressMonitor, statusMonitor);
            }
            if (resource instanceof IFolder) {
                deleted = FileResourceUtils.deleteFolder(resourceContext, (IFolder)resource, progressMonitor, statusMonitor);
            }
            if (!deleted) break;
            ++i;
        }
        if (deleted) {
            folder.delete(true, true, null);
            return true;
        }
        return false;
    }

    public static IFile createFile(ResourceContext resourceContext, IPath absolutePath, InputStream inputStream, IProgressMonitor progressMonitor, IStatusHandler statusHandler) throws CoreException {
        if (!absolutePath.isAbsolute()) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)EnvironmentMessages.MSG_ERROR_PATH_NOT_ABSOLUTE, (Object[])new Object[]{absolutePath.toString()}), null));
        }
        if (absolutePath.segmentCount() < 1) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)EnvironmentMessages.MSG_ERROR_PATH_EMPTY, (Object[])new Object[]{absolutePath.toString()}), null));
        }
        if (absolutePath.segmentCount() < 2) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)EnvironmentMessages.MSG_ERROR_PATH_NOT_FOLDER, (Object[])new Object[]{absolutePath.toString()}), null));
        }
        IContainer parent = FileResourceUtils.makeFolderPath(resourceContext, absolutePath.removeLastSegments(1), progressMonitor, statusHandler);
        String fileName = absolutePath.lastSegment();
        return FileResourceUtils.makeFile(resourceContext, parent, fileName, inputStream, progressMonitor, statusHandler);
    }

    public static IFile createFile(ResourceContext resourceContext, IProject project, IPath relativePath, InputStream inputStream, IProgressMonitor progressMonitor, IStatusHandler statusMonitor) throws CoreException {
        IPath absolutePath = project.getFullPath().append(relativePath);
        return FileResourceUtils.createFile(resourceContext, absolutePath, inputStream, progressMonitor, statusMonitor);
    }

    public static OutputStream newFileOutputStream(ResourceContext context, IPath file, IProgressMonitor progressMonitor, IStatusHandler statusHandler) {
        return new FileResourceOutputStream(context, file, progressMonitor, statusHandler);
    }

    public static IContainer makeFolderPath(ResourceContext resourceContext, IPath absolutePath, IProgressMonitor progressMonitor, IStatusHandler statusHandler) throws CoreException {
        if (absolutePath.segmentCount() <= 1) {
            return FileResourceUtils.getWorkspaceRoot().getProject(absolutePath.segment(0));
        }
        IContainer parent = FileResourceUtils.makeFolderPath(resourceContext, absolutePath.removeLastSegments(1), progressMonitor, statusHandler);
        String folderName = absolutePath.lastSegment();
        FileResourceUtils.checkParent(parent, absolutePath);
        return FileResourceUtils.makeFolder(resourceContext, parent, folderName, progressMonitor, statusHandler);
    }

    private static void checkParent(IContainer parent, IPath absolutePath) throws CoreException {
        if (parent == null) {
            IPath parentPath = absolutePath.removeLastSegments(1);
            String folderPath = absolutePath.lastSegment();
            throw new CoreException(StatusUtils.warningStatus((String)NLS.bind((String)EnvironmentMessages.MSG_ERROR_FOLDER_CREATION_DISABLED, (Object[])new Object[]{parentPath.toString(), folderPath})));
        }
    }

    private static IFolder makeFolder(ResourceContext resourceContext, IContainer parent, String folderName, IProgressMonitor progressMonitor, IStatusHandler statusHandler) throws CoreException {
        IResource child = parent.findMember(folderName);
        Choice result = null;
        if (child == null) {
            if (!resourceContext.isCreateFoldersEnabled()) {
                result = statusHandler.report(StatusUtils.warningStatus((String)NLS.bind((String)EnvironmentMessages.MSG_ERROR_FOLDER_CREATION_DISABLED, (Object[])new Object[]{parent.getFullPath().toString(), folderName})), FileResourceUtils.getThreeStateFileOptions());
                if (result == null || result.getShortcut() == 'C') {
                    return null;
                }
                if (result.getShortcut() == 'A') {
                    resourceContext.setCreateFoldersEnabled(true);
                    PersistentResourceContext.getInstance().setCreateFoldersEnabled(true);
                }
            }
            IFolder folder = parent.getFolder((IPath)new Path(folderName));
            folder.create(true, true, null);
            return folder;
        }
        if (child.getType() == 2) {
            return (IFolder)child;
        }
        throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)EnvironmentMessages.MSG_ERROR_RESOURCE_NOT_FOLDER, (Object[])new Object[]{parent.getFullPath().append(folderName).toString()}), null));
    }

    /*
     * Unable to fully structure code
     */
    private static IFile makeFile(ResourceContext resourceContext, IContainer parent, String fileName, InputStream inputStream, IProgressMonitor progressMonitor, IStatusHandler statusHandler) throws CoreException {
        block18: {
            file = parent.getFile((IPath)new Path(fileName));
            if (!file.exists()) {
                block17: {
                    try {
                        file.create(inputStream, true, null);
                        return file;
                    }
                    catch (CoreException coreException) {
                        if (coreException.getStatus().getCode() != 275) break block17;
                        foundIgnoringCase = false;
                        var12_11 = parent.members();
                        var11_12 = var12_11.length;
                        var10_13 = 0;
                        ** while (var10_13 < var11_12)
                    }
lbl-1000:
                    // 1 sources

                    {
                        resource = var12_11[var10_13];
                        if (resource.getName().equalsIgnoreCase(fileName)) {
                            foundIgnoringCase = true;
                            fileName = resource.getName();
                            file = parent.getFile((IPath)new Path(fileName));
                            break;
                        }
                        ++var10_13;
                        continue;
                    }
lbl21:
                    // 2 sources

                    if (!foundIgnoringCase) {
                        throw coreException;
                    }
                    break block18;
                }
                throw coreException;
            }
        }
        result = null;
        if (file.getType() == 1) {
            if (!resourceContext.isOverwriteFilesEnabled()) {
                result = statusHandler.report(StatusUtils.warningStatus((String)NLS.bind((String)EnvironmentMessages.MSG_ERROR_FILE_OVERWRITE_DISABLED, (Object[])new Object[]{parent.getFullPath().toString(), fileName})), FileResourceUtils.getThreeStateFileOptions());
                if (result == null || result.getShortcut() == 'C') {
                    return null;
                }
                if (result.getShortcut() == 'A') {
                    resourceContext.setOverwriteFilesEnabled(true);
                    PersistentResourceContext.getInstance().setOverwriteFilesEnabled(true);
                }
            }
            if (file.getResourceAttributes() == null) {
                throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, file.getFullPath().toString(), null));
            }
            if (file.getResourceAttributes().isReadOnly()) {
                if (!resourceContext.isCheckoutFilesEnabled()) {
                    result = statusHandler.report(StatusUtils.errorStatus((String)NLS.bind((String)EnvironmentMessages.MSG_ERROR_FILE_CHECKOUT_DISABLED, (Object[])new Object[]{parent.getFullPath().toString(), fileName})), FileResourceUtils.getThreeStateFileOptions());
                    if (result == null || result.getShortcut() == 'C') {
                        return null;
                    }
                    if (result.getShortcut() == 'A') {
                        resourceContext.setCheckoutFilesEnabled(true);
                        PersistentResourceContext.getInstance().setCheckoutFilesEnabled(true);
                    }
                }
                files = new IFile[]{file};
                status = FileResourceUtils.getWorkspace().validateEdit(files, null);
                try {
                    statusHandler.report(status);
                }
                catch (StatusException v0) {
                    return null;
                }
            }
            file.setContents(inputStream, true, true, null);
            return file;
        }
        throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)EnvironmentMessages.MSG_ERROR_RESOURCE_NOT_FILE, (Object[])new Object[]{parent.getFullPath().append(fileName)}), null));
    }

    public static IFile createFileAtLocation(ResourceContext resourceContext, IPath absolutePath, InputStream inputStream, IProgressMonitor progressMonitor, IStatusHandler statusHandler) throws CoreException {
        if (!absolutePath.isAbsolute()) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)EnvironmentMessages.MSG_ERROR_PATH_NOT_ABSOLUTE, (Object[])new Object[]{absolutePath.toString()}), null));
        }
        if (absolutePath.segmentCount() < 1) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)EnvironmentMessages.MSG_ERROR_PATH_EMPTY, (Object[])new Object[]{absolutePath.toString()}), null));
        }
        if (absolutePath.segmentCount() < 2) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)EnvironmentMessages.MSG_ERROR_PATH_NOT_FOLDER, (Object[])new Object[]{absolutePath.toString()}), null));
        }
        IContainer parent = FileResourceUtils.makeFolderPathAtLocation(resourceContext, absolutePath.removeLastSegments(1), progressMonitor, statusHandler);
        String fileName = absolutePath.lastSegment();
        FileResourceUtils.checkParent(parent, absolutePath);
        return FileResourceUtils.makeFile(resourceContext, parent, fileName, inputStream, progressMonitor, statusHandler);
    }

    public static IContainer makeFolderPathAtLocation(ResourceContext resourceContext, IContainer resource, IProgressMonitor progressMonitor, IStatusHandler statusHandler) throws CoreException {
        if (resource.exists()) {
            if (resource instanceof IContainer) {
                return resource;
            }
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)EnvironmentMessages.MSG_ERROR_RESOURCE_NOT_FOLDER, (Object[])new Object[]{resource.getFullPath().toString()}), null));
        }
        IContainer parent = FileResourceUtils.makeFolderPathAtLocation(resourceContext, resource.getParent(), progressMonitor, statusHandler);
        String folderName = resource.getName();
        return FileResourceUtils.makeFolder(resourceContext, parent, folderName, progressMonitor, statusHandler);
    }

    public static IContainer makeFolderPathAtLocation(ResourceContext resourceContext, IPath absolutePath, IProgressMonitor progressMonitor, IStatusHandler statusHandler) throws CoreException {
        return FileResourceUtils.makeFolderPathAtLocation(resourceContext, FileResourceUtils.getWorkspaceRoot().getContainerForLocation(absolutePath), progressMonitor, statusHandler);
    }
}

