/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.dialect.editor;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.business.internal.session.danalysis.SessionLazyCrossReferencer;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class DialectEditorCloserFilter
extends NotificationFilter.Custom {
    private DRepresentationDescriptor dRepDescriptor;

    public DialectEditorCloserFilter(DRepresentationDescriptor dRepresentationDescriptor) {
        Assert.isNotNull((Object)dRepresentationDescriptor);
        this.dRepDescriptor = dRepresentationDescriptor;
    }

    public boolean matches(Notification notification) {
        if (notification.isTouch()) {
            boolean currentDRepDescriptorTarget;
            boolean bl = currentDRepDescriptorTarget = notification.getNotifier() == this.dRepDescriptor && notification.getFeature() == ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__TARGET;
            return currentDRepDescriptorTarget && notification.getEventType() == 1 && notification.getNewValue() == null;
        }
        return this.isTargetUnset(notification) || this.isRepresentationDeletion(notification) || this.isTargetDetachment(notification);
    }

    private void resolveDRepDescriptorProxy(Notification notification) {
        if (this.dRepDescriptor.eIsProxy()) {
            this.dRepDescriptor = Optional.ofNullable(notification.getNotifier()).filter(EObject.class::isInstance).map(EObject.class::cast).map(eObject -> eObject.eResource()).map(eResource -> eResource.getResourceSet()).map(resourceSet -> resourceSet.getEObject(EcoreUtil.getURI((EObject)this.dRepDescriptor), false)).filter(DRepresentationDescriptor.class::isInstance).map(DRepresentationDescriptor.class::cast).orElse(this.dRepDescriptor);
        }
    }

    private boolean isTargetUnset(Notification notification) {
        boolean unsetNotification = this.isUnsetNotification(notification);
        return unsetNotification && notification.getNotifier() == this.dRepDescriptor && notification.getFeature() == ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__TARGET;
    }

    private boolean isUnsetNotification(Notification notification) {
        boolean setToNull;
        int eventType = notification.getEventType();
        boolean bl = setToNull = eventType == 1 && notification.getNewValue() == null;
        return setToNull || eventType == 4 || eventType == 2 || eventType == 6;
    }

    private boolean isRepresentationDeletion(Notification notification) {
        boolean representationDeleted = false;
        this.resolveDRepDescriptorProxy(notification);
        if (notification.getFeature() == ViewpointPackage.Literals.DVIEW__OWNED_REPRESENTATION_DESCRIPTORS && this.wasInOldValue(notification, (EObject)this.dRepDescriptor)) {
            representationDeleted = !(this.dRepDescriptor.eContainer() instanceof DView);
        } else if (notification.getFeature() == ViewpointPackage.Literals.DANALYSIS__OWNED_VIEWS && this.wasInOldValue(notification, this.dRepDescriptor.eContainer())) {
            representationDeleted = this.dRepDescriptor.eContainer() == null || this.dRepDescriptor.eContainer() == null || !(this.dRepDescriptor.eContainer().eContainer() instanceof DView);
        } else if (notification.getFeature() == ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__REPRESENTATION) {
            representationDeleted = notification.getNewValue() == null && notification.getOldValue() != null && notification.getNotifier() == this.dRepDescriptor;
        } else if (SessionLazyCrossReferencer.isTopLevelRepresentationRemoval((Notification)notification) && notification.getOldValue() instanceof DRepresentation && notification.getNotifier() instanceof Resource) {
            DRepresentation rep = (DRepresentation)notification.getOldValue();
            Resource res = (Resource)notification.getNotifier();
            ResourceDescriptor repPathBeforeDeletion = new ResourceDescriptor(res.getURI().appendFragment(rep.getUid()));
            representationDeleted = repPathBeforeDeletion.equals((Object)this.dRepDescriptor.getRepPath());
        }
        return representationDeleted;
    }

    private boolean wasInOldValue(Notification notification, EObject eObject) {
        boolean isCurrentDRepresentationRemove = false;
        if (this.isUnsetNotification(notification)) {
            isCurrentDRepresentationRemove = this.isInOldValue(notification, eObject);
        }
        return isCurrentDRepresentationRemove;
    }

    private boolean isInOldValue(Notification notification, EObject obj) {
        if (notification.getOldValue() instanceof Collection) {
            return ((Collection)notification.getOldValue()).contains(obj);
        }
        return notification.getOldValue() == obj;
    }

    private boolean isTargetDetachment(Notification notification) {
        boolean detachedTarget = false;
        if (DanglingRefRemovalTrigger.IS_DETACHMENT.apply((Object)notification)) {
            EObject target;
            this.resolveDRepDescriptorProxy(notification);
            DRepresentation representation = this.dRepDescriptor.getRepresentation();
            detachedTarget = representation instanceof DSemanticDecorator ? this.isInOldValue(notification, target = ((DSemanticDecorator)representation).getTarget()) && target.eContainer() == null : this.isInOldValue(notification, target = this.dRepDescriptor.getTarget()) && target.eContainer() == null;
        }
        return detachedTarget;
    }
}

