/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import java.util.StringTokenizer;

public class SystemDefaultCompileCommand {
    protected String name;
    protected String label;
    protected String jobEnv;
    protected String addlParms;
    protected String[] srcTypes;

    public SystemDefaultCompileCommand(String commandLabel, String commandName) {
        this.name = commandName;
        this.label = commandLabel;
    }

    public SystemDefaultCompileCommand(String commandName) {
        this(commandName, commandName);
    }

    public SystemDefaultCompileCommand(String commandLabel, String commandName, String parameters) {
        this(commandLabel, commandName);
        this.setAdditionalParameters(parameters);
    }

    public void setAdditionalParameters(String parms) {
        this.addlParms = " " + parms;
    }

    public void setSourceType(String type) {
        this.setSourceTypes(new String[]{type});
    }

    public void setSourceTypes(String[] types) {
        this.srcTypes = types;
    }

    public String[] getSourceTypes() {
        return this.srcTypes;
    }

    public boolean appliesToSourceType(String type) {
        if (this.srcTypes == null) {
            return false;
        }
        boolean match = false;
        int idx = 0;
        while (!match && idx < this.srcTypes.length) {
            if (type.equals(this.srcTypes[idx])) {
                match = true;
            }
            ++idx;
        }
        return match;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public String getCommandWithParameters() {
        return this.getCommandWithParameters(null);
    }

    public void setJobEnvironment(String jobEnv) {
        this.jobEnv = jobEnv;
    }

    public String getJobEnvironment() {
        return this.jobEnv;
    }

    public String fillWithRequiredParams(String commandParams) {
        if (commandParams == null || commandParams.length() == 0) {
            return this.getCommandWithParameters();
        }
        return this.getCommandWithParameters(commandParams);
    }

    public void printCommandLabel() {
        System.out.println(this.label);
    }

    public void printCommandName() {
        System.out.println(this.name);
    }

    public void printCommand() {
        System.out.println(this.getCommandWithParameters());
    }

    protected String getCommandWithParameters(String existingParameters) {
        StringBuffer buffer = null;
        buffer = existingParameters == null ? new StringBuffer(this.name) : new StringBuffer(String.valueOf(this.name) + " " + existingParameters);
        this.populateWithParameters(buffer);
        if (this.addlParms != null) {
            if (existingParameters == null) {
                buffer.append(" " + this.addlParms);
            } else {
                StringTokenizer tokens = new StringTokenizer(this.addlParms);
                while (tokens.hasMoreTokens()) {
                    String parm = tokens.nextToken();
                    String parmName = parm.substring(0, parm.indexOf(40) + 1);
                    if (existingParameters.indexOf(parmName) != -1) continue;
                    buffer.append(" " + parm);
                }
            }
        }
        return buffer.toString();
    }

    protected void populateWithParameters(StringBuffer bufferSoFar) {
    }
}

