/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.importer.ecore.EcoreImporter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.common.AbstractQVTc2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTrNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.RelationalTransformation2CoreTransformation;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.RelationalTransformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.QVTcoreFactory;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationModel;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public class QVTr2QVTc
extends AbstractQVTc2QVTc {
    public static final @NonNull TracingOption SYNTHESIS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtr2qvtc/synthesis");
    public static final @NonNull TracingOption VARIABLES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtr2qvtc/variables");
    private final @NonNull Resource qvtrResource;
    protected final @NonNull QVTrNameGenerator nameGenerator;
    private @Nullable String traceNsURI = null;
    private final @NonNull Map<@NonNull Element, @NonNull Element> globalTarget2source = new HashMap<Element, Element>();
    private final @NonNull Map<@NonNull Element, @NonNull List<@NonNull Element>> globalSource2targets = new HashMap<Element, List<Element>>();
    private @NonNull CoreModel coreModel;
    private @NonNull Map<@NonNull TypedModel, @NonNull TypedModel> coreTypedModel2relationalTypedModel = new HashMap<TypedModel, TypedModel>();
    private final @NonNull List<@NonNull Package> txTracePackages = new ArrayList<Package>();
    private @NonNull Map<@NonNull TypedModel, @NonNull TypedModel> relationalTypedModel2coreTypedModel = new HashMap<TypedModel, TypedModel>();
    private @NonNull Map<@NonNull RelationalTransformation, @NonNull TransformationAnalysis> transformation2transformationAnalysis = new HashMap<RelationalTransformation, TransformationAnalysis>();
    private @NonNull Map<@NonNull TransformationAnalysis, @NonNull RelationalTransformation2CoreTransformation> transformationAnalysis2relationalTransformation2coreTransformation = new HashMap<TransformationAnalysis, RelationalTransformation2CoreTransformation>();
    private @NonNull Map<@NonNull TransformationAnalysis, @NonNull RelationalTransformation2TracePackage> transformationAnalysis2relationalTransformation2tracePackage = new HashMap<TransformationAnalysis, RelationalTransformation2TracePackage>();
    private @Nullable Property oclContainerProperty = null;

    public static @NonNull String getProjectName(@NonNull URI traceURI) {
        URI trimFileExtension = traceURI.trimFileExtension();
        if (trimFileExtension.isPlatform()) {
            return trimFileExtension.segment(1);
        }
        return trimFileExtension.segment(0);
    }

    public QVTr2QVTc(@NonNull EnvironmentFactory environmentFactory, @NonNull Resource qvtrResource) {
        super(environmentFactory);
        this.qvtrResource = qvtrResource;
        this.nameGenerator = new QVTrNameGenerator();
        this.coreModel = QVTcoreFactory.eINSTANCE.createCoreModel();
    }

    public void analyze() {
        TreeIterator it = this.qvtrResource.getAllContents();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            if (eo instanceof RelationalTransformation) {
                RelationalTransformation rTransformation = (RelationalTransformation)eo;
                this.transformation2transformationAnalysis.put(rTransformation, new TransformationAnalysis(this, rTransformation));
            }
            if (!(eo instanceof Import)) continue;
            this.coreModel.getOwnedImports().add((Import)EcoreUtil.copy((EObject)eo));
        }
        for (TransformationAnalysis transformationAnalysis : this.transformation2transformationAnalysis.values()) {
            transformationAnalysis.analyze();
        }
    }

    public Element createCopy(@NonNull Element cElement) {
        return (Element)cElement.accept((Visitor)this.createVisitor);
    }

    public @NonNull CoreDomain createCoreDomain(@NonNull TypedModel typedModel) {
        CoreDomain coreDomain = QVTcoreFactory.eINSTANCE.createCoreDomain();
        coreDomain.setTypedModel(typedModel);
        coreDomain.setName(QVTrelationUtil.getName((NamedElement)typedModel));
        GuardPattern guardPattern = QVTcoreFactory.eINSTANCE.createGuardPattern();
        coreDomain.setGuardPattern(guardPattern);
        BottomPattern bottomPattern = QVTcoreFactory.eINSTANCE.createBottomPattern();
        coreDomain.setBottomPattern(bottomPattern);
        return coreDomain;
    }

    @Override
    protected @NonNull AbstractQVTc2QVTc.AbstractCreateVisitor<@NonNull ?> createCreateVisitor() {
        return new CreateVisitor(this);
    }

    @Override
    protected @NonNull AbstractQVTc2QVTc.AbstractUpdateVisitor<@NonNull ?> createUpdateVisitor() {
        return new UpdateVisitor(this);
    }

    public void dispose() {
    }

    public @NonNull TypedModel getCoreTypedModel(@NonNull TypedModel relationTypedModel) {
        return (TypedModel)ClassUtil.nonNullState((Object)this.relationalTypedModel2coreTypedModel.get(relationTypedModel));
    }

    public @Nullable List<@NonNull Element> getGlobalTargets(@NonNull Element element) {
        return this.globalSource2targets.get(element);
    }

    public @NonNull QVTrNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public @NonNull Property getOclContainerProperty() {
        Property oclContainerProperty2 = this.oclContainerProperty;
        if (oclContainerProperty2 == null) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            oclContainerProperty2 = (Property)NameUtil.getNameable((Iterable)oclElementType.getOwnedProperties(), (String)"oclContainer");
            assert (oclContainerProperty2 != null) : "OCL Standard Library has no OclElement::oclContainer property";
            this.oclContainerProperty = oclContainerProperty2;
        }
        return oclContainerProperty2;
    }

    public @NonNull ProblemHandler getProblemHandler() {
        throw new UnsupportedOperationException("This is a stub in stale code");
    }

    public @NonNull RelationalTransformation2CoreTransformation getRelationalTransformation2CoreTransformation(@NonNull TransformationAnalysis transformationAnalysis) {
        return (RelationalTransformation2CoreTransformation)((Object)ClassUtil.nonNullState((Object)((Object)this.transformationAnalysis2relationalTransformation2coreTransformation.get((Object)transformationAnalysis))));
    }

    public @NonNull RelationalTransformation2TracePackage getRelationalTransformation2TracePackage(@NonNull TransformationAnalysis transformationAnalysis) {
        return (RelationalTransformation2TracePackage)((Object)ClassUtil.nonNullState((Object)((Object)this.transformationAnalysis2relationalTransformation2tracePackage.get((Object)transformationAnalysis))));
    }

    public @NonNull TypedModel getRelationTypedModel(@NonNull TypedModel coreTypedModel) {
        return (TypedModel)ClassUtil.nonNullState((Object)this.coreTypedModel2relationalTypedModel.get(coreTypedModel));
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    public @NonNull TransformationAnalysis getTransformationAnalysis(@NonNull RelationalTransformation rTransformation) {
        return (TransformationAnalysis)((Object)ClassUtil.nonNullState((Object)((Object)this.transformation2transformationAnalysis.get(rTransformation))));
    }

    private void getUsedGenPackageClosure(@NonNull ProblemHandler problemHandler, @NonNull Map<@NonNull String, @NonNull GenPackage> uri2genPackage, @NonNull Iterable<@NonNull ? extends GenPackage> genPackages) {
        for (GenPackage genPackage : genPackages) {
            String nsURI = genPackage.getNSURI();
            if (nsURI == null) {
                problemHandler.addProblem(new CompilerChainException("Null nsURI for " + genPackage, genPackage));
                continue;
            }
            GenPackage oldGenPackage = uri2genPackage.put(nsURI, genPackage);
            if (oldGenPackage == genPackage) continue;
            if (oldGenPackage != null) {
                problemHandler.addProblem(new CompilerChainException("Conflicting " + oldGenPackage + " ignored", oldGenPackage));
                continue;
            }
            GenModel newGenModel = genPackage.getGenModel();
            EList newUsedGenPackages = ClassUtil.nullFree((EList)newGenModel.getUsedGenPackages());
            this.getUsedGenPackageClosure(problemHandler, uri2genPackage, (Iterable<? extends GenPackage>)newUsedGenPackages);
        }
    }

    void putGlobalTrace(@NonNull Element coreElement, @NonNull Element relationElement) {
        Element oldRelationElement = this.globalTarget2source.put(coreElement, relationElement);
        assert (oldRelationElement == null);
        List<@NonNull Element> targets = this.globalSource2targets.get(relationElement);
        if (targets == null) {
            targets = new ArrayList<Element>();
            this.globalSource2targets.put(relationElement, targets);
        }
        targets.add(coreElement);
    }

    public void putTypedModel(@NonNull TypedModel relationTypedModel, @NonNull TypedModel coreTypedModel) {
        TypedModel oldTypedModel = this.relationalTypedModel2coreTypedModel.put(relationTypedModel, coreTypedModel);
        assert (oldTypedModel == null);
        oldTypedModel = this.coreTypedModel2relationalTypedModel.put(coreTypedModel, relationTypedModel);
        assert (oldTypedModel == null);
    }

    public void saveCore(@NonNull Resource asResource, @NonNull Map<?, ?> options) throws IOException {
        asResource.getContents().add((Object)this.coreModel);
        for (Package asPackage : this.txTracePackages) {
            Import asImport = this.createImport(null, (Namespace)asPackage);
            this.coreModel.getOwnedImports().add(asImport);
        }
        asResource.save(options);
    }

    public @NonNull GenModel saveGenModel(@NonNull ProblemHandler problemHandler, @NonNull Resource asResource, @NonNull URI traceURI, @NonNull URI genModelURI, @Nullable String modelDirectory, @Nullable Map<@NonNull String, @Nullable String> genModelOptions, @NonNull Map<Object, Object> saveOptions2, @Nullable Collection<@NonNull ? extends GenPackage> usedGenPackages) throws IOException {
        String copyrightText;
        URI trimFileExtension = traceURI.trimFileExtension();
        String projectName = QVTr2QVTc.getProjectName(traceURI);
        if (modelDirectory == null) {
            modelDirectory = "/" + projectName + "/" + "test-src";
        }
        Resource genmodelResource = this.environmentFactory.getResourceSet().createResource(genModelURI);
        @NonNull GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        genModel.getForeignModel().add((Object)traceURI.lastSegment());
        String string = copyrightText = genModelOptions != null ? genModelOptions.get("genModelCopyrightText") : null;
        if (copyrightText != null) {
            genModel.setCopyrightText(copyrightText);
        }
        HashMap<@NonNull String, @NonNull GenPackage> uri2genPackage = new HashMap<String, GenPackage>();
        ArrayList<@NonNull V> allUsedGenPackages = new ArrayList();
        if (usedGenPackages != null) {
            this.getUsedGenPackageClosure(problemHandler, uri2genPackage, usedGenPackages);
            allUsedGenPackages.addAll(uri2genPackage.values());
            Collections.sort(allUsedGenPackages, GenPackageComparator.INSTANCE);
            genModel.getUsedGenPackages().addAll(allUsedGenPackages);
        }
        genModel.setModelDirectory(modelDirectory);
        genModel.setModelPluginID(projectName);
        genModel.setModelName(trimFileExtension.lastSegment());
        genModel.setBundleManifest(false);
        genModel.setUpdateClasspath(false);
        genModel.setImporterID(new EcoreImporter().getID());
        genModel.setComplianceLevel(GenJDKLevel.JDK80_LITERAL);
        genModel.setCopyrightFields(false);
        genModel.setOperationReflection(true);
        genModel.setImportOrganizing(true);
        genModel.setRootExtendsClass(MinimalEObjectImpl.Container.class.getName());
        genModel.setPluginKey("");
        genmodelResource.getContents().add((Object)genModel);
        String basePrefix = genModelOptions != null ? genModelOptions.get("genModelBasePrefix") : null;
        EList genPackages = genModel.getGenPackages();
        for (EObject eObject : asResource.getContents()) {
            if (!(eObject instanceof Model)) continue;
            Model asModel = (Model)eObject;
            for (Package asPackage : QVTrelationUtil.getOwnedPackages((Model)asModel)) {
                GenPackage genPackage = genModel.createGenPackage();
                EPackage ePackage = (EPackage)asPackage.getESObject();
                genPackage.setEcorePackage(ePackage);
                genPackage.setPrefix(ePackage.getName());
                if (basePrefix != null) {
                    genPackage.setBasePackage(basePrefix);
                }
                genPackages.add(genPackage);
            }
            HashSet<@NonNull Package> asPackages = new HashSet<Package>();
            for (EObject element : new TreeIterable((EObject)asModel, false)) {
                Package asPackage;
                if (!(element instanceof Property)) continue;
                Property property = (Property)element;
                Type type = property.getType();
                while (type instanceof CollectionType) {
                    type = ((CollectionType)type).getElementType();
                }
                if (!(type instanceof Class) || (asPackage = ((Class)type).getOwningPackage()) == null) continue;
                asPackages.add(asPackage);
            }
            for (Import asImport : QVTrelationUtil.getOwnedImports((Model)asModel)) {
                Namespace asNamespace = asImport.getImportedNamespace();
                if (!(asNamespace instanceof Package)) continue;
                @NonNull Package asPackage = (Package)asNamespace;
                asPackages.add(asPackage);
            }
            ArrayList<@NonNull E> asPackageList = new ArrayList(asPackages);
            Collections.sort(asPackageList, NameUtil.NAMEABLE_COMPARATOR);
            for (Package asPackage : asPackageList) {
                EPackage ePackage = (EPackage)asPackage.getESObject();
                if (ePackage == null) continue;
                GenPackage genPackage = null;
                if (allUsedGenPackages != null) {
                    for (GenPackage usedGenPackage : allUsedGenPackages) {
                        EPackage ecorePackage = usedGenPackage.getEcorePackage();
                        if (ecorePackage == null || !ClassUtil.safeEquals((Object)ecorePackage.getNsURI(), (Object)ePackage.getNsURI())) continue;
                        genPackage = usedGenPackage;
                        break;
                    }
                }
                if (genPackage != null) continue;
                for (GenPackage aGenPackage : genPackages) {
                    if (aGenPackage.getEcorePackage() != ePackage) continue;
                    genPackage = aGenPackage;
                    break;
                }
                if (genPackage != null) continue;
                genPackage = genModel.createGenPackage();
                genPackage.setEcorePackage(ePackage);
                genPackage.setPrefix(ePackage.getName());
                if (basePrefix != null) {
                    genPackage.setBasePackage(basePrefix);
                }
                genPackages.add(genPackage);
            }
        }
        genModel.reconcile();
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>(saveOptions2);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("LINE_DELIMITER", "\n");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        genmodelResource.save(saveOptions);
        return genModel;
    }

    public @NonNull Resource saveTrace(@NonNull Resource asResource, @NonNull URI traceURI, @Nullable Map<@NonNull String, @Nullable String> traceOptions, @NonNull Map<?, ?> saveOptions) throws IOException {
        Model root = PivotFactory.eINSTANCE.createModel();
        root.setExternalURI(traceURI.toString());
        asResource.getContents().add((Object)root);
        if (this.traceNsURI != null && this.txTracePackages.size() == 1) {
            this.txTracePackages.get(0).setURI(this.traceNsURI);
        }
        Iterator<Package> iterator = this.txTracePackages.iterator();
        while (iterator.hasNext()) {
            Package txTracePackage;
            @NonNull Package rootPackage = txTracePackage = iterator.next();
            EObject eContainer = rootPackage.eContainer();
            while (eContainer instanceof Package) {
                rootPackage = (Package)eContainer;
                eContainer = eContainer.eContainer();
            }
            if (root.getOwnedPackages().contains(rootPackage)) continue;
            root.getOwnedPackages().add(rootPackage);
        }
        AS2Ecore as2ecore = new AS2Ecore((EnvironmentFactoryInternal)this.environmentFactory, traceURI, null);
        XMLResource ecoreResource = as2ecore.convertResource(asResource, traceURI);
        ecoreResource.save(saveOptions);
        return ecoreResource;
    }

    public void setTraceNsURI(@Nullable String traceNsURI) {
        this.traceNsURI = traceNsURI;
    }

    public void transformToCoreTransformations() throws CompilerChainException {
        this.setDebugSource(this.qvtrResource);
        for (EObject eObject : this.qvtrResource.getContents()) {
            if (!(eObject instanceof RelationModel)) continue;
            RelationModel relationModel = (RelationModel)eObject;
            String externalURI = relationModel.getExternalURI();
            if (externalURI.endsWith(".qvtras")) {
                externalURI = externalURI.replace(".qvtras", ".qvtcas");
            } else if (externalURI.endsWith(".qvtr")) {
                externalURI = externalURI.replace(".qvtr", ".qvtcas");
            }
            this.coreModel.setExternalURI(externalURI);
            this.transformToCoreTransformationHierarchy(QVTrelationUtil.Internal.getOwnedPackagesList((Model)this.coreModel), QVTrelationUtil.getOwnedPackages((Model)relationModel));
        }
        ArrayList<@NonNull TransformationAnalysis> transformationAnalyses = new ArrayList<TransformationAnalysis>(this.transformation2transformationAnalysis.values());
        Collections.sort(transformationAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        for (TransformationAnalysis transformationAnalysis : transformationAnalyses) {
            RelationalTransformation2CoreTransformation relationalTransformation2CoreTransformation = this.getRelationalTransformation2CoreTransformation(transformationAnalysis);
            Transformation cTransformation = relationalTransformation2CoreTransformation.getCoreTransformation();
            this.pushScope((NamedElement)cTransformation);
            relationalTransformation2CoreTransformation.transformContents();
            this.popScope();
        }
    }

    private void transformToCoreTransformationHierarchy(@NonNull List<@NonNull Package> corePackages, @NonNull Iterable<@NonNull Package> relationPackages) {
        for (Package relationPackage : relationPackages) {
            String name = relationPackage.getName();
            assert (name != null);
            @NonNull Package corePackage = this.createPackage(name, relationPackage.getNsPrefix(), relationPackage.getURI());
            corePackages.add(corePackage);
            for (Class relationClass : QVTrelationUtil.getOwnedClasses((Package)relationPackage)) {
                if (!(relationClass instanceof RelationalTransformation)) continue;
                RelationalTransformation rTransformation = (RelationalTransformation)relationClass;
                TransformationAnalysis transformationAnalysis = this.getTransformationAnalysis(rTransformation);
                RelationalTransformation2CoreTransformation relationalTransformation2coreTransformation = new RelationalTransformation2CoreTransformation(this, transformationAnalysis);
                this.transformationAnalysis2relationalTransformation2coreTransformation.put(transformationAnalysis, relationalTransformation2coreTransformation);
                Transformation cTransformation = relationalTransformation2coreTransformation.transform();
                corePackage.getOwnedClasses().add(cTransformation);
            }
            CompilerUtil.normalizeNameables(QVTrelationUtil.Internal.getOwnedClassesList((Package)corePackage));
            this.transformToCoreTransformationHierarchy(QVTrelationUtil.Internal.getOwnedPackagesList((Package)corePackage), QVTrelationUtil.getOwnedPackages((Package)relationPackage));
        }
    }

    public void transformToTracePackages() throws CompilerChainException {
        ArrayList<@NonNull Package> rootTracePackages = null;
        for (EObject eObject : this.qvtrResource.getContents()) {
            List<Package> tracePackages;
            if (!(eObject instanceof RelationModel) || (tracePackages = this.transformToTracePackageHierarchy(QVTrelationUtil.getOwnedPackages((Model)((RelationModel)eObject)))) == null) continue;
            if (rootTracePackages == null) {
                rootTracePackages = new ArrayList<Package>();
            }
            rootTracePackages.addAll(tracePackages);
        }
        for (RelationalTransformation2TracePackage relationalTransformation2tracePackage : this.transformationAnalysis2relationalTransformation2tracePackage.values()) {
            relationalTransformation2tracePackage.freeze();
        }
        if (rootTracePackages != null) {
            CompilerUtil.normalizeNameables(rootTracePackages);
        }
    }

    private @Nullable List<@NonNull Package> transformToTracePackageHierarchy(@NonNull Iterable<@NonNull Package> relationPackages) throws CompilerChainException {
        ArrayList<@NonNull Package> nestingTracePackages = null;
        for (Package relationPackage : relationPackages) {
            ArrayList<Package> nestedTracePackages = null;
            for (Class relationClass : QVTrelationUtil.getOwnedClasses((Package)relationPackage)) {
                if (!(relationClass instanceof RelationalTransformation)) continue;
                TransformationAnalysis transformationAnalysis = this.getTransformationAnalysis((RelationalTransformation)relationClass);
                RelationalTransformation2TracePackage relationalTransformation2tracePackage = new RelationalTransformation2TracePackage(this, transformationAnalysis);
                this.transformationAnalysis2relationalTransformation2tracePackage.put(transformationAnalysis, relationalTransformation2tracePackage);
                Package nestedTracePackage = relationalTransformation2tracePackage.transform();
                this.txTracePackages.add(nestedTracePackage);
                if (nestedTracePackages == null) {
                    nestedTracePackages = new ArrayList();
                }
                nestedTracePackages.add(nestedTracePackage);
            }
            List<@NonNull Package> nestedTracePackages2 = this.transformToTracePackageHierarchy(QVTrelationUtil.Internal.getOwnedPackagesList((Package)relationPackage));
            if (nestedTracePackages2 != null) {
                if (nestedTracePackages == null) {
                    nestedTracePackages = new ArrayList<Package>();
                }
                nestedTracePackages.addAll(nestedTracePackages2);
            }
            if (nestedTracePackages == null) continue;
            CompilerUtil.normalizeNameables(nestedTracePackages);
            if (nestingTracePackages == null) {
                nestingTracePackages = new ArrayList<Package>();
            }
            nestingTracePackages.addAll(nestedTracePackages);
        }
        return nestingTracePackages;
    }

    public void updateCopy(@NonNull Element cElement) {
        cElement.accept((Visitor)this.updateVisitor);
    }

    protected static class CreateVisitor
    extends AbstractQVTc2QVTc.AbstractCreateVisitor<QVTr2QVTc> {
        public CreateVisitor(@NonNull QVTr2QVTc context) {
            super(context);
        }
    }

    public static final class GenPackageComparator
    implements Comparator<GenPackage> {
        public static final @NonNull GenPackageComparator INSTANCE = new GenPackageComparator();

        @Override
        public int compare(@NonNull GenPackage o1, @NonNull GenPackage o2) {
            String n1 = String.valueOf(o1.getNSURI());
            String n2 = String.valueOf(o2.getNSURI());
            return n1.compareTo(n2);
        }
    }

    public static final class RelationComparator
    implements Comparator<Relation> {
        private @NonNull Map<@NonNull Relation, @NonNull Set<@NonNull Relation>> relation2overriddens = new HashMap<Relation, Set<Relation>>();

        @Override
        public int compare(@NonNull Relation r1, @NonNull Relation r2) {
            boolean t2;
            boolean t1 = r1.isIsTopLevel();
            if (t1 != (t2 = r2.isIsTopLevel())) {
                return t1 ? -1 : 1;
            }
            Set<@NonNull Relation> o1 = this.getOverriddens(r1);
            Set<@NonNull Relation> o2 = this.getOverriddens(r2);
            if (o1.contains(r2)) {
                assert (!o2.contains(r1));
                return 1;
            }
            if (o2.contains(r1)) {
                return -1;
            }
            String n1 = NameUtil.getSafeName((Nameable)r1);
            String n2 = NameUtil.getSafeName((Nameable)r2);
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }

        private @NonNull Set<@NonNull Relation> getOverriddens(@NonNull Relation relation) {
            Set<@NonNull Relation> overriddens = this.relation2overriddens.get(relation);
            if (overriddens == null) {
                overriddens = new HashSet<Relation>();
                Relation overridden = relation;
                while (overridden != null) {
                    if (!overriddens.add(overridden)) {
                        QVTruntimeUtil.errPrintln((String)("Cyclic override for " + relation + " at " + overridden));
                        break;
                    }
                    overridden = QVTrelationUtil.basicGetOverridden((Relation)overridden);
                }
                this.relation2overriddens.put(relation, overriddens);
            }
            return overriddens;
        }
    }

    protected static class UpdateVisitor
    extends AbstractQVTc2QVTc.AbstractUpdateVisitor<QVTr2QVTc> {
        public UpdateVisitor(@NonNull QVTr2QVTc context) {
            super(context);
        }
    }
}

