/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.options.OCLinEcoreOptions;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.UniqueList;

public class DelegateInstaller {
    public static final @NonNull String OPTION_BOOLEAN_INVARIANTS = "booleanInvariants";
    public static final @NonNull String OPTION_OMIT_SETTING_DELEGATES = "omitSettingDelegates";
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull Map<String, Object> options;
    protected final @Nullable String exportDelegateURI;

    public static @NonNull String getAnnotationKey(@NonNull Constraint pivotConstraint) {
        String name = pivotConstraint.getName();
        EStructuralFeature eContainingFeature = pivotConstraint.eContainingFeature();
        if (eContainingFeature == PivotPackage.Literals.CLASS__OWNED_INVARIANTS) {
            if (pivotConstraint.isIsCallable()) {
                return "body";
            }
            return name != null ? name : "null";
        }
        if (eContainingFeature == PivotPackage.Literals.OPERATION__OWNED_PRECONDITIONS) {
            return name != null ? "pre_" + name : "pre";
        }
        if (eContainingFeature == PivotPackage.Literals.OPERATION__OWNED_POSTCONDITIONS) {
            return name != null ? "post_" + name : "post";
        }
        return "null";
    }

    public static @Nullable String getDelegateURI(@NonNull List<EObject> contents) {
        for (EObject eObject : contents) {
            String exportURI;
            if (!(eObject instanceof EPackage) || (exportURI = DelegateInstaller.getDelegateURI((EPackage)eObject)) == null) continue;
            return exportURI;
        }
        return null;
    }

    public static @Nullable String getDelegateURI(@NonNull EPackage ePackage) {
        HashSet allURIs = new HashSet();
        allURIs.addAll(ClassUtil.nonNull(EcoreUtil.getInvocationDelegates((EPackage)ePackage)));
        allURIs.addAll(ClassUtil.nonNull(EcoreUtil.getSettingDelegates((EPackage)ePackage)));
        allURIs.addAll(ClassUtil.nonNull(EcoreUtil.getValidationDelegates((EPackage)ePackage)));
        String theURI = null;
        for (String uri : allURIs) {
            if (!uri.startsWith("http://www.eclipse.org/emf/2002/Ecore/OCL")) continue;
            if (theURI != null) {
                return "http://www.eclipse.org/emf/2002/Ecore/OCL";
            }
            theURI = uri;
        }
        if (theURI != null) {
            return theURI;
        }
        for (EPackage eSubpackage : ePackage.getESubpackages()) {
            String exportURI = DelegateInstaller.getDelegateURI(eSubpackage);
            if (exportURI == null) continue;
            return exportURI;
        }
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EAnnotation classifierAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier);
            if (classifierAnnotation != null && !classifierAnnotation.getDetails().isEmpty()) {
                return classifierAnnotation.getSource();
            }
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
                EAnnotation featureAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eFeature);
                if (featureAnnotation == null || featureAnnotation.getDetails().isEmpty()) continue;
                return featureAnnotation.getSource();
            }
            for (EOperation eOperation : eClass.getEOperations()) {
                EAnnotation operationAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation);
                if (operationAnnotation == null || operationAnnotation.getDetails().isEmpty()) continue;
                return operationAnnotation.getSource();
            }
        }
        return null;
    }

    public static @Nullable String getExportDelegateURI(@NonNull Map<String, Object> options) {
        String exportDelegateURI = (String)options.get("http://www.eclipse.org/emf/2002/Ecore/OCL");
        return exportDelegateURI != null ? exportDelegateURI : (String)OCLinEcoreOptions.EXPORT_DELEGATION_URI.getPreferredValue();
    }

    public static boolean isBooleanInvariants(@NonNull Map<String, Object> options) {
        return Boolean.valueOf(String.valueOf(options.get(OPTION_BOOLEAN_INVARIANTS)));
    }

    public static boolean needsDelegates(@NonNull EPackage ePackage) {
        boolean needsDelegates = false;
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EAnnotation classifierAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier);
            if (classifierAnnotation != null && !classifierAnnotation.getDetails().isEmpty()) {
                needsDelegates = true;
                break;
            }
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
                EAnnotation featureAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eFeature);
                if (featureAnnotation == null || featureAnnotation.getDetails().isEmpty()) continue;
                needsDelegates = true;
                break;
            }
            if (needsDelegates) break;
            for (EOperation eOperation : eClass.getEOperations()) {
                EAnnotation operationAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation);
                if (operationAnnotation == null || operationAnnotation.getDetails().isEmpty()) continue;
                needsDelegates = true;
                break;
            }
            if (needsDelegates) break;
        }
        return needsDelegates;
    }

    public DelegateInstaller(@NonNull EnvironmentFactoryInternal environmentFactory, @Nullable Map<String, Object> options) {
        this.environmentFactory = environmentFactory;
        this.options = options != null ? options : new HashMap();
        this.exportDelegateURI = DelegateInstaller.getExportDelegateURI(this.options);
    }

    protected @NonNull EAnnotation createAnnotation(@NonNull EModelElement eModelElement) {
        EAnnotation oclAnnotation = this.removeDelegateAnnotations(eModelElement, this.exportDelegateURI);
        if (oclAnnotation == null) {
            oclAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            oclAnnotation.setSource(this.exportDelegateURI);
            eModelElement.getEAnnotations().add((Object)oclAnnotation);
        }
        return oclAnnotation;
    }

    public @Nullable EAnnotation createConstraintDelegate(@NonNull EModelElement eModelElement, @NonNull Constraint pivotConstraint, @Nullable URI ecoreURI) {
        LanguageExpression specification = pivotConstraint.getOwnedSpecification();
        if (specification == null) {
            return null;
        }
        String exprString = this.createExpression(specification, ecoreURI);
        if (exprString == null) {
            return null;
        }
        EAnnotation oclAnnotation = this.createAnnotation(eModelElement);
        String key = DelegateInstaller.getAnnotationKey(pivotConstraint);
        oclAnnotation.getDetails().put((Object)key, (Object)exprString);
        return oclAnnotation;
    }

    protected @Nullable String createExpression(@NonNull LanguageExpression specification, @Nullable URI ecoreURI) {
        OCLExpression bodyExpression2;
        String exprString = specification.getBody();
        if (exprString == null && specification instanceof ExpressionInOCL && (bodyExpression2 = ((ExpressionInOCL)specification).getOwnedBody()) != null) {
            exprString = this.createExpression(bodyExpression2, ecoreURI);
        }
        return exprString;
    }

    protected @Nullable String createExpression(@NonNull OCLExpression bodyExpression, @Nullable URI ecoreURI) {
        Namespace namespace = PivotUtil.getNamespace(bodyExpression);
        PrettyPrintOptions.Global options = PrettyPrinter.createOptions(namespace);
        options.setBaseURI(ecoreURI);
        return PrettyPrinter.print((Element)bodyExpression, options);
    }

    public @Nullable EAnnotation createOperationDelegate(@NonNull EOperation eOperation, @NonNull LanguageExpression bodyExpression, @Nullable URI ecoreURI) {
        String exprString = this.createExpression(bodyExpression, ecoreURI);
        if (exprString == null) {
            return null;
        }
        if (DelegateInstaller.isBooleanInvariants(this.options)) {
            exprString = "result = (" + exprString + ")";
        }
        EAnnotation oclAnnotation = this.createAnnotation((EModelElement)eOperation);
        oclAnnotation.getDetails().put((Object)"body", (Object)exprString);
        return oclAnnotation;
    }

    public @Nullable EAnnotation createPropertyDelegate(@NonNull EStructuralFeature eStructuralFeature, @NonNull LanguageExpression defaultExpression, @Nullable URI ecoreURI) {
        String exprString = this.createExpression(defaultExpression, ecoreURI);
        if (exprString == null) {
            return null;
        }
        EAnnotation oclAnnotation = this.createAnnotation((EModelElement)eStructuralFeature);
        oclAnnotation.getDetails().put((Object)"derivation", (Object)exprString);
        return oclAnnotation;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public @Nullable String getExportDelegateURI() {
        return this.exportDelegateURI;
    }

    public void installDelegates(@NonNull CompletePackage completePackage) {
        boolean hasDelegates = false;
        for (CompleteClass completeClass : completePackage.getOwnedCompleteClasses()) {
            if (!this.installDelegates(completeClass.getPrimaryClass())) continue;
            hasDelegates = true;
        }
        EPackage ePackage = completePackage.getEPackage();
        if (ePackage != null && hasDelegates) {
            this.installDelegates(ePackage);
        }
        for (CompletePackage nestedPackage : completePackage.getOwnedCompletePackages()) {
            if (nestedPackage == null) continue;
            this.installDelegates(nestedPackage);
        }
    }

    private boolean installDelegates(@NonNull Class pivotType) {
        boolean hasDelegates = false;
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        Type primaryType = metamodelManager.getPrimaryType(pivotType);
        EObject eTarget = primaryType.getESObject();
        if (eTarget instanceof EClassifier) {
            EStructuralFeature eFeature;
            EOperation eOperation;
            @NonNull EClassifier eClassifier = (EClassifier)eTarget;
            this.removeDelegateAnnotations((EModelElement)eClassifier, null);
            for (Constraint constraint : metamodelManager.getLocalInvariants(pivotType)) {
                if (constraint.isIsCallable()) {
                    EAnnotation oclAnnotation;
                    EOperation eContext = null;
                    @NonNull String name = PivotUtil.getName(constraint);
                    for (EOperation candidate : ((EClass)eClassifier).getEOperations()) {
                        if (!name.equals(candidate.getName()) || !EcoreUtil.isInvariant((EOperation)candidate)) continue;
                        eContext = candidate;
                        break;
                    }
                    if (eContext == null) {
                        @NonNull EOperation eOperation2 = AS2Ecore.createConstraintEOperation(constraint, name, null);
                        ((EClass)eClassifier).getEOperations().add((Object)eOperation2);
                        eContext = eOperation2;
                    }
                    if ((oclAnnotation = this.createConstraintDelegate((EModelElement)eContext, constraint, null)) == null) {
                        return false;
                    }
                    eContext.getEAnnotations().add((Object)oclAnnotation);
                    hasDelegates = true;
                    continue;
                }
                EAnnotation oclAnnotation = this.createConstraintDelegate((EModelElement)eClassifier, constraint, null);
                if (oclAnnotation == null) {
                    return false;
                }
                eClassifier.getEAnnotations().add((Object)oclAnnotation);
                hasDelegates = true;
            }
            for (Operation anOperation : metamodelManager.getMemberOperations(pivotType, false)) {
                eOperation = (EOperation)anOperation.getESObject();
                if (eOperation == null) continue;
                this.installDelegate(eOperation);
            }
            for (Operation anOperation : metamodelManager.getMemberOperations(pivotType, true)) {
                eOperation = (EOperation)anOperation.getESObject();
                if (eOperation == null) continue;
                this.installDelegate(eOperation);
            }
            for (Property aProperty : metamodelManager.getMemberProperties(pivotType, false)) {
                eFeature = (EStructuralFeature)aProperty.getESObject();
                if (eFeature == null) continue;
                this.installDelegate(eFeature);
            }
            for (Property aProperty : metamodelManager.getMemberProperties(pivotType, true)) {
                eFeature = (EStructuralFeature)aProperty.getESObject();
                if (eFeature == null) continue;
                this.installDelegate(eFeature);
            }
            for (EAnnotation eAnnotation : eClassifier.getEAnnotations()) {
                TreeIterator tit = eAnnotation.eAllContents();
                while (tit.hasNext()) {
                    EAnnotation nestedAnnotation;
                    EObject eObject = (EObject)tit.next();
                    if (!(eObject instanceof EAnnotation) || !"http://www.eclipse.org/uml2/1.1.0/GenModel".equals((nestedAnnotation = (EAnnotation)eObject).getSource())) continue;
                    nestedAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
                }
            }
            if (hasDelegates) {
                this.installDelegates(eClassifier, pivotType);
            }
        }
        return hasDelegates;
    }

    public void installDelegate(@NonNull EOperation eOperation) {
        EList eAnnotations = eOperation.getEAnnotations();
        EAnnotation oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
        if (oclAnnotation != null) {
            eAnnotations.remove(oclAnnotation);
            oclAnnotation.setSource(this.exportDelegateURI);
            eAnnotations.add(oclAnnotation);
        }
    }

    public void installDelegate(@NonNull EStructuralFeature eFeature) {
        EList eAnnotations = eFeature.getEAnnotations();
        EAnnotation oclAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
        if (oclAnnotation != null) {
            eAnnotations.remove(oclAnnotation);
            oclAnnotation.setSource(this.exportDelegateURI);
            eAnnotations.add(oclAnnotation);
        }
    }

    public void installDelegates(@NonNull EClassifier eClassifier, @NonNull Class pivotType) {
        UniqueList<@NonNull String> constraintNameSet = null;
        StringBuilder s = null;
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        for (Constraint pivotConstraint : metamodelManager.getLocalInvariants(pivotType)) {
            assert (pivotConstraint != null);
            String constraintName = DelegateInstaller.getAnnotationKey(pivotConstraint);
            if (pivotConstraint.isIsCallable()) continue;
            if (constraintNameSet == null) {
                constraintNameSet = new UniqueList<String>();
            }
            if (!constraintNameSet.add(constraintName)) continue;
            if (s == null) {
                s = new StringBuilder();
            } else {
                s.append(" ");
            }
            s.append(constraintName);
        }
        EAnnotation eAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (s != null) {
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
                eClassifier.getEAnnotations().add((Object)eAnnotation);
            }
            eAnnotation.getDetails().put((Object)"constraints", (Object)s.toString());
        } else {
            eClassifier.getEAnnotations().remove((Object)eAnnotation);
        }
    }

    public void installDelegates(@NonNull EPackage ePackage) {
        EAnnotation packageAnnotation = ClassUtil.getEAnnotation((EModelElement)ePackage, "http://www.eclipse.org/emf/2002/Ecore");
        EMap details = packageAnnotation.getDetails();
        details.put((Object)"invocationDelegates", (Object)this.exportDelegateURI);
        if (!Boolean.valueOf(String.valueOf(this.options.get(OPTION_OMIT_SETTING_DELEGATES))).booleanValue()) {
            details.put((Object)"settingDelegates", (Object)this.exportDelegateURI);
        }
        details.put((Object)"validationDelegates", (Object)this.exportDelegateURI);
    }

    protected @Nullable EAnnotation removeDelegateAnnotations(@NonNull EModelElement eModelElement, @Nullable String exportDelegateURI) {
        EAnnotation annotation4;
        EAnnotation annotation3;
        EAnnotation annotation2;
        EList eAnnotations = eModelElement.getEAnnotations();
        EAnnotation oclAnnotation = null;
        EAnnotation annotation1 = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
        if (annotation1 != null) {
            if ("http://www.eclipse.org/emf/2002/Ecore/OCL".equals(exportDelegateURI)) {
                oclAnnotation = annotation1;
            } else {
                eAnnotations.remove(annotation1);
            }
        }
        if ((annotation2 = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG")) != null) {
            if ("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG".equals(exportDelegateURI)) {
                oclAnnotation = annotation2;
            } else {
                eAnnotations.remove(annotation2);
            }
        }
        if ((annotation3 = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot")) != null) {
            if ("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot".equals(exportDelegateURI)) {
                oclAnnotation = annotation3;
            } else {
                eAnnotations.remove(annotation3);
            }
        }
        if ((annotation4 = eModelElement.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel")) != null) {
            eAnnotations.remove(annotation4);
        }
        return oclAnnotation;
    }
}

