/**
 * Copyright (c) 2009, 2019 Hatha Systems, and Mia-Software and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     Nikolai Mansourov (Hatha Systems) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - minor evolutions for version 1.1
 */
package org.eclipse.modisco.omg.kdm.code.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.modisco.omg.kdm.code.util.CodeAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class CodeItemProviderAdapterFactory extends CodeAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CodeItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.CodeModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CodeModelItemProvider codeModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.CodeModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCodeModelAdapter() {
		if (codeModelItemProvider == null) {
			codeModelItemProvider = new CodeModelItemProvider(this);
		}

		return codeModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ComputationalObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComputationalObjectItemProvider computationalObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ComputationalObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComputationalObjectAdapter() {
		if (computationalObjectItemProvider == null) {
			computationalObjectItemProvider = new ComputationalObjectItemProvider(this);
		}

		return computationalObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Datatype} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DatatypeItemProvider datatypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Datatype}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatatypeAdapter() {
		if (datatypeItemProvider == null) {
			datatypeItemProvider = new DatatypeItemProvider(this);
		}

		return datatypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Module} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModuleItemProvider moduleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Module}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModuleAdapter() {
		if (moduleItemProvider == null) {
			moduleItemProvider = new ModuleItemProvider(this);
		}

		return moduleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.CompilationUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompilationUnitItemProvider compilationUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.CompilationUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompilationUnitAdapter() {
		if (compilationUnitItemProvider == null) {
			compilationUnitItemProvider = new CompilationUnitItemProvider(this);
		}

		return compilationUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.SharedUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SharedUnitItemProvider sharedUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.SharedUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSharedUnitAdapter() {
		if (sharedUnitItemProvider == null) {
			sharedUnitItemProvider = new SharedUnitItemProvider(this);
		}

		return sharedUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.LanguageUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LanguageUnitItemProvider languageUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.LanguageUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLanguageUnitAdapter() {
		if (languageUnitItemProvider == null) {
			languageUnitItemProvider = new LanguageUnitItemProvider(this);
		}

		return languageUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.CodeAssembly} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CodeAssemblyItemProvider codeAssemblyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.CodeAssembly}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCodeAssemblyAdapter() {
		if (codeAssemblyItemProvider == null) {
			codeAssemblyItemProvider = new CodeAssemblyItemProvider(this);
		}

		return codeAssemblyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Package} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackageItemProvider packageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Package}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPackageAdapter() {
		if (packageItemProvider == null) {
			packageItemProvider = new PackageItemProvider(this);
		}

		return packageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ControlElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ControlElementItemProvider controlElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ControlElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createControlElementAdapter() {
		if (controlElementItemProvider == null) {
			controlElementItemProvider = new ControlElementItemProvider(this);
		}

		return controlElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.CallableUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CallableUnitItemProvider callableUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.CallableUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCallableUnitAdapter() {
		if (callableUnitItemProvider == null) {
			callableUnitItemProvider = new CallableUnitItemProvider(this);
		}

		return callableUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.MethodUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MethodUnitItemProvider methodUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.MethodUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMethodUnitAdapter() {
		if (methodUnitItemProvider == null) {
			methodUnitItemProvider = new MethodUnitItemProvider(this);
		}

		return methodUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.DataElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataElementItemProvider dataElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.DataElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataElementAdapter() {
		if (dataElementItemProvider == null) {
			dataElementItemProvider = new DataElementItemProvider(this);
		}

		return dataElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.StorableUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StorableUnitItemProvider storableUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.StorableUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStorableUnitAdapter() {
		if (storableUnitItemProvider == null) {
			storableUnitItemProvider = new StorableUnitItemProvider(this);
		}

		return storableUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ItemUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ItemUnitItemProvider itemUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ItemUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createItemUnitAdapter() {
		if (itemUnitItemProvider == null) {
			itemUnitItemProvider = new ItemUnitItemProvider(this);
		}

		return itemUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.IndexUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IndexUnitItemProvider indexUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.IndexUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIndexUnitAdapter() {
		if (indexUnitItemProvider == null) {
			indexUnitItemProvider = new IndexUnitItemProvider(this);
		}

		return indexUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.MemberUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemberUnitItemProvider memberUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.MemberUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemberUnitAdapter() {
		if (memberUnitItemProvider == null) {
			memberUnitItemProvider = new MemberUnitItemProvider(this);
		}

		return memberUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ParameterUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterUnitItemProvider parameterUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ParameterUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterUnitAdapter() {
		if (parameterUnitItemProvider == null) {
			parameterUnitItemProvider = new ParameterUnitItemProvider(this);
		}

		return parameterUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Value} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValueItemProvider valueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Value}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createValueAdapter() {
		if (valueItemProvider == null) {
			valueItemProvider = new ValueItemProvider(this);
		}

		return valueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ValueList} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValueListItemProvider valueListItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ValueList}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createValueListAdapter() {
		if (valueListItemProvider == null) {
			valueListItemProvider = new ValueListItemProvider(this);
		}

		return valueListItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.PrimitiveType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeItemProvider primitiveTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.PrimitiveType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeAdapter() {
		if (primitiveTypeItemProvider == null) {
			primitiveTypeItemProvider = new PrimitiveTypeItemProvider(this);
		}

		return primitiveTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.BooleanType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanTypeItemProvider booleanTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.BooleanType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanTypeAdapter() {
		if (booleanTypeItemProvider == null) {
			booleanTypeItemProvider = new BooleanTypeItemProvider(this);
		}

		return booleanTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.CharType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CharTypeItemProvider charTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.CharType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCharTypeAdapter() {
		if (charTypeItemProvider == null) {
			charTypeItemProvider = new CharTypeItemProvider(this);
		}

		return charTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.OrdinalType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrdinalTypeItemProvider ordinalTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.OrdinalType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOrdinalTypeAdapter() {
		if (ordinalTypeItemProvider == null) {
			ordinalTypeItemProvider = new OrdinalTypeItemProvider(this);
		}

		return ordinalTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.DateType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DateTypeItemProvider dateTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.DateType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDateTypeAdapter() {
		if (dateTypeItemProvider == null) {
			dateTypeItemProvider = new DateTypeItemProvider(this);
		}

		return dateTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.TimeType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeTypeItemProvider timeTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.TimeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeTypeAdapter() {
		if (timeTypeItemProvider == null) {
			timeTypeItemProvider = new TimeTypeItemProvider(this);
		}

		return timeTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.IntegerType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntegerTypeItemProvider integerTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.IntegerType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntegerTypeAdapter() {
		if (integerTypeItemProvider == null) {
			integerTypeItemProvider = new IntegerTypeItemProvider(this);
		}

		return integerTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.DecimalType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DecimalTypeItemProvider decimalTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.DecimalType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDecimalTypeAdapter() {
		if (decimalTypeItemProvider == null) {
			decimalTypeItemProvider = new DecimalTypeItemProvider(this);
		}

		return decimalTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ScaledType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ScaledTypeItemProvider scaledTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ScaledType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createScaledTypeAdapter() {
		if (scaledTypeItemProvider == null) {
			scaledTypeItemProvider = new ScaledTypeItemProvider(this);
		}

		return scaledTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.FloatType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FloatTypeItemProvider floatTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.FloatType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFloatTypeAdapter() {
		if (floatTypeItemProvider == null) {
			floatTypeItemProvider = new FloatTypeItemProvider(this);
		}

		return floatTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.VoidType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VoidTypeItemProvider voidTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.VoidType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVoidTypeAdapter() {
		if (voidTypeItemProvider == null) {
			voidTypeItemProvider = new VoidTypeItemProvider(this);
		}

		return voidTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.StringType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringTypeItemProvider stringTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.StringType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringTypeAdapter() {
		if (stringTypeItemProvider == null) {
			stringTypeItemProvider = new StringTypeItemProvider(this);
		}

		return stringTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.BitType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BitTypeItemProvider bitTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.BitType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBitTypeAdapter() {
		if (bitTypeItemProvider == null) {
			bitTypeItemProvider = new BitTypeItemProvider(this);
		}

		return bitTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.BitstringType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BitstringTypeItemProvider bitstringTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.BitstringType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBitstringTypeAdapter() {
		if (bitstringTypeItemProvider == null) {
			bitstringTypeItemProvider = new BitstringTypeItemProvider(this);
		}

		return bitstringTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.OctetType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OctetTypeItemProvider octetTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.OctetType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOctetTypeAdapter() {
		if (octetTypeItemProvider == null) {
			octetTypeItemProvider = new OctetTypeItemProvider(this);
		}

		return octetTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.OctetstringType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OctetstringTypeItemProvider octetstringTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.OctetstringType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOctetstringTypeAdapter() {
		if (octetstringTypeItemProvider == null) {
			octetstringTypeItemProvider = new OctetstringTypeItemProvider(this);
		}

		return octetstringTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.EnumeratedType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnumeratedTypeItemProvider enumeratedTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.EnumeratedType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnumeratedTypeAdapter() {
		if (enumeratedTypeItemProvider == null) {
			enumeratedTypeItemProvider = new EnumeratedTypeItemProvider(this);
		}

		return enumeratedTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.CompositeType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompositeTypeItemProvider compositeTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.CompositeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompositeTypeAdapter() {
		if (compositeTypeItemProvider == null) {
			compositeTypeItemProvider = new CompositeTypeItemProvider(this);
		}

		return compositeTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ChoiceType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChoiceTypeItemProvider choiceTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ChoiceType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChoiceTypeAdapter() {
		if (choiceTypeItemProvider == null) {
			choiceTypeItemProvider = new ChoiceTypeItemProvider(this);
		}

		return choiceTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.RecordType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RecordTypeItemProvider recordTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.RecordType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRecordTypeAdapter() {
		if (recordTypeItemProvider == null) {
			recordTypeItemProvider = new RecordTypeItemProvider(this);
		}

		return recordTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.DerivedType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DerivedTypeItemProvider derivedTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.DerivedType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDerivedTypeAdapter() {
		if (derivedTypeItemProvider == null) {
			derivedTypeItemProvider = new DerivedTypeItemProvider(this);
		}

		return derivedTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ArrayType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayTypeItemProvider arrayTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ArrayType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayTypeAdapter() {
		if (arrayTypeItemProvider == null) {
			arrayTypeItemProvider = new ArrayTypeItemProvider(this);
		}

		return arrayTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.PointerType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PointerTypeItemProvider pointerTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.PointerType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPointerTypeAdapter() {
		if (pointerTypeItemProvider == null) {
			pointerTypeItemProvider = new PointerTypeItemProvider(this);
		}

		return pointerTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.RangeType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RangeTypeItemProvider rangeTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.RangeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRangeTypeAdapter() {
		if (rangeTypeItemProvider == null) {
			rangeTypeItemProvider = new RangeTypeItemProvider(this);
		}

		return rangeTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.BagType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BagTypeItemProvider bagTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.BagType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBagTypeAdapter() {
		if (bagTypeItemProvider == null) {
			bagTypeItemProvider = new BagTypeItemProvider(this);
		}

		return bagTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.SetType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SetTypeItemProvider setTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.SetType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSetTypeAdapter() {
		if (setTypeItemProvider == null) {
			setTypeItemProvider = new SetTypeItemProvider(this);
		}

		return setTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.SequenceType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SequenceTypeItemProvider sequenceTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.SequenceType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSequenceTypeAdapter() {
		if (sequenceTypeItemProvider == null) {
			sequenceTypeItemProvider = new SequenceTypeItemProvider(this);
		}

		return sequenceTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Signature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignatureItemProvider signatureItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Signature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignatureAdapter() {
		if (signatureItemProvider == null) {
			signatureItemProvider = new SignatureItemProvider(this);
		}

		return signatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.TypeUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeUnitItemProvider typeUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.TypeUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeUnitAdapter() {
		if (typeUnitItemProvider == null) {
			typeUnitItemProvider = new TypeUnitItemProvider(this);
		}

		return typeUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.SynonymUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SynonymUnitItemProvider synonymUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.SynonymUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSynonymUnitAdapter() {
		if (synonymUnitItemProvider == null) {
			synonymUnitItemProvider = new SynonymUnitItemProvider(this);
		}

		return synonymUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ClassUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassUnitItemProvider classUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ClassUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassUnitAdapter() {
		if (classUnitItemProvider == null) {
			classUnitItemProvider = new ClassUnitItemProvider(this);
		}

		return classUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.InterfaceUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfaceUnitItemProvider interfaceUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.InterfaceUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterfaceUnitAdapter() {
		if (interfaceUnitItemProvider == null) {
			interfaceUnitItemProvider = new InterfaceUnitItemProvider(this);
		}

		return interfaceUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.TemplateUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateUnitItemProvider templateUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.TemplateUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTemplateUnitAdapter() {
		if (templateUnitItemProvider == null) {
			templateUnitItemProvider = new TemplateUnitItemProvider(this);
		}

		return templateUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.TemplateParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateParameterItemProvider templateParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.TemplateParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTemplateParameterAdapter() {
		if (templateParameterItemProvider == null) {
			templateParameterItemProvider = new TemplateParameterItemProvider(this);
		}

		return templateParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.TemplateType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateTypeItemProvider templateTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.TemplateType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTemplateTypeAdapter() {
		if (templateTypeItemProvider == null) {
			templateTypeItemProvider = new TemplateTypeItemProvider(this);
		}

		return templateTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.InstanceOf} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstanceOfItemProvider instanceOfItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.InstanceOf}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstanceOfAdapter() {
		if (instanceOfItemProvider == null) {
			instanceOfItemProvider = new InstanceOfItemProvider(this);
		}

		return instanceOfItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ParameterTo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterToItemProvider parameterToItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ParameterTo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterToAdapter() {
		if (parameterToItemProvider == null) {
			parameterToItemProvider = new ParameterToItemProvider(this);
		}

		return parameterToItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Implements} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImplementsItemProvider implementsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Implements}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImplementsAdapter() {
		if (implementsItemProvider == null) {
			implementsItemProvider = new ImplementsItemProvider(this);
		}

		return implementsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ImplementationOf} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImplementationOfItemProvider implementationOfItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ImplementationOf}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImplementationOfAdapter() {
		if (implementationOfItemProvider == null) {
			implementationOfItemProvider = new ImplementationOfItemProvider(this);
		}

		return implementationOfItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.HasType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HasTypeItemProvider hasTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.HasType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHasTypeAdapter() {
		if (hasTypeItemProvider == null) {
			hasTypeItemProvider = new HasTypeItemProvider(this);
		}

		return hasTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.HasValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HasValueItemProvider hasValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.HasValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHasValueAdapter() {
		if (hasValueItemProvider == null) {
			hasValueItemProvider = new HasValueItemProvider(this);
		}

		return hasValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Extends} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExtendsItemProvider extendsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Extends}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExtendsAdapter() {
		if (extendsItemProvider == null) {
			extendsItemProvider = new ExtendsItemProvider(this);
		}

		return extendsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.PreprocessorDirective} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PreprocessorDirectiveItemProvider preprocessorDirectiveItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.PreprocessorDirective}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPreprocessorDirectiveAdapter() {
		if (preprocessorDirectiveItemProvider == null) {
			preprocessorDirectiveItemProvider = new PreprocessorDirectiveItemProvider(this);
		}

		return preprocessorDirectiveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.MacroUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MacroUnitItemProvider macroUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.MacroUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMacroUnitAdapter() {
		if (macroUnitItemProvider == null) {
			macroUnitItemProvider = new MacroUnitItemProvider(this);
		}

		return macroUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.MacroDirective} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MacroDirectiveItemProvider macroDirectiveItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.MacroDirective}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMacroDirectiveAdapter() {
		if (macroDirectiveItemProvider == null) {
			macroDirectiveItemProvider = new MacroDirectiveItemProvider(this);
		}

		return macroDirectiveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.IncludeDirective} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IncludeDirectiveItemProvider includeDirectiveItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.IncludeDirective}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIncludeDirectiveAdapter() {
		if (includeDirectiveItemProvider == null) {
			includeDirectiveItemProvider = new IncludeDirectiveItemProvider(this);
		}

		return includeDirectiveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.ConditionalDirective} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionalDirectiveItemProvider conditionalDirectiveItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.ConditionalDirective}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionalDirectiveAdapter() {
		if (conditionalDirectiveItemProvider == null) {
			conditionalDirectiveItemProvider = new ConditionalDirectiveItemProvider(this);
		}

		return conditionalDirectiveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Expands} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpandsItemProvider expandsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Expands}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpandsAdapter() {
		if (expandsItemProvider == null) {
			expandsItemProvider = new ExpandsItemProvider(this);
		}

		return expandsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.GeneratedFrom} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GeneratedFromItemProvider generatedFromItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.GeneratedFrom}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeneratedFromAdapter() {
		if (generatedFromItemProvider == null) {
			generatedFromItemProvider = new GeneratedFromItemProvider(this);
		}

		return generatedFromItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Includes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IncludesItemProvider includesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Includes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIncludesAdapter() {
		if (includesItemProvider == null) {
			includesItemProvider = new IncludesItemProvider(this);
		}

		return includesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.VariantTo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariantToItemProvider variantToItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.VariantTo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariantToAdapter() {
		if (variantToItemProvider == null) {
			variantToItemProvider = new VariantToItemProvider(this);
		}

		return variantToItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Redefines} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RedefinesItemProvider redefinesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Redefines}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRedefinesAdapter() {
		if (redefinesItemProvider == null) {
			redefinesItemProvider = new RedefinesItemProvider(this);
		}

		return redefinesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.CommentUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentUnitItemProvider commentUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.CommentUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommentUnitAdapter() {
		if (commentUnitItemProvider == null) {
			commentUnitItemProvider = new CommentUnitItemProvider(this);
		}

		return commentUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Namespace} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NamespaceItemProvider namespaceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Namespace}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNamespaceAdapter() {
		if (namespaceItemProvider == null) {
			namespaceItemProvider = new NamespaceItemProvider(this);
		}

		return namespaceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.VisibleIn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VisibleInItemProvider visibleInItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.VisibleIn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVisibleInAdapter() {
		if (visibleInItemProvider == null) {
			visibleInItemProvider = new VisibleInItemProvider(this);
		}

		return visibleInItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.Imports} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImportsItemProvider importsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.Imports}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImportsAdapter() {
		if (importsItemProvider == null) {
			importsItemProvider = new ImportsItemProvider(this);
		}

		return importsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.CodeElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CodeElementItemProvider codeElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.CodeElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCodeElementAdapter() {
		if (codeElementItemProvider == null) {
			codeElementItemProvider = new CodeElementItemProvider(this);
		}

		return codeElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.code.CodeRelationship} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CodeRelationshipItemProvider codeRelationshipItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.code.CodeRelationship}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCodeRelationshipAdapter() {
		if (codeRelationshipItemProvider == null) {
			codeRelationshipItemProvider = new CodeRelationshipItemProvider(this);
		}

		return codeRelationshipItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (codeModelItemProvider != null) codeModelItemProvider.dispose();
		if (computationalObjectItemProvider != null) computationalObjectItemProvider.dispose();
		if (datatypeItemProvider != null) datatypeItemProvider.dispose();
		if (moduleItemProvider != null) moduleItemProvider.dispose();
		if (compilationUnitItemProvider != null) compilationUnitItemProvider.dispose();
		if (sharedUnitItemProvider != null) sharedUnitItemProvider.dispose();
		if (languageUnitItemProvider != null) languageUnitItemProvider.dispose();
		if (codeAssemblyItemProvider != null) codeAssemblyItemProvider.dispose();
		if (packageItemProvider != null) packageItemProvider.dispose();
		if (controlElementItemProvider != null) controlElementItemProvider.dispose();
		if (callableUnitItemProvider != null) callableUnitItemProvider.dispose();
		if (methodUnitItemProvider != null) methodUnitItemProvider.dispose();
		if (dataElementItemProvider != null) dataElementItemProvider.dispose();
		if (storableUnitItemProvider != null) storableUnitItemProvider.dispose();
		if (itemUnitItemProvider != null) itemUnitItemProvider.dispose();
		if (indexUnitItemProvider != null) indexUnitItemProvider.dispose();
		if (memberUnitItemProvider != null) memberUnitItemProvider.dispose();
		if (parameterUnitItemProvider != null) parameterUnitItemProvider.dispose();
		if (valueItemProvider != null) valueItemProvider.dispose();
		if (valueListItemProvider != null) valueListItemProvider.dispose();
		if (primitiveTypeItemProvider != null) primitiveTypeItemProvider.dispose();
		if (booleanTypeItemProvider != null) booleanTypeItemProvider.dispose();
		if (charTypeItemProvider != null) charTypeItemProvider.dispose();
		if (ordinalTypeItemProvider != null) ordinalTypeItemProvider.dispose();
		if (dateTypeItemProvider != null) dateTypeItemProvider.dispose();
		if (timeTypeItemProvider != null) timeTypeItemProvider.dispose();
		if (integerTypeItemProvider != null) integerTypeItemProvider.dispose();
		if (decimalTypeItemProvider != null) decimalTypeItemProvider.dispose();
		if (scaledTypeItemProvider != null) scaledTypeItemProvider.dispose();
		if (floatTypeItemProvider != null) floatTypeItemProvider.dispose();
		if (voidTypeItemProvider != null) voidTypeItemProvider.dispose();
		if (stringTypeItemProvider != null) stringTypeItemProvider.dispose();
		if (bitTypeItemProvider != null) bitTypeItemProvider.dispose();
		if (bitstringTypeItemProvider != null) bitstringTypeItemProvider.dispose();
		if (octetTypeItemProvider != null) octetTypeItemProvider.dispose();
		if (octetstringTypeItemProvider != null) octetstringTypeItemProvider.dispose();
		if (enumeratedTypeItemProvider != null) enumeratedTypeItemProvider.dispose();
		if (compositeTypeItemProvider != null) compositeTypeItemProvider.dispose();
		if (choiceTypeItemProvider != null) choiceTypeItemProvider.dispose();
		if (recordTypeItemProvider != null) recordTypeItemProvider.dispose();
		if (derivedTypeItemProvider != null) derivedTypeItemProvider.dispose();
		if (arrayTypeItemProvider != null) arrayTypeItemProvider.dispose();
		if (pointerTypeItemProvider != null) pointerTypeItemProvider.dispose();
		if (rangeTypeItemProvider != null) rangeTypeItemProvider.dispose();
		if (bagTypeItemProvider != null) bagTypeItemProvider.dispose();
		if (setTypeItemProvider != null) setTypeItemProvider.dispose();
		if (sequenceTypeItemProvider != null) sequenceTypeItemProvider.dispose();
		if (signatureItemProvider != null) signatureItemProvider.dispose();
		if (typeUnitItemProvider != null) typeUnitItemProvider.dispose();
		if (synonymUnitItemProvider != null) synonymUnitItemProvider.dispose();
		if (classUnitItemProvider != null) classUnitItemProvider.dispose();
		if (interfaceUnitItemProvider != null) interfaceUnitItemProvider.dispose();
		if (templateUnitItemProvider != null) templateUnitItemProvider.dispose();
		if (templateParameterItemProvider != null) templateParameterItemProvider.dispose();
		if (templateTypeItemProvider != null) templateTypeItemProvider.dispose();
		if (instanceOfItemProvider != null) instanceOfItemProvider.dispose();
		if (parameterToItemProvider != null) parameterToItemProvider.dispose();
		if (implementsItemProvider != null) implementsItemProvider.dispose();
		if (implementationOfItemProvider != null) implementationOfItemProvider.dispose();
		if (hasTypeItemProvider != null) hasTypeItemProvider.dispose();
		if (hasValueItemProvider != null) hasValueItemProvider.dispose();
		if (extendsItemProvider != null) extendsItemProvider.dispose();
		if (preprocessorDirectiveItemProvider != null) preprocessorDirectiveItemProvider.dispose();
		if (macroUnitItemProvider != null) macroUnitItemProvider.dispose();
		if (macroDirectiveItemProvider != null) macroDirectiveItemProvider.dispose();
		if (includeDirectiveItemProvider != null) includeDirectiveItemProvider.dispose();
		if (conditionalDirectiveItemProvider != null) conditionalDirectiveItemProvider.dispose();
		if (expandsItemProvider != null) expandsItemProvider.dispose();
		if (generatedFromItemProvider != null) generatedFromItemProvider.dispose();
		if (includesItemProvider != null) includesItemProvider.dispose();
		if (variantToItemProvider != null) variantToItemProvider.dispose();
		if (redefinesItemProvider != null) redefinesItemProvider.dispose();
		if (commentUnitItemProvider != null) commentUnitItemProvider.dispose();
		if (namespaceItemProvider != null) namespaceItemProvider.dispose();
		if (visibleInItemProvider != null) visibleInItemProvider.dispose();
		if (importsItemProvider != null) importsItemProvider.dispose();
		if (codeElementItemProvider != null) codeElementItemProvider.dispose();
		if (codeRelationshipItemProvider != null) codeRelationshipItemProvider.dispose();
	}

}
