/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editors.table;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.browser.core.ModelElementItemEx;
import org.eclipse.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.modisco.infra.browser.editors.table.ColumnDescription;
import org.eclipse.modisco.infra.browser.editors.table.TableElement;
import org.eclipse.modisco.infra.browser.editors.table.TableElementWithContext;
import org.eclipse.modisco.infra.common.core.internal.utils.StringUtils;
import org.eclipse.modisco.infra.facet.FacetAttribute;
import org.eclipse.modisco.infra.facet.FacetReference;
import org.eclipse.modisco.infra.facet.core.FacetContext;
import org.eclipse.swt.graphics.Image;

public class TableEditorLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final BrowserConfiguration browserConfiguration;
    private final List<ColumnDescription> columns;

    public TableEditorLabelProvider(List<ColumnDescription> columns, BrowserConfiguration browserConfiguration) {
        this.columns = columns;
        this.browserConfiguration = browserConfiguration;
    }

    public String getTextFor(Object element) {
        if (element == null) {
            return "null";
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return new ModelElementItemEx(eObject, null, this.browserConfiguration).getText();
        }
        return element.toString();
    }

    public Image getImageFor(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return new ModelElementItemEx(eObject, null, this.browserConfiguration).getImage();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex >= this.columns.size()) return null;
        ColumnDescription columnDescription = this.columns.get(columnIndex);
        TableElement tableElement = (TableElement)element;
        switch (columnDescription.getType()) {
            case DEFAULT_LABEL: {
                return this.getImageFor(tableElement.getElement());
            }
            case REFERENCE: {
                Object refValue;
                EReference reference = columnDescription.getReference();
                EObject eObject = (EObject)tableElement.getElement();
                if (reference instanceof FacetReference) {
                    try {
                        FacetContext facetContext = this.browserConfiguration.getAppearanceConfiguration().getFacetContext();
                        if (!facetContext.getReferences(eObject).contains((Object)reference)) return null;
                        refValue = facetContext.get(eObject, (EStructuralFeature)reference);
                    }
                    catch (Exception e) {
                        MoDiscoBrowserPlugin.logException(e);
                        return null;
                    }
                } else {
                    if (!eObject.eClass().getEAllReferences().contains((Object)reference)) {
                        return null;
                    }
                    refValue = eObject.eGet((EStructuralFeature)reference);
                }
                if (reference.isMany()) {
                    EList list = (EList)refValue;
                    if (list.size() != 1) return null;
                    return this.getImageFor(list.get(0));
                }
                if (refValue == null) return null;
                return this.getImageFor(refValue);
            }
            case ECONTAINER: {
                return this.getImageFor(((EObject)tableElement.getElement()).eContainer());
            }
            case CONTEXT: {
                return this.getContextColumnImage(tableElement);
            }
            default: {
                return null;
            }
        }
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex >= this.columns.size()) {
            return Messages.TableEditorLabelProvider_indexOutOfBounds;
        }
        TableElement tableElement = (TableElement)element;
        ColumnDescription columnDescription = this.columns.get(columnIndex);
        switch (columnDescription.getType()) {
            case DEFAULT_LABEL: {
                return this.getTextFor(tableElement.getElement());
            }
            case METACLASS_NAME: {
                return this.getMetaclassColumnText(tableElement.getElement());
            }
            case CONTEXT: {
                return this.getContextColumnText(tableElement);
            }
            case ATTRIBUTE: {
                return this.getAttributeColumnText(tableElement.getElement(), columnDescription);
            }
            case REFERENCE: {
                return this.getReferenceColumnText(tableElement.getElement(), columnDescription);
            }
            case ECONTAINER: {
                return this.getTextFor(((EObject)tableElement.getElement()).eContainer());
            }
        }
        return Messages.TableEditorLabelProvider_unexpectedColumnType;
    }

    private String getMetaclassColumnText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            EClass eClass = eObject.eClass();
            if (eClass == null) {
                return Messages.TableEditorLabelProvider_none;
            }
            return eClass.getName();
        }
        return element.getClass().getSimpleName();
    }

    private String getContextColumnText(TableElement tableElement) {
        if (tableElement instanceof TableElementWithContext) {
            TableElementWithContext tableElementWithContext = (TableElementWithContext)tableElement;
            EObject context = tableElementWithContext.getContext();
            return this.getTextFor(context);
        }
        return Messages.TableEditorLabelProvider_nullContext;
    }

    private Image getContextColumnImage(TableElement tableElement) {
        if (tableElement instanceof TableElementWithContext) {
            TableElementWithContext tableElementWithContext = (TableElementWithContext)tableElement;
            EObject context = tableElementWithContext.getContext();
            return this.getImageFor(context);
        }
        return null;
    }

    private String getAttributeColumnText(Object element, ColumnDescription columnDescription) {
        Object attrValue;
        EObject eObject = (EObject)element;
        EAttribute attribute = columnDescription.getAttribute();
        if (attribute instanceof FacetAttribute) {
            try {
                FacetContext facetContext = this.browserConfiguration.getAppearanceConfiguration().getFacetContext();
                if (!facetContext.getAttributes(eObject).contains((Object)attribute)) {
                    return Messages.TableEditorLabelProvider_NA;
                }
                attrValue = facetContext.get(eObject, (EStructuralFeature)attribute);
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
                return Messages.TableEditorLabelProvider_error;
            }
        } else {
            if (!eObject.eClass().getEAllAttributes().contains((Object)attribute)) {
                return Messages.TableEditorLabelProvider_NA;
            }
            attrValue = eObject.eGet((EStructuralFeature)attribute);
        }
        if (attrValue == null) {
            return "null";
        }
        return StringUtils.truncateBeforeNewline((String)this.getTextFor(attrValue));
    }

    private String getReferenceColumnText(Object element, ColumnDescription columnDescription) {
        Object refValue;
        EObject eObject = (EObject)element;
        EReference reference = columnDescription.getReference();
        if (reference instanceof FacetReference) {
            try {
                FacetContext facetContext = this.browserConfiguration.getAppearanceConfiguration().getFacetContext();
                if (!facetContext.getReferences(eObject).contains((Object)reference)) {
                    return Messages.TableEditorLabelProvider_NA;
                }
                refValue = facetContext.get(eObject, (EStructuralFeature)reference);
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
                return Messages.TableEditorLabelProvider_error;
            }
        } else {
            if (!eObject.eClass().getEAllReferences().contains((Object)reference)) {
                return Messages.TableEditorLabelProvider_NA;
            }
            refValue = eObject.eGet((EStructuralFeature)reference);
        }
        if (refValue == null) {
            return "null";
        }
        if (reference.isMany()) {
            EList list = (EList)refValue;
            if (list.size() == 1) {
                return this.getTextFor(list.get(0));
            }
            return "(" + list.size() + ")";
        }
        return this.getTextFor(refValue);
    }
}

