/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;

public interface ITransformationMaker {
    public QvtTransformation makeTransformation(URI var1) throws MdaException;

    public void cleanup() throws MdaException;

    public static class CachedTransformationMaker
    implements ITransformationMaker {
        private Map<URI, QvtTransformation> transformationsMap = new HashMap<URI, QvtTransformation>();

        @Override
        public QvtTransformation makeTransformation(URI uri) throws MdaException {
            QvtTransformation transformation = this.transformationsMap.get(uri);
            if (transformation == null) {
                QvtModule qvtModule = TransformationUtil.getQvtModule(uri);
                transformation = new QvtInterpretedTransformation(qvtModule);
                this.transformationsMap.put(uri, transformation);
            }
            return transformation;
        }

        @Override
        public void cleanup() throws MdaException {
            for (QvtTransformation transformation : this.transformationsMap.values()) {
                transformation.cleanup();
            }
            this.transformationsMap.clear();
        }
    }
}

