/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EclipseMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfStandaloneMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.Messages;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.osgi.util.NLS;

public class MetamodelRegistry {
    public static final String MM_POINT_ID = "metamodelProvider";
    private static final MetamodelRegistry ourInstance = new MetamodelRegistry();
    private final IMetamodelProvider myMetamodelProvider;

    public static boolean isMetamodelFileName(String fileName) {
        return fileName.endsWith(".ecore") || fileName.endsWith(".xcore") || fileName.endsWith(".emof") || fileName.endsWith(".oclinecore");
    }

    private MetamodelRegistry() {
        this(MetamodelRegistry.getDefaultMetamodelProvider());
    }

    public MetamodelRegistry(EPackage.Registry packageRegistry) {
        this(MetamodelRegistry.getDefaultMetamodelProvider(packageRegistry));
    }

    public MetamodelRegistry(IMetamodelProvider metamodelProvider) {
        this.myMetamodelProvider = metamodelProvider;
    }

    public EPackage.Registry toEPackageRegistry() {
        return this.myMetamodelProvider.getPackageRegistry();
    }

    public static IMetamodelProvider getDefaultMetamodelProvider() {
        return MetamodelRegistry.getDefaultMetamodelProvider(EPackage.Registry.INSTANCE);
    }

    public static IMetamodelProvider getDefaultMetamodelProvider(EPackage.Registry packageRegistry) {
        return MetamodelRegistry.getDefaultMetamodelProvider(new EmfStandaloneMetamodelProvider(packageRegistry));
    }

    public static IMetamodelProvider getDefaultMetamodelProvider(IMetamodelProvider base) {
        return EMFPlugin.IS_ECLIPSE_RUNNING ? Eclipse.getMetamodelProvider(base) : base;
    }

    public static MetamodelRegistry getInstance() {
        return ourInstance;
    }

    public String[] getMetamodelIds() {
        IMetamodelDesc[] metamodels = this.myMetamodelProvider.getMetamodels();
        LinkedHashSet<String> ids = new LinkedHashSet<String>(metamodels.length);
        IMetamodelDesc[] iMetamodelDescArray = metamodels;
        int n = metamodels.length;
        int n2 = 0;
        while (n2 < n) {
            IMetamodelDesc desc = iMetamodelDescArray[n2];
            ids.add(desc.getId());
            ++n2;
        }
        return ids.toArray(new String[ids.size()]);
    }

    public static EPackage tryLookupEmptyRootPackage(String nsURI, EPackage.Registry registry) {
        URI rootURI = URI.createURI((String)nsURI);
        if (rootURI.segmentCount() == 0) {
            return null;
        }
        String base = rootURI.segment(0);
        String commonBaseURI = rootURI.trimSegments(rootURI.segmentCount()).appendSegment(base).toString().toLowerCase();
        LinkedList<String> candidates = new LinkedList<String>();
        for (String nextURI : registry.keySet()) {
            if (!nextURI.toLowerCase().startsWith(commonBaseURI)) continue;
            candidates.add(nextURI);
        }
        for (String nextNsURI : candidates) {
            EPackage pack = null;
            try {
                pack = registry.getEPackage(nextNsURI);
            }
            catch (Throwable t) {
                EmfUtilPlugin.log(t);
            }
            if (pack == null || !nsURI.equals((pack = EmfUtil.getRootPackage(pack)).getNsURI())) continue;
            return pack;
        }
        return null;
    }

    public IMetamodelDesc getMetamodelDesc(String id) throws EmfException {
        IMetamodelDesc desc = this.myMetamodelProvider.getMetamodel(id);
        if (desc == null && id != null) {
            IMetamodelDesc[] iMetamodelDescArray = this.myMetamodelProvider.getMetamodels();
            int n = iMetamodelDescArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMetamodelDesc d = iMetamodelDescArray[n2];
                EPackage pack = d.getModel();
                if (pack != null) {
                    if (id.equals(pack.getNsURI())) {
                        desc = d;
                        break;
                    }
                    if (id.equals((pack = EmfUtil.getRootPackage(pack)).getNsURI())) {
                        desc = new EmfMetamodelDesc(pack, pack.getNsURI());
                        break;
                    }
                }
                ++n2;
            }
        }
        if (desc == null) {
            throw new EmfException(NLS.bind((String)Messages.MetamodelRegistry_0, (Object)id, (Object)this.myMetamodelProvider.getMetamodels()));
        }
        return desc;
    }

    public static List<EPackage> resolveMetamodels(EPackage.Registry registry, List<String> packageName) {
        UniqueEList metamodels = new UniqueEList(MetamodelRegistry.findPackages(registry, packageName));
        if (metamodels.isEmpty()) {
            metamodels.addAll(MetamodelRegistry.resolveUrilessMetamodels(registry, packageName));
        }
        return metamodels;
    }

    private static List<EPackage> resolveUrilessMetamodels(EPackage.Registry registry, List<String> packageName) {
        UniqueEList metamodels = new UniqueEList(1);
        for (EPackage globalPack : MetamodelRegistry.findPackages(EPackage.Registry.INSTANCE, packageName)) {
            EPackage rootPack = EmfUtil.getRootPackage(globalPack);
            EPackage registeredPack = null;
            try {
                registeredPack = registry.getEPackage(rootPack.getNsURI());
            }
            catch (Throwable t) {
                EmfUtilPlugin.log(t);
            }
            if (registeredPack != rootPack) continue;
            metamodels.add(globalPack);
        }
        return metamodels;
    }

    private static List<EPackage> findPackages(EPackage.Registry registry, List<String> packageName) {
        UniqueEList metamodels = new UniqueEList(1);
        ArrayList keys = new ArrayList(registry.keySet());
        for (String nsURI : keys) {
            EPackage lookupPackage;
            EPackage pack = null;
            try {
                pack = registry.getEPackage(nsURI);
            }
            catch (Throwable t) {
                EmfUtilPlugin.log(t);
            }
            if (pack == null || pack.getESuperPackage() != null || (lookupPackage = MetamodelRegistry.lookupPackage(pack, packageName)) == null) continue;
            metamodels.add(lookupPackage);
        }
        return metamodels;
    }

    public static EPackage lookupPackage(EPackage rootPackage, List<String> path) {
        EPackageRegistryImpl registry = new EPackageRegistryImpl();
        registry.put((Object)rootPackage.getNsURI(), (Object)rootPackage);
        return EcoreEnvironment.findPackage(path, (EPackage.Registry)registry);
    }

    private static class Eclipse {
        private Eclipse() {
        }

        static IMetamodelProvider getMetamodelProvider(IMetamodelProvider base) {
            IConfigurationElement[] configElements;
            if (base == null) {
                throw new IllegalArgumentException();
            }
            IMetamodelProvider metamodelProvider = base;
            IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EmfUtilPlugin.getDefault().getBundle().getSymbolicName(), MetamodelRegistry.MM_POINT_ID);
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                EclipseMetamodelProvider provider = EclipseMetamodelProvider.Factory.create(configElement, metamodelProvider);
                if (provider != null) {
                    metamodelProvider = provider;
                }
                ++n2;
            }
            return metamodelProvider;
        }
    }
}

