/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.persistence;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractMappingFileRef;

public abstract class AbstractOrmXmlRef
extends AbstractMappingFileRef<OrmXml> {
    protected AbstractOrmXmlRef(PersistenceUnit parent, String fileName) {
        super(parent, fileName);
    }

    @Override
    protected OrmXml buildMappingFile() {
        JptXmlResource xmlResource = this.resolveResourceMappingFile();
        return xmlResource == null ? null : (OrmXml)this.buildMappingFile(xmlResource);
    }

    protected JptXmlResource resolveResourceMappingFile() {
        if (this.fileName == null) {
            return null;
        }
        JptXmlResource xmlResource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path(this.fileName));
        if (xmlResource == null) {
            return null;
        }
        if (xmlResource.isReverting()) {
            return null;
        }
        JptResourceType resourceType = xmlResource.getResourceType();
        if (resourceType == null) {
            return null;
        }
        if (!this.getJpaPlatform().supportsResourceType(resourceType)) {
            return null;
        }
        return xmlResource;
    }

    @Override
    protected boolean mappingFileContentIsUnsupported() {
        JptXmlResource xmlResource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path(this.fileName));
        return xmlResource != null && !this.getJpaPlatform().supportsResourceType(xmlResource.getResourceType());
    }
}

