/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.queue;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.queue.Queue;

public class PriorityQueue<E>
implements Queue<E>,
Cloneable,
Serializable {
    private final Comparator<? super E> comparator;
    private transient E[] elements;
    private int size = 0;
    private static final long serialVersionUID = 1L;

    public PriorityQueue(Comparator<? super E> comparator, int initialCapacity) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        this.comparator = comparator;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal capacity: " + initialCapacity);
        }
        this.elements = new Object[initialCapacity + 1];
    }

    public PriorityQueue(Comparator<? super E> comparator, E[] initialElements, int size) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        this.comparator = comparator;
        if (initialElements == null) {
            throw new NullPointerException();
        }
        if (initialElements.length == 0) {
            throw new IllegalArgumentException("Initial elements array must have a length of at least 1.");
        }
        this.elements = initialElements;
        if (size < 0) {
            throw new IllegalArgumentException("Illegal size: " + size);
        }
        this.size = size;
        if (this.size > 1) {
            int nonLeafMax;
            int i = nonLeafMax = this.size >> 1;
            while (i > 0) {
                int child;
                int current = i;
                do {
                    if ((child = current << 1) < this.size && this.comparator.compare(this.elements[child + 1], this.elements[child]) < 0) {
                        ++child;
                    }
                    if (this.comparator.compare(this.elements[current], this.elements[child]) < 0) break;
                    ArrayTools.swap(this.elements, current, child);
                } while ((current = child) <= nonLeafMax);
                --i;
            }
        }
    }

    @Override
    public void enqueue(E element) {
        this.ensureCapacity(this.size + 1);
        ++this.size;
        int current = this.size;
        this.elements[current] = element;
        int parent = current >> 1;
        while (parent != 0 && this.comparator.compare(this.elements[current], this.elements[parent]) < 0) {
            ArrayTools.swap(this.elements, current, parent);
            current = parent;
            parent = current >> 1;
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elements.length - 1;
        if (oldCapacity < minCapacity) {
            int newCapacity = (oldCapacity * 3 >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elements = this.copyElements(newCapacity);
        }
    }

    public void trimToSize() {
        if (this.elements.length > this.size + 1) {
            this.elements = this.copyElements(this.size);
        }
    }

    private E[] copyElements(int newCapacity) {
        Object[] newElements = new Object[newCapacity + 1];
        System.arraycopy(this.elements, 1, newElements, 1, this.size);
        return newElements;
    }

    @Override
    public E dequeue() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        E element = this.elements[1];
        if (this.size != 1) {
            ArrayTools.swap(this.elements, 1, this.size);
            int newSize = this.size - 1;
            int nonLeafMax = newSize >> 1;
            int current = 1;
            while (current <= nonLeafMax) {
                int child = current << 1;
                if (child < newSize && this.comparator.compare(this.elements[child + 1], this.elements[child]) < 0) {
                    ++child;
                }
                if (this.comparator.compare(this.elements[current], this.elements[child]) < 0) break;
                ArrayTools.swap(this.elements, current, child);
                current = child;
            }
        }
        this.elements[this.size] = null;
        --this.size;
        return element;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[1];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public PriorityQueue<E> clone() {
        try {
            PriorityQueue clone = (PriorityQueue)super.clone();
            Object[] array = (Object[])this.elements.clone();
            clone.elements = array;
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return Arrays.toString(ArrayTools.subArray(this.elements, 1, this.size + 1));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        E[] array = this.elements;
        int elementsLength = array.length;
        stream.writeInt(elementsLength);
        if (this.size == 0) {
            return;
        }
        int i = 1;
        while (i <= this.size) {
            stream.writeObject(array[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int elementsLength = stream.readInt();
        Object[] array = new Object[elementsLength];
        int i = 1;
        while (i <= this.size) {
            array[i] = stream.readObject();
            ++i;
        }
        this.elements = array;
    }
}

