/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger;

import org.eclipse.dltk.tcl.activestatedebugger.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ErrorAction {
    STOP_ALWAYS("stopAlways", Messages.ErrorAction_stopAlways),
    STOP_UNCAUGHT("stopUncaught", Messages.ErrorAction_stopUncaught),
    STOP_NEVER("stopNever", Messages.ErrorAction_stopNever);

    private final String value;
    private final String caption;

    private ErrorAction(String value, String caption) {
        this.value = value;
        this.caption = caption;
    }

    public String getValue() {
        return this.value;
    }

    public String getCaption() {
        return this.caption;
    }

    public static String[] getNames() {
        ErrorAction[] errorActions = ErrorAction.values();
        String[] names = new String[errorActions.length];
        int i = 0;
        while (i < errorActions.length) {
            names[i] = errorActions[i].getValue();
            ++i;
        }
        return names;
    }

    public static ErrorAction decode(String value) {
        if (value != null) {
            try {
                return ErrorAction.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

