/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.preferences.SpellingConfigurationBlock;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.spelling.IPreferenceStatusMonitor;
import org.eclipse.ui.texteditor.spelling.ISpellingPreferenceBlock;

public class SpellingPreferenceBlock
implements ISpellingPreferenceBlock {
    private final SpellingConfigurationBlock fBlock = new SpellingConfigurationBlock(new NullStatusChangeListener(), null, null);
    private StatusChangeListenerAdapter fStatusMonitor;

    public Control createControl(Composite parent) {
        return this.fBlock.createContents(parent);
    }

    public void initialize(IPreferenceStatusMonitor statusMonitor) {
        this.fStatusMonitor = new StatusChangeListenerAdapter(statusMonitor);
        this.fBlock.fContext = this.fStatusMonitor;
    }

    public boolean canPerformOk() {
        return this.fStatusMonitor == null || this.fStatusMonitor.getStatus() == null || !this.fStatusMonitor.getStatus().matches(4);
    }

    public void performOk() {
        this.fBlock.performOk();
    }

    public void performDefaults() {
        this.fBlock.performDefaults();
    }

    public void performRevert() {
        this.fBlock.performRevert();
    }

    public void dispose() {
        this.fBlock.dispose();
    }

    public void setEnabled(boolean enabled) {
        this.fBlock.setEnabled(enabled);
    }

    private class NullStatusChangeListener
    implements IStatusChangeListener {
        private NullStatusChangeListener() {
        }

        @Override
        public void statusChanged(IStatus status) {
        }
    }

    private class StatusChangeListenerAdapter
    implements IStatusChangeListener {
        private final IPreferenceStatusMonitor fMonitor;
        private IStatus fStatus;

        public StatusChangeListenerAdapter(IPreferenceStatusMonitor monitor) {
            this.fMonitor = monitor;
        }

        @Override
        public void statusChanged(IStatus status) {
            this.fStatus = status;
            this.fMonitor.statusChanged(status);
        }

        public IStatus getStatus() {
            return this.fStatus;
        }
    }
}

