/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ChartType implements Enumerator
{
    PIE_LITERAL(0, "Pie", "Pie"),
    BAR_LITERAL(1, "Bar", "Bar"),
    LINE_LITERAL(2, "Line", "Line"),
    COMBO_LITERAL(3, "Combo", "Combo"),
    SCATTER_LITERAL(4, "Scatter", "Scatter"),
    STOCK_LITERAL(5, "Stock", "Stock");

    public static final int PIE = 0;
    public static final int BAR = 1;
    public static final int LINE = 2;
    public static final int COMBO = 3;
    public static final int SCATTER = 4;
    public static final int STOCK = 5;
    private static final ChartType[] VALUES_ARRAY;
    public static final List<ChartType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ChartType[]{PIE_LITERAL, BAR_LITERAL, LINE_LITERAL, COMBO_LITERAL, SCATTER_LITERAL, STOCK_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ChartType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChartType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChartType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChartType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChartType get(int value) {
        switch (value) {
            case 0: {
                return PIE_LITERAL;
            }
            case 1: {
                return BAR_LITERAL;
            }
            case 2: {
                return LINE_LITERAL;
            }
            case 3: {
                return COMBO_LITERAL;
            }
            case 4: {
                return SCATTER_LITERAL;
            }
            case 5: {
                return STOCK_LITERAL;
            }
        }
        return null;
    }

    private ChartType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

