/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.progress.JobSnapshot;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.views.IViewDescriptor;

public class ProgressManagerUtil {
    public static long SHORT_OPERATION_TIME = 250L;
    static final QualifiedName KEEP_PROPERTY = IProgressConstants.KEEP_PROPERTY;
    static final QualifiedName KEEPONE_PROPERTY = IProgressConstants.KEEPONE_PROPERTY;
    static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static String ellipsis = ProgressMessages.ProgressFloatingWindow_EllipsisValue;

    static IStatus exceptionStatus(Throwable exception) {
        return StatusUtil.newStatus(4, exception.getMessage() == null ? "" : exception.getMessage(), exception);
    }

    static void logException(Throwable exception) {
        BundleUtility.log("org.eclipse.ui", exception);
    }

    static ViewerComparator getProgressViewerComparator() {
        return new ProgressViewerComparator();
    }

    static void openProgressView(IWorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        try {
            IViewDescriptor reference = WorkbenchPlugin.getDefault().getViewRegistry().find("org.eclipse.ui.views.ProgressView");
            if (reference == null) {
                return;
            }
            page.showView("org.eclipse.ui.views.ProgressView");
        }
        catch (PartInitException exception) {
            ProgressManagerUtil.logException((Throwable)((Object)exception));
        }
    }

    static String shortenText(String textValue, Control control) {
        if (textValue == null) {
            return null;
        }
        int maxWidth = control.getBounds().width - 5;
        String ellipsisString = ellipsis;
        GC gc = new GC((Drawable)control);
        try {
            String string = ProgressManagerUtil.clipToSize(gc, textValue, ellipsisString, maxWidth);
            return string;
        }
        finally {
            gc.dispose();
        }
    }

    private static String clipToSize(GC gc, String textValue, String ellipsisString, int maxWidth) {
        int upperBoundWidth;
        int currentLength;
        int averageCharWidth = (int)gc.getFontMetrics().getAverageCharacterWidth();
        int length = textValue.length();
        int secondWord = ProgressManagerUtil.findSecondWhitespace(textValue, gc, maxWidth);
        int pivot = (length - secondWord) / 2 + secondWord;
        int upperBoundLength = 0;
        int lowerBoundLength = 0;
        int lowerBoundWidth = 0;
        int estimatedCharactersThatWillFit = maxWidth / averageCharWidth;
        if (estimatedCharactersThatWillFit >= length) {
            int maxExtent = gc.textExtent((String)textValue).x;
            if (maxExtent <= maxWidth) {
                return textValue;
            }
            currentLength = Math.max(0, Math.round((float)length * ((float)maxWidth / (float)maxExtent)) - ellipsisString.length());
            upperBoundWidth = maxExtent;
            upperBoundLength = length;
        } else {
            currentLength = Math.min(length, Math.max(0, estimatedCharactersThatWillFit - ellipsisString.length()));
            while (true) {
                String s = ProgressManagerUtil.clipToLength(textValue, ellipsisString, pivot, currentLength);
                int currentExtent = gc.textExtent((String)s).x;
                if (currentExtent > maxWidth) {
                    upperBoundWidth = currentExtent;
                    upperBoundLength = currentLength;
                    break;
                }
                if (currentLength == length) {
                    return textValue;
                }
                lowerBoundWidth = currentExtent;
                lowerBoundLength = currentLength;
                currentLength = Math.min(length, currentLength * 2 + 1);
            }
        }
        while (true) {
            int oldLength = --currentLength;
            String s = ProgressManagerUtil.clipToLength(textValue, ellipsisString, pivot, currentLength);
            int l = gc.textExtent((String)s).x;
            int tooBigBy = l - maxWidth;
            if (tooBigBy == 0) break;
            if (tooBigBy > 0) {
                upperBoundLength = currentLength;
                upperBoundWidth = l;
                if (currentLength <= lowerBoundLength + 1) {
                    currentLength = lowerBoundLength;
                    break;
                }
                if (tooBigBy <= averageCharWidth * 2) continue;
                int spaceToRightOfLowerBound = maxWidth - lowerBoundWidth;
                if ((currentLength = lowerBoundLength + (currentLength - lowerBoundLength) * spaceToRightOfLowerBound / (l - lowerBoundWidth)) >= oldLength) {
                    currentLength = oldLength - 1;
                    continue;
                }
                if (currentLength > lowerBoundLength) continue;
                currentLength = lowerBoundLength + 1;
                continue;
            }
            lowerBoundLength = currentLength;
            lowerBoundWidth = l;
            if (currentLength >= upperBoundLength - 1) {
                currentLength = upperBoundLength - 1;
                break;
            }
            if (-tooBigBy <= averageCharWidth * 2) {
                ++currentLength;
                continue;
            }
            if ((currentLength += (upperBoundLength - currentLength) * -tooBigBy / (upperBoundWidth - l)) <= oldLength) {
                currentLength = oldLength + 1;
                continue;
            }
            if (currentLength < upperBoundLength) continue;
            currentLength = upperBoundLength - 1;
        }
        return ProgressManagerUtil.clipToLength(textValue, ellipsisString, pivot, currentLength);
    }

    private static String clipToLength(String textValue, String ellipsisString, int pivot, int newLength) {
        return ProgressManagerUtil.getClippedString(textValue, ellipsisString, pivot, textValue.length() - newLength);
    }

    private static String getClippedString(String textValue, String ellipsisString, int pivot, int charsToClip) {
        int length = textValue.length();
        if (charsToClip <= 0) {
            return textValue;
        }
        if (charsToClip >= length) {
            return "";
        }
        int start = pivot - charsToClip / 2;
        int end = pivot + (charsToClip + 1) / 2;
        if (start < 0) {
            end -= start;
            start = 0;
        }
        if (end < 0) {
            start -= end;
            end = 0;
        }
        String s1 = textValue.substring(0, start);
        String s2 = end < length ? textValue.substring(end, length) : "";
        return s1 + ellipsisString + s2;
    }

    private static int findSecondWhitespace(String textValue, GC gc, int maxWidth) {
        int firstCharacter = 0;
        char[] chars = textValue.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (Character.isWhitespace(chars[i])) {
                firstCharacter = i;
                break;
            }
            ++i;
        }
        if (firstCharacter == 0) {
            return 0;
        }
        int secondCharacter = firstCharacter;
        int i2 = firstCharacter;
        while (i2 < chars.length) {
            if (Character.isWhitespace(chars[i2])) {
                secondCharacter = i2;
                break;
            }
            ++i2;
        }
        if (gc.textExtent((String)textValue.substring((int)0, (int)secondCharacter)).x > maxWidth) {
            if (gc.textExtent((String)textValue.substring((int)0, (int)firstCharacter)).x > maxWidth) {
                return 0;
            }
            return firstCharacter;
        }
        return secondCharacter;
    }

    public static boolean rescheduleIfModalShellOpen(Job openJob) {
        Shell modal = ProgressManagerUtil.getModalShellExcluding(null);
        if (modal == null) {
            return false;
        }
        openJob.schedule((long)PlatformUI.getWorkbench().getProgressService().getLongOperationTime());
        return true;
    }

    public static boolean safeToOpen(ProgressMonitorJobsDialog dialog, Shell excludedShell) {
        Shell modal = ProgressManagerUtil.getModalShellExcluding(excludedShell);
        if (modal == null) {
            return true;
        }
        dialog.watchTicks();
        return false;
    }

    public static Shell getModalShellExcluding(Shell shell) {
        if (shell == null || shell.isDisposed()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display.isDisposed()) {
                return null;
            }
            return ProgressManagerUtil.getModalChildExcluding(display.getShells(), shell);
        }
        return ProgressManagerUtil.getModalChildExcluding(shell.getShells(), shell);
    }

    private static Shell getModalChildExcluding(Shell[] toSearch, Shell toExclude) {
        int modal = 229376;
        int i = toSearch.length - 1;
        while (i >= 0) {
            Shell shell = toSearch[i];
            if (!shell.equals(toExclude) && !shell.isDisposed()) {
                Shell[] children = shell.getShells();
                Shell modalChild = ProgressManagerUtil.getModalChildExcluding(children, toExclude);
                if (modalChild != null) {
                    return modalChild;
                }
                if (shell.isVisible() && (shell.getStyle() & modal) != 0) {
                    return shell;
                }
            }
            --i;
        }
        return null;
    }

    public static Shell getDefaultParent() {
        Shell modal = ProgressManagerUtil.getModalShellExcluding(null);
        if (modal != null) {
            return modal;
        }
        Shell nonModalShell = ProgressManagerUtil.getNonModalShell();
        if (nonModalShell != null && nonModalShell.isVisible()) {
            return nonModalShell;
        }
        Shell splashShell = WorkbenchPlugin.getSplashShell(PlatformUI.getWorkbench().getDisplay());
        if (splashShell != null && splashShell.isVisible()) {
            return splashShell;
        }
        return nonModalShell;
    }

    public static Shell getNonModalShell() {
        Object widget;
        MApplication application = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
        if (application == null) {
            return null;
        }
        MWindow window = (MWindow)application.getSelectedElement();
        if (window != null && (widget = window.getWidget()) instanceof Shell) {
            return (Shell)widget;
        }
        for (MWindow child : application.getChildren()) {
            Object widget2 = child.getWidget();
            if (!(widget2 instanceof Shell)) continue;
            return (Shell)widget2;
        }
        return null;
    }

    static IShellProvider getShellProvider() {
        return ProgressManagerUtil::getDefaultParent;
    }

    public static URL getIconsRoot() {
        return BundleUtility.find("org.eclipse.ui", "$nl$/icons/full/progress/");
    }

    public static URL getProgressSpinnerLocation() {
        try {
            return new URL(ProgressManagerUtil.getIconsRoot(), "progress_spinner.png");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    static class ProgressViewerComparator
    extends ViewerComparator {
        private final HashMap<JobSnapshot, Integer> lastIndexes = new HashMap();
        private final Comparator<JobSnapshot> byIndex = Comparator.comparing(this.lastIndexes::get, Comparator.nullsLast(Integer::compare));

        ProgressViewerComparator() {
        }

        public void sort(Viewer viewer, Object[] elements) {
            Object[] src = (Object[])elements.clone();
            JobSnapshot[] snapshots = new JobSnapshot[elements.length];
            int i = 0;
            while (i < elements.length) {
                JobTreeElement jobTreeElement = (JobTreeElement)elements[i];
                snapshots[i] = new JobSnapshot(jobTreeElement, i);
                ++i;
            }
            Arrays.sort(snapshots, this.byIndex.thenComparing(JobSnapshot::compareTo));
            this.lastIndexes.clear();
            i = 0;
            while (i < snapshots.length) {
                this.lastIndexes.put(snapshots[i], i);
                ++i;
            }
            i = 0;
            while (i < elements.length) {
                elements[i] = src[snapshots[i].getIndex()];
                ++i;
            }
        }
    }
}

