/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;

public abstract class DockableDialog
extends Dialog {
    private static final Map<IWorkbenchWindow, Map<Class<?>, Dockable>> DIALOGS = new HashMap();
    private static final Map<IWorkbenchWindow, Map<Class<?>, Set<IWorkbenchPartReference>>> DOCKED_PARTS = new HashMap();
    private static final DisposeListener WORKBENCH_DISPOSE_LISTENER = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            DIALOGS.remove(e.getSource());
            DOCKED_PARTS.remove(e.getSource());
        }
    };
    private final IWorkbenchWindow workbenchWindow;
    private final Dockable dockable = new Dockable(this){

        @Override
        public boolean handleWorkbenchPart(IWorkbenchPart part) {
            return DockableDialog.this.handleWorkbenchPart(part);
        }
    };

    protected DockableDialog(IWorkbenchWindow workbenchWindow) {
        super(workbenchWindow.getShell());
        this.setShellStyle(this.getShellStyle() ^ 0x10000 | 0x10 | 0x400 | (OS.INSTANCE.isWin() ? 128 : 0));
        this.setBlockOnOpen(false);
        this.workbenchWindow = workbenchWindow;
    }

    public abstract boolean handleWorkbenchPart(IWorkbenchPart var1);

    public Dockable getDockable() {
        return this.dockable;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.workbenchWindow;
    }

    private static void updateVisibility(Shell shell, boolean visible) {
        if (visible) {
            shell.setData("forced", null);
            if (OS.INSTANCE.isWin()) {
                shell.setMinimized(false);
            }
            shell.setVisible(true);
            shell.notifyListeners(20, new Event());
        } else {
            shell.setData("forced", (Object)true);
            shell.setVisible(false);
            if (OS.INSTANCE.isWin()) {
                shell.setMinimized(true);
            }
            shell.notifyListeners(19, new Event());
        }
    }

    private static Image[] getDockedImages(Image[] images) {
        Image[] dockedImages = new Image[images.length];
        int i = 0;
        int length = images.length;
        while (i < length) {
            dockedImages[i] = DockableDialog.getDockedImage(images[i]);
            ++i;
        }
        return dockedImages;
    }

    private static Image getDockedImage(Image image) {
        if (image == null) {
            return null;
        }
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(image);
        images.add(UIPlugin.INSTANCE.getSWTImage("docked_overlay"));
        return ExtendedImageRegistry.INSTANCE.getImage((Object)new DockedOverlayImage(images));
    }

    public static <T extends Dialog> T getFor(Class<T> type, IWorkbenchWindow workbenchWindow) {
        Dockable dockable;
        Map<Class<?>, Dockable> typedDialogs = DIALOGS.get(workbenchWindow);
        if (typedDialogs != null && (dockable = typedDialogs.get(type)) != null) {
            Dialog dialog = dockable.getDialog();
            return (T)dialog;
        }
        return null;
    }

    public static void closeFor(Class<? extends Dialog> type, IWorkbenchWindow workbenchWindow) {
        Dockable dockable;
        Map<Class<?>, Dockable> typedDialogs = DIALOGS.get(workbenchWindow);
        if (typedDialogs != null && (dockable = typedDialogs.get(type)) != null) {
            Shell shell = dockable.getShell();
            shell.notifyListeners(21, new Event());
            dockable.close();
        }
    }

    public static <T extends Dialog> T openFor(Class<T> type, Factory<T> factory, final IWorkbenchWindow workbenchWindow) {
        Dockable dockable;
        Map<Class<?>, Dockable> typedDialogs = DIALOGS.get(workbenchWindow);
        Dockable dockable2 = dockable = typedDialogs == null ? null : typedDialogs.get(type);
        if (dockable == null) {
            dockable = (Dockable)ReflectUtil.invokeMethod((String)"getDockable", factory.create(workbenchWindow));
            if (typedDialogs == null) {
                typedDialogs = new HashMap();
                DIALOGS.put(workbenchWindow, typedDialogs);
            }
            typedDialogs.put(type, dockable);
            dockable.open();
            Map<Class<?>, Set<IWorkbenchPartReference>> typedDockedParts = DOCKED_PARTS.get(workbenchWindow);
            Set<IWorkbenchPartReference> dockedParts = typedDockedParts == null ? null : typedDockedParts.get(type);
            boolean isInitial = false;
            if (dockedParts == null) {
                isInitial = true;
                dockedParts = new HashSet<IWorkbenchPartReference>();
                if (typedDockedParts == null) {
                    typedDockedParts = new HashMap();
                    DOCKED_PARTS.put(workbenchWindow, typedDockedParts);
                }
                typedDockedParts.put(type, dockedParts);
            }
            Shell windowShell = workbenchWindow.getShell();
            windowShell.addDisposeListener(WORKBENCH_DISPOSE_LISTENER);
            final Shell shell = dockable.getShell();
            class ShellHandler
            extends ShellAdapter
            implements ControlListener,
            DisposeListener,
            Runnable {
                private final Dockable dockableDialog;
                private final Shell shell;
                private final Display display;
                private final Map<CTabFolder, Rectangle> tabFolders = new HashMap<CTabFolder, Rectangle>();
                private final Map<CTabFolder, Set<IWorkbenchPartReference>> tabFolderParts = new HashMap<CTabFolder, Set<IWorkbenchPartReference>>();
                private final Cursor sizeAllCursor;
                private final ControlListener dockingListener = new ControlListener(){

                    public void controlResized(ControlEvent e) {
                        this.update();
                    }

                    public void controlMoved(ControlEvent e) {
                        this.update();
                    }
                };
                private Point snapPoint;
                private boolean ignoreControlMoved;
                private Point cursorLocation;
                private long timeOfLastCursorChange;
                private long timeOfLastUpdate;
                private Rectangle hotZone;
                private long timeOfLastHotZoneChange;
                private long timeOfLastMove;
                private Rectangle snapBounds;
                private CTabFolder dockedTabFolder;
                private final Set<IWorkbenchPartReference> dockedParts;
                private final Image shellImage;
                private final Image dockedShellImage;
                private final Image[] shellImages;
                private final Image[] dockedShellImages;
                private final /* synthetic */ Shell val$windowShell;
                private final /* synthetic */ IWorkbenchWindow val$workbenchWindow;
                private final /* synthetic */ Class val$type;

                public ShellHandler(Dockable dockedParts, Set<IWorkbenchPartReference> set) {
                    this.val$windowShell = set;
                    this.val$workbenchWindow = var4_4;
                    this.val$type = var5_5;
                    this.dockableDialog = dockableDialog;
                    this.shell = dockableDialog.getShell();
                    this.dockedParts = dockedParts;
                    this.display = this.shell.getDisplay();
                    this.sizeAllCursor = this.display.getSystemCursor(5);
                    this.shell.addShellListener((ShellListener)this);
                    this.shell.addControlListener((ControlListener)this);
                    this.shell.addDisposeListener((DisposeListener)this);
                    this.shellImage = this.shell.getImage();
                    this.dockedShellImage = DockableDialog.getDockedImage(this.shellImage);
                    this.shellImages = this.shell.getImages();
                    this.dockedShellImages = DockableDialog.getDockedImages(this.shellImages);
                }

                public void shellIconified(ShellEvent e) {
                    this.updateActions(false);
                    if (!OS.INSTANCE.isMac() && this.shell.isVisible()) {
                        this.shell.setVisible(false);
                    }
                }

                public void shellDeiconified(ShellEvent e) {
                    if (this.shell.isVisible()) {
                        this.updateActions(true);
                    }
                }

                protected void updateActions(boolean checked) {
                    for (IAction action : this.dockableDialog.getActions()) {
                        action.setChecked(checked);
                    }
                }

                public void controlResized(ControlEvent e) {
                    if (OS.INSTANCE.isMac() && !this.ignoreControlMoved) {
                        this.dock(null);
                    }
                }

                public void controlMoved(ControlEvent e) {
                    boolean maximized = this.shell.getMaximized();
                    if (maximized) {
                        this.snapBounds = null;
                    }
                    if (!(this.ignoreControlMoved || maximized || OS.INSTANCE.isLinux() && System.currentTimeMillis() - this.timeOfLastUpdate <= 500L)) {
                        if (this.snapBounds != null) {
                            if (!OS.INSTANCE.isMac() || System.currentTimeMillis() - this.timeOfLastMove < 200L) {
                                this.setBounds(this.snapBounds);
                                this.dock(this.snapBounds);
                            }
                            this.snapBounds = null;
                        } else if (this.dockedTabFolder != null) {
                            if (!this.getBounds(this.dockedTabFolder).equals((Object)this.shell.getBounds())) {
                                this.dock(null);
                            } else {
                                return;
                            }
                        }
                        long newTimeOfLastMove = System.currentTimeMillis();
                        if (newTimeOfLastMove - this.timeOfLastMove > 1000L) {
                            if (!OS.INSTANCE.isMac() || newTimeOfLastMove - this.timeOfLastCursorChange > 1000L) {
                                this.hotZone = null;
                                this.snapPoint = null;
                                this.snapBounds = null;
                            }
                            if (OS.INSTANCE.isMac()) {
                                this.display.timerExec(100, (Runnable)this);
                            }
                        }
                        this.timeOfLastMove = newTimeOfLastMove;
                        Point cursorLocation = this.display.getCursorLocation();
                        Rectangle newHotZone = this.getHotZone(cursorLocation);
                        if (newHotZone != null) {
                            if (!newHotZone.equals((Object)this.hotZone)) {
                                this.timeOfLastHotZoneChange = System.currentTimeMillis();
                                this.hotZone = newHotZone;
                            }
                            if (System.currentTimeMillis() - this.timeOfLastHotZoneChange > 400L) {
                                if (this.snapPoint == null) {
                                    this.shell.setCursor(this.sizeAllCursor);
                                    this.updateShellImage(true);
                                    this.display.timerExec(100, (Runnable)this);
                                }
                                this.snapPoint = cursorLocation;
                            }
                        } else {
                            this.shell.setCursor(null);
                            this.updateShellImage(false);
                            this.snapPoint = null;
                            this.hotZone = null;
                            this.dock(null);
                        }
                    }
                }

                @Override
                public void run() {
                    if (this.shell.isDisposed()) {
                        return;
                    }
                    Point newCursorLocation = this.display.getCursorLocation();
                    if (this.cursorLocation == null || !this.cursorLocation.equals((Object)newCursorLocation)) {
                        this.timeOfLastCursorChange = System.currentTimeMillis();
                        this.cursorLocation = newCursorLocation;
                    }
                    if (!(this.snapPoint != null || OS.INSTANCE.isMac() && this.display.getCursorControl() == null)) {
                        this.shell.setCursor(null);
                    } else if (System.currentTimeMillis() - this.timeOfLastCursorChange > 500L) {
                        this.snapBounds = this.getHotZone(this.snapPoint == null ? this.cursorLocation : this.snapPoint);
                        if (this.snapBounds != null) {
                            this.setBounds(this.snapBounds);
                            this.snapPoint = null;
                            this.timeOfLastCursorChange = System.currentTimeMillis();
                            this.dock(this.snapBounds);
                            this.shell.setCursor(null);
                        }
                    } else {
                        this.display.timerExec(100, (Runnable)this);
                    }
                }

                private Rectangle getHotZone(Point cursorLocation) {
                    for (Rectangle rectangle : this.getHotZones()) {
                        Rectangle hotZone = new Rectangle(rectangle.x, rectangle.y, rectangle.width, 30);
                        if (!hotZone.contains(cursorLocation)) continue;
                        return rectangle;
                    }
                    return null;
                }

                private void setBounds(Rectangle bounds) {
                    if (OS.INSTANCE.isLinux()) {
                        this.snapBounds = bounds;
                        this.timeOfLastMove = System.currentTimeMillis();
                    }
                    this.ignoreControlMoved = true;
                    this.shell.setBounds(bounds);
                    this.ignoreControlMoved = false;
                }

                private void dock(Rectangle rectangle) {
                    this.gatherTabFolders();
                    this.val$windowShell.removeControlListener(this.dockingListener);
                    if (this.dockedTabFolder != null) {
                        this.dockedTabFolder.removeControlListener(this.dockingListener);
                    }
                    this.dockedParts.clear();
                    for (Map.Entry<CTabFolder, Rectangle> entry : this.tabFolders.entrySet()) {
                        if (!entry.getValue().equals((Object)rectangle)) continue;
                        this.val$windowShell.addControlListener(this.dockingListener);
                        this.dockedTabFolder = entry.getKey();
                        this.dockedTabFolder.addControlListener(this.dockingListener);
                        this.dockedParts.addAll((Collection<IWorkbenchPartReference>)this.tabFolderParts.get(this.dockedTabFolder));
                        this.updateShellImage(true);
                        return;
                    }
                    this.dockedTabFolder = null;
                    this.updateShellImage(false);
                }

                private void updateShellImage(boolean docking) {
                    if (this.shellImage != null) {
                        this.shell.setImage(docking ? this.dockedShellImage : this.shellImage);
                    }
                    if (this.shellImages != null) {
                        this.shell.setImages(docking ? this.dockedShellImages : this.shellImages);
                    }
                }

                private void dispose() {
                    if (!this.val$windowShell.isDisposed()) {
                        this.val$windowShell.removeControlListener(this.dockingListener);
                    }
                    if (this.dockedTabFolder != null && !this.dockedTabFolder.isDisposed()) {
                        this.dockedTabFolder.removeControlListener(this.dockingListener);
                    }
                }

                public void widgetDisposed(DisposeEvent e) {
                    Map<Class<?>, Dockable> typedDialogs = DIALOGS.get(this.val$workbenchWindow);
                    if (typedDialogs != null) {
                        typedDialogs.remove(this.val$type);
                    }
                    for (IAction action : this.dockableDialog.getActions()) {
                        action.setChecked(false);
                    }
                    IDialogSettings dialogBoundsSettings = this.dockableDialog.getBoundsSettings();
                    if (dialogBoundsSettings != null) {
                        StringBuilder partIDs = new StringBuilder();
                        for (IWorkbenchPartReference partReference : this.dockedParts) {
                            if (partIDs.length() != 0) {
                                partIDs.append(' ');
                            }
                            partIDs.append(partReference.getId());
                        }
                        dialogBoundsSettings.put("dockedParts", partIDs.toString());
                    }
                    this.dispose();
                }

                private void update() {
                    if (!(this.dockedParts.isEmpty() || this.dockedTabFolder != null && this.dockedTabFolder.isDisposed())) {
                        this.gatherTabFolders();
                        if (this.dockedTabFolder == null || !this.dockedTabFolder.isVisible()) {
                            for (IWorkbenchPartReference partReference : this.dockedParts) {
                                for (Map.Entry<CTabFolder, Set<IWorkbenchPartReference>> entry : this.tabFolderParts.entrySet()) {
                                    if (!entry.getValue().contains(partReference)) continue;
                                    CTabFolder tabFolder = entry.getKey();
                                    Rectangle bounds = this.getBounds(tabFolder);
                                    this.setBounds(bounds);
                                    this.dock(bounds);
                                    this.timeOfLastUpdate = System.currentTimeMillis();
                                    if (!this.shell.isVisible() && Boolean.TRUE.equals(this.shell.getData("forced"))) {
                                        DockableDialog.updateVisibility(this.shell, true);
                                    }
                                    return;
                                }
                            }
                            if (this.dockedTabFolder != null) {
                                DockableDialog.updateVisibility(this.shell, false);
                            }
                        } else {
                            Rectangle bounds = this.getBounds(this.dockedTabFolder);
                            this.setBounds(bounds);
                            this.timeOfLastUpdate = System.currentTimeMillis();
                            if (!this.shell.isVisible() && Boolean.TRUE.equals(this.shell.getData("forced"))) {
                                DockableDialog.updateVisibility(this.shell, true);
                            }
                        }
                    }
                }

                private void initialize() {
                    String dockedPartIDs;
                    IDialogSettings dialogBoundsSettings = this.dockableDialog.getBoundsSettings();
                    if (dialogBoundsSettings != null && !StringUtil.isEmpty((String)(dockedPartIDs = dialogBoundsSettings.get("dockedParts")))) {
                        this.gatherTabFolders();
                        List ids = StringUtil.explode((String)dockedPartIDs, (String)" ");
                        for (Set<IWorkbenchPartReference> partReferences : this.tabFolderParts.values()) {
                            for (IWorkbenchPartReference partReference : partReferences) {
                                if (!ids.contains(partReference.getId())) continue;
                                this.dockedParts.add(partReference);
                            }
                        }
                    }
                }

                private Collection<Rectangle> getHotZones() {
                    this.gatherTabFolders();
                    return this.tabFolders.values();
                }

                private Rectangle getBounds(CTabFolder tabFolder) {
                    Rectangle bounds = tabFolder.getBounds();
                    Point displayPoint = tabFolder.getParent().toDisplay(bounds.x, bounds.y);
                    bounds.x = displayPoint.x;
                    bounds.y = displayPoint.y;
                    if (OS.INSTANCE.isMac()) {
                        ++bounds.x;
                        bounds.width -= 2;
                        ++bounds.y;
                        bounds.height -= 2;
                    }
                    return bounds;
                }

                public void gatherTabFolders() {
                    this.tabFolders.clear();
                    this.tabFolderParts.clear();
                    IWorkbenchPage page = this.val$workbenchWindow.getActivePage();
                    if (page != null) {
                        IEditorReference[] editorReferences;
                        IViewReference[] viewReferences;
                        IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
                        int n = viewReferences.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IViewReference viewReference = iViewReferenceArray[n2];
                            this.gatherTabFolders((IWorkbenchPartReference)viewReference);
                            ++n2;
                        }
                        IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
                        int n3 = editorReferences.length;
                        n = 0;
                        while (n < n3) {
                            IEditorReference editorReference = iEditorReferenceArray[n];
                            this.gatherTabFolders((IWorkbenchPartReference)editorReference);
                            ++n;
                        }
                    }
                }

                private void gatherTabFolders(IWorkbenchPartReference partReference) {
                    Object widget;
                    Object part = ReflectUtil.getValue((String)"part", (Object)partReference);
                    if (part != null && (widget = ReflectUtil.invokeMethod((String)"getWidget", (Object)part)) instanceof Control) {
                        Control control = (Control)widget;
                        while (control != null) {
                            if (control.isVisible() && control instanceof CTabFolder) {
                                CTabFolder tabFolder = (CTabFolder)control;
                                this.tabFolders.put(tabFolder, this.getBounds(tabFolder));
                                CollectionUtil.add(this.tabFolderParts, (Object)tabFolder, (Object)partReference);
                            }
                            control = control.getParent();
                        }
                    }
                }
            }
            final ShellHandler shellHandler = new ShellHandler(dockable, dockedParts, windowShell, workbenchWindow, type);
            final PerspectiveAdapter perspectiveListener = new PerspectiveAdapter(){
                {
                }

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                    UIUtil.asyncExec((Control)shell, new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            shellHandler.update();
                        }
                    });
                }
            };
            workbenchWindow.addPerspectiveListener((IPerspectiveListener)perspectiveListener);
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    workbenchWindow.removePerspectiveListener((IPerspectiveListener)perspectiveListener);
                }
            });
            if (isInitial) {
                shellHandler.initialize();
            }
            shellHandler.update();
        } else {
            Shell shell = dockable.getShell();
            DockableDialog.updateVisibility(shell, true);
        }
        Dialog dialog = dockable.getDialog();
        return (T)dialog;
    }

    public static class Dockable {
        private final List<WeakReference<IAction>> actions = new ArrayList<WeakReference<IAction>>();
        private Dialog dialog;

        public Dockable(Dialog dialog) {
            this.dialog = dialog;
        }

        public Dialog getDialog() {
            return this.dialog;
        }

        public Shell getShell() {
            return this.dialog.getShell();
        }

        public boolean handleWorkbenchPart(IWorkbenchPart part) {
            return true;
        }

        public void associate(IAction action) {
            if (!this.getActions().contains(action)) {
                this.actions.add(new WeakReference<IAction>(action));
                action.setChecked(true);
            }
        }

        public List<IAction> getActions() {
            ArrayList<IAction> result = new ArrayList<IAction>();
            Iterator<WeakReference<IAction>> it = this.actions.iterator();
            while (it.hasNext()) {
                WeakReference<IAction> actionReference = it.next();
                IAction referencedAction = (IAction)actionReference.get();
                if (referencedAction == null) {
                    it.remove();
                    continue;
                }
                result.add(referencedAction);
            }
            return result;
        }

        public IDialogSettings getBoundsSettings() {
            return (IDialogSettings)ReflectUtil.invokeMethod((String)"getDialogBoundsSettings", (Object)this.dialog);
        }

        public int open() {
            return this.dialog.open();
        }

        public boolean close() {
            return this.dialog.close();
        }

        public void setWorkbenchPart(IWorkbenchPart part) {
            Shell shell = this.getShell();
            if (!this.handleWorkbenchPart(part)) {
                if (shell.isVisible()) {
                    DockableDialog.updateVisibility(shell, false);
                }
            } else if (Boolean.TRUE.equals(shell.getData("forced"))) {
                DockableDialog.updateVisibility(shell, true);
            }
        }
    }

    private static class DockedOverlayImage
    extends ComposedImage {
        private DockedOverlayImage(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            ArrayList<ComposedImage.Point> result = new ArrayList<ComposedImage.Point>();
            result.add(new ComposedImage.Point());
            ComposedImage.Point overlay = new ComposedImage.Point();
            overlay.x = size.width - 7;
            result.add(overlay);
            return result;
        }
    }

    public static interface Factory<T extends Dialog> {
        public T create(IWorkbenchWindow var1);
    }
}

