/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.query.QueryUtil;

public class AttachmentHelper {
    private static final IInstallableUnitFragment[] NO_FRAGMENTS = new IInstallableUnitFragment[0];

    public static Collection<IInstallableUnit> attachFragments(Stream<IInstallableUnit> toAttach, Map<IInstallableUnitFragment, List<IInstallableUnit>> fragmentsToIUs) {
        HashMap fragmentBindings = new HashMap();
        HashMap<IInstallableUnit, List> iusToFragment = new HashMap<IInstallableUnit, List>(fragmentsToIUs.size());
        fragmentsToIUs.forEach((fragment, existingMatches) -> {
            for (IInstallableUnit host : existingMatches) {
                iusToFragment.computeIfAbsent(host, h -> new ArrayList()).add(fragment);
            }
        });
        iusToFragment.forEach((hostIU, potentialIUFragments) -> {
            ArrayList<IInstallableUnitFragment> applicableFragments = new ArrayList<IInstallableUnitFragment>();
            for (IInstallableUnitFragment potentialFragment : potentialIUFragments) {
                if (hostIU.equals((Object)potentialFragment)) continue;
                Collection reqsFromFragment = potentialFragment.getHost();
                if (!reqsFromFragment.stream().allMatch(arg_0 -> ((IInstallableUnit)hostIU).satisfies(arg_0))) continue;
                applicableFragments.add(potentialFragment);
            }
            IInstallableUnitFragment theFragment = null;
            int specificityLevel = 0;
            LinkedList<IInstallableUnitFragment> fragments = new LinkedList<IInstallableUnitFragment>();
            for (IInstallableUnitFragment fragment : applicableFragments) {
                if (AttachmentHelper.isTranslation(fragment)) {
                    fragments.addLast(fragment);
                    continue;
                }
                if (fragment.getHost().size() <= specificityLevel) continue;
                theFragment = fragment;
                specificityLevel = fragment.getHost().size();
            }
            if (theFragment != null) {
                fragments.addFirst(theFragment);
            }
            if (!fragments.isEmpty()) {
                fragmentBindings.put(hostIU, (IInstallableUnitFragment[])fragments.toArray(IInstallableUnitFragment[]::new));
            }
        });
        return toAttach.filter(Objects::nonNull).map(iu -> {
            if (QueryUtil.isFragment((IInstallableUnit)iu)) {
                return iu;
            }
            IInstallableUnitFragment[] fragments = fragmentBindings.getOrDefault(iu, NO_FRAGMENTS);
            return MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)iu, (IInstallableUnitFragment[])fragments);
        }).collect(Collectors.toCollection(HashSet::new));
    }

    private static boolean isTranslation(IInstallableUnitFragment fragment) {
        for (IProvidedCapability capability : fragment.getProvidedCapabilities()) {
            if (!"org.eclipse.equinox.p2.localization".equals(capability.getNamespace())) continue;
            return true;
        }
        return false;
    }
}

