/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.linuxtools.internal.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.internal.changelog.core.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class ChangeLogPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text emailField;
    private Text nameField;
    private List formatterList;
    private List editorList;

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        return text;
    }

    private List createListBox(Composite parent, int sizeHint) {
        List list = new List(parent, 2564);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.heightHint = list.getItemHeight() * sizeHint;
        list.setLayoutData((Object)data);
        return list;
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return ChangelogPlugin.getDefault().getPreferenceStore();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.emailField.setText(store.getDefaultString("IChangeLogConstants.AUTHOR_EMAIL"));
        this.nameField.setText(store.getDefaultString("IChangeLogConstants.AUTHOR_NAME"));
        this.setDefaultFormatter(store);
        this.setDefaultEditor(store);
        this.storeValues();
    }

    private void setDefaultFormatter(IPreferenceStore store) {
        String defaultFormatter = store.getDefaultString("IChangeLogConstants.DEFAULT_FORMATTER");
        for (int i = 0; i < this.formatterList.getItemCount(); ++i) {
            if (!this.formatterList.getItem(i).equals(defaultFormatter)) continue;
            this.formatterList.setSelection(i);
            return;
        }
    }

    private void setDefaultEditor(IPreferenceStore store) {
        String defaultEditor = store.getDefaultString("IChangeLogConstants.DEFAULT_EDITOR");
        for (int i = 0; i < this.editorList.getItemCount(); ++i) {
            if (!this.editorList.getItem(i).equals(defaultEditor)) continue;
            this.editorList.setSelection(i);
            return;
        }
    }

    private void populateFormatList(IPreferenceStore store) {
        IExtensionPoint parserExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.changelog.core", "formatterContribution");
        if (parserExtensions != null) {
            IConfigurationElement[] elements;
            for (IConfigurationElement element : elements = parserExtensions.getConfigurationElements()) {
                if (!element.getName().equals("formatter")) continue;
                String fname = element.getAttribute("name");
                if (element.getAttribute("inFile").equalsIgnoreCase("false")) {
                    this.formatterList.add(fname);
                }
                if (!fname.equals(store.getString("IChangeLogConstants.DEFAULT_FORMATTER"))) continue;
                this.formatterList.setSelection(this.formatterList.getItemCount() - 1);
            }
        }
    }

    private void populateEditorList(IPreferenceStore store) {
        IExtensionPoint editorExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.changelog.core", "editorContribution");
        if (editorExtensions != null) {
            IConfigurationElement[] elements;
            for (IConfigurationElement element : elements = editorExtensions.getConfigurationElements()) {
                if (!element.getName().equals("editor")) continue;
                String fname = element.getAttribute("name");
                this.editorList.add(fname);
                if (!fname.equals(store.getString("IChangeLogConstants.DEFAULT_EDITOR"))) continue;
                this.editorList.setSelection(this.editorList.getItemCount() - 1);
            }
        }
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.emailField.setText(store.getString("IChangeLogConstants.AUTHOR_EMAIL"));
        this.nameField.setText(store.getString("IChangeLogConstants.AUTHOR_NAME"));
        this.populateFormatList(store);
        this.populateEditorList(store);
    }

    private void storeValues() {
        String[] selection2;
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("IChangeLogConstants.AUTHOR_NAME", this.nameField.getText());
        store.setValue("IChangeLogConstants.AUTHOR_EMAIL", this.emailField.getText());
        String[] selection = this.formatterList.getSelection();
        if (selection != null && selection.length > 0) {
            store.setValue("IChangeLogConstants.DEFAULT_FORMATTER", selection[0]);
        }
        if ((selection2 = this.editorList.getSelection()) != null && selection2.length > 0) {
            store.setValue("IChangeLogConstants.DEFAULT_EDITOR", selection2[0]);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        try {
            InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.changelog.core").flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return true;
    }

    protected Control createContents(Composite parent) {
        Composite composite_textField = this.createComposite(parent, 2);
        this.createLabel(composite_textField, Messages.getString("ChangeLogPreferencesPage.AuthorName"));
        this.nameField = this.createTextField(composite_textField);
        this.createLabel(composite_textField, Messages.getString("ChangeLogPreferencesPage.AuthorEmail"));
        this.emailField = this.createTextField(composite_textField);
        this.createLabel(composite_textField, Messages.getString("ChangeLogPreferencesPage.Formatters"));
        this.formatterList = this.createListBox(composite_textField, 3);
        this.createLabel(composite_textField, Messages.getString("ChangeLogPreferencesPage.Editors"));
        this.editorList = this.createListBox(composite_textField, 3);
        this.initializeValues();
        return new Composite(parent, 0);
    }
}

