/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.sys;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jena.query.TxnType;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.base.file.ChannelManager;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.base.file.LocationLock;
import org.apache.jena.tdb1.setup.DatasetBuilderStd;
import org.apache.jena.tdb1.setup.StoreParams;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.sys.ProcessUtils;
import org.apache.jena.tdb1.sys.SystemTDB;
import org.apache.jena.tdb1.sys.TDBInternal;
import org.apache.jena.tdb1.sys.TDBMaker;
import org.apache.jena.tdb1.transaction.DatasetGraphTxn;
import org.apache.jena.tdb1.transaction.JournalControl;
import org.apache.jena.tdb1.transaction.SysTxnState;
import org.apache.jena.tdb1.transaction.TDBTransactionException;
import org.apache.jena.tdb1.transaction.TransactionManager;

public class StoreConnection {
    private final TransactionManager transactionManager;
    private final DatasetGraphTDB baseDSG;
    private boolean isValid = true;
    private volatile boolean haveUsedInTransaction = false;
    private static Map<Location, StoreConnection> cache = new HashMap<Location, StoreConnection>();

    private StoreConnection(DatasetGraphTDB dsg) {
        this.baseDSG = dsg;
        this.transactionManager = new TransactionManager(this.baseDSG);
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void checkValid() {
        if (!this.isValid) {
            throw new TDBTransactionException("StoreConnection inValid (issued before a StoreConnection.release?)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTransactional() {
        if (!this.haveUsedInTransaction) {
            StoreConnection storeConnection = this;
            synchronized (storeConnection) {
                if (!this.haveUsedInTransaction) {
                    this.baseDSG.sync();
                }
                this.haveUsedInTransaction = true;
            }
        }
    }

    public boolean haveUsedInTransaction() {
        return this.haveUsedInTransaction;
    }

    public Location getLocation() {
        this.checkValid();
        return this.baseDSG.getLocation();
    }

    public SysTxnState getTransMgrState() {
        this.checkValid();
        return this.transactionManager.state();
    }

    public DatasetGraphTxn begin(TxnType mode) {
        return this.begin(mode, null);
    }

    public DatasetGraphTxn begin(TxnType mode, String label) {
        this.checkValid();
        this.checkTransactional();
        this.haveUsedInTransaction = true;
        return this.transactionManager.begin(mode, label);
    }

    public DatasetGraphTDB getBaseDataset() {
        this.checkValid();
        return this.baseDSG;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void flush() {
        if (!this.haveUsedInTransaction()) {
            return;
        }
        this.checkValid();
        this.transactionManager.flush();
    }

    public boolean activeTransactions() {
        this.checkValid();
        return this.transactionManager.activeTransactions();
    }

    public void forceRecoverFromJournal() {
        JournalControl.recoverFromJournal(this.getBaseDataset().getConfig(), this.transactionManager.getJournal());
    }

    public void printJournal() {
        JournalControl.print(this.transactionManager.getJournal());
    }

    public static StoreConnection make(String location) {
        return StoreConnection.make(Location.create(location));
    }

    public static synchronized void reset() {
        Set<Location> x = Set.copyOf(cache.keySet());
        for (Location loc : x) {
            StoreConnection.expel(loc, true);
        }
        cache.clear();
        TDBMaker.resetCache();
    }

    public static synchronized void release(Location location) {
        StoreConnection.expel(location, false);
    }

    public static synchronized void expel(Location location, boolean force) {
        StoreConnection sConn = cache.get(location);
        if (sConn == null) {
            return;
        }
        TDBInternal.releaseDSG(location);
        if (!force && sConn.transactionManager.activeTransactions()) {
            throw new TDBTransactionException("Can't expel: Active transactions for location: " + location);
        }
        sConn.transactionManager.closedown();
        sConn.baseDSG.close();
        sConn.isValid = false;
        cache.remove(location);
        ChannelManager.release(sConn.transactionManager.getJournal().getFilename());
        if (SystemTDB.DiskLocationMultiJvmUsagePrevention) {
            if (location.getLock().isOwned()) {
                location.getLock().release();
            } else if (location.getLock().canLock()) {
                SystemTDB.errlog.warn("Location " + location.getDirectoryPath() + " was not locked, if another JVM accessed this location simultaneously data corruption may have occurred");
            }
        }
    }

    public static synchronized StoreConnection make(Location location, StoreParams params) {
        StoreConnection sConn = cache.get(location);
        if (sConn != null) {
            return sConn;
        }
        DatasetGraphTDB dsg = StoreConnection.build(location, params);
        sConn = StoreConnection._makeAndCache(dsg);
        return sConn;
    }

    private static DatasetGraphTDB build(Location location, StoreParams params) {
        return DatasetBuilderStd.create(location, params);
    }

    public static StoreConnection make(Location location) {
        return StoreConnection.make(location, null);
    }

    public static synchronized StoreConnection getExisting(Location location) {
        return cache.get(location);
    }

    private static StoreConnection _makeAndCache(DatasetGraphTDB dsg) {
        Location location = dsg.getLocation();
        StoreConnection sConn = cache.get(location);
        if (sConn == null) {
            LocationLock lock;
            sConn = new StoreConnection(dsg);
            if (SystemTDB.DiskLocationMultiJvmUsagePrevention && (lock = location.getLock()).canLock()) {
                if (!lock.canObtain()) {
                    int here = ProcessUtils.getPid(0);
                    throw new TDB1Exception("Process ID " + here + " can't open database at location " + location.getDirectoryPath() + " because it is already locked by the process with PID " + lock.getOwner() + ". TDB databases do not permit concurrent usage across JVMs so in order to prevent possible data corruption you cannot open this location from the JVM that does not own the lock for the dataset");
                }
                lock.obtain();
                if (!lock.isOwned()) {
                    int here = ProcessUtils.getPid(0);
                    throw new TDB1Exception("Process ID " + here + " failed to open database at location " + location.getDirectoryPath() + " because it is already locked by the process with PID " + lock.getOwner() + ". TDB databases do not permit concurrent usage across JVMs so in order to prevent possible data corruption you cannot open this location from the JVM that does not own the lock for the dataset");
                }
            }
            sConn.forceRecoverFromJournal();
            if (!location.isMemUnique()) {
                cache.put(location, sConn);
            }
        }
        return sConn;
    }

    public static StoreConnection createMemUncached() {
        DatasetGraphTDB dsg = DatasetBuilderStd.create(Location.mem(), null);
        return new StoreConnection(dsg);
    }
}

