/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput0.impl;

import java.util.BitSet;
import org.apache.jena.rdfxml.xmlinput0.ARPErrorNumbers;
import org.apache.jena.rdfxml.xmlinput0.impl.AbsXMLContext;
import org.apache.jena.rdfxml.xmlinput0.impl.QNameLexer;
import org.apache.jena.rdfxml.xmlinput0.impl.Taint;
import org.apache.jena.rdfxml.xmlinput0.states.Frame;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class AttributeLexer
extends QNameLexer
implements ARPErrorNumbers {
    String lang;
    String base;
    public String about;
    public String datatype;
    public String resource;
    public String nodeID;
    public String id;
    public String type;
    public String parseType;
    public BitSet done;
    public int count;
    int index;
    Attributes att;
    AbsXMLContext xml;

    public AttributeLexer(Frame f, int which, int bad) {
        super(f, which, bad);
    }

    public int processSpecials(Taint taintMe, Attributes a) throws SAXParseException {
        this.att = a;
        int sz = a.getLength();
        this.done = new BitSet(sz);
        this.count = 0;
        this.index = 0;
        while (this.index < sz) {
            boolean matched = true;
            switch (this.lookup(taintMe)) {
                case 1: {
                    this.base = this.value();
                    this.frame.warning(null, 2, "Use of attribute xml:base is not envisaged in RDF Model&Syntax.");
                    break;
                }
                case 1024: 
                case 2048: 
                case 4096: 
                case 8192: 
                case 16384: {
                    break;
                }
                case 2: {
                    this.lang = this.value();
                    break;
                }
                case 4: 
                case 32768: {
                    break;
                }
                case 8: {
                    this.id = this.value(taintMe, this.id);
                    break;
                }
                case 32: {
                    this.nodeID = this.value(taintMe, this.nodeID);
                    break;
                }
                case 16: {
                    this.about = this.value(taintMe, this.about);
                    break;
                }
                case 64: {
                    this.resource = this.value(taintMe, this.resource);
                    break;
                }
                case 256: {
                    this.datatype = this.value(taintMe, this.datatype);
                    break;
                }
                case 512: {
                    this.type = this.value(taintMe, this.type);
                    break;
                }
                case 128: {
                    this.parseType = this.value(taintMe, this.parseType);
                    break;
                }
                case 0: {
                    String qn;
                    if ((this.select & 4) == 4 && ((qn = this.getQName()).length() >= 3 && qn.substring(0, 3).equalsIgnoreCase("xml") || xmlns.equals(this.getUri()))) {
                        if ("http://www.w3.org/2000/xmlns/".equals(this.getUri())) break;
                        this.frame.warning(null, 118, "XML attribute: " + this.getQName() + " is not known and is being discarded.");
                        break;
                    }
                    matched = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("impossible");
                }
            }
            if (matched) {
                this.done.set(this.index);
                ++this.count;
            }
            ++this.index;
        }
        this.xml = this.computeXml(this.frame.getXMLContext());
        return this.count;
    }

    public AbsXMLContext xml(AbsXMLContext in) throws SAXParseException {
        if (this.xml == null) {
            this.xml = this.computeXml(in);
        }
        return this.xml;
    }

    private AbsXMLContext computeXml(AbsXMLContext in) throws SAXParseException {
        if (this.base != null) {
            in = in.withBase(this.frame.arp, this.base);
        }
        if (this.lang != null) {
            in = in.withLang(this.frame.arp, this.lang);
        }
        return in;
    }

    @Override
    boolean isInRdfns(Taint taintMe) throws SAXParseException {
        String uri = this.getUri();
        if (rdfns.equals(uri)) {
            return true;
        }
        if (uri.equals("")) {
            this.frame.warning(taintMe, 102, "unqualified use of rdf:" + this.getQName() + " is deprecated.");
            return true;
        }
        return false;
    }

    @Override
    void error(Taint taintMe, int r) throws SAXParseException {
        int e2 = 201;
        switch (r) {
            case 1024: 
            case 2048: 
            case 4096: 
            case 8192: 
            case 16384: {
                e2 = 206;
            }
        }
        this.frame.warning(taintMe, e2, this.getQName() + " not allowed as attribute" + (e2 == 206 ? "." : " here."));
    }

    @Override
    void deprecatedAttribute(Taint me, int r) throws SAXParseException {
        this.frame.warning(me, 206, this.getQName() + " has been deprecated.");
    }

    @Override
    String getLocalName() {
        return this.att.getLocalName(this.index);
    }

    @Override
    String getUri() {
        return this.att.getURI(this.index);
    }

    private String value() {
        return this.att.getValue(this.index);
    }

    public String getXMLBase() {
        return this.base;
    }

    private String value(Taint taintMe, String prev) throws SAXParseException {
        if (prev != null) {
            this.frame.warning(taintMe, 201, "Cannot use " + this.getQName() + " in both qualified and unqualifed form on same element");
        }
        return this.att.getValue(this.index);
    }

    @Override
    String getQName() {
        return this.att.getQName(this.index);
    }

    public boolean done(int i) {
        return this.done.get(i);
    }

    @Override
    void bagIDAttribute(Taint taintMe, int rslt) throws SAXParseException {
        this.deprecatedAttribute(null, rslt);
    }
}

