/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.json;

import com.apicatalog.jsonld.json.JsonUtils;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public final class JsonLdComparison {
    private JsonLdComparison() {
    }

    public static final boolean equals(JsonValue value1, JsonValue value2) {
        return JsonLdComparison.equals(value1, value2, null);
    }

    private static final boolean equals(JsonValue value1, JsonValue value2, String parentProperty) {
        if (JsonUtils.isNull(value1) && JsonUtils.isNull(value2)) {
            return true;
        }
        if (JsonUtils.isScalar(value1) && JsonUtils.isScalar(value2)) {
            return Objects.equals(value1, value2);
        }
        if (JsonUtils.isArray(value1) && JsonUtils.isArray(value2)) {
            return JsonLdComparison.arrayEquals(value1.asJsonArray(), value2.asJsonArray(), parentProperty);
        }
        if (JsonUtils.isObject(value1) && JsonUtils.isObject(value2)) {
            return JsonLdComparison.objectEquals(value1.asJsonObject(), value2.asJsonObject());
        }
        return false;
    }

    private static final boolean objectEquals(JsonObject object1, JsonObject object2) {
        if (object1.size() != object2.size()) {
            return false;
        }
        for (Map.Entry entry1 : object1.entrySet()) {
            if (!object2.containsKey(entry1.getKey())) {
                return false;
            }
            if (JsonLdComparison.equals((JsonValue)entry1.getValue(), (JsonValue)object2.get(entry1.getKey()), (String)entry1.getKey())) continue;
            return false;
        }
        return true;
    }

    private static final boolean arrayEquals(JsonArray array1, JsonArray array2, String parentProperty) {
        if (array1.size() != array2.size()) {
            return false;
        }
        if (array1.isEmpty()) {
            return true;
        }
        if ("@list".equals(parentProperty)) {
            for (int i = 0; i < array1.size(); ++i) {
                if (JsonLdComparison.equals((JsonValue)array1.get(i), (JsonValue)array2.get(i))) continue;
                return false;
            }
            return true;
        }
        return JsonLdComparison.arraysEqualsUnordered(array1, array2);
    }

    private static final boolean arraysEqualsUnordered(JsonArray array1, JsonArray array2) {
        if (array1.size() != array2.size()) {
            return false;
        }
        if (array1.isEmpty()) {
            return true;
        }
        ArrayList<JsonValue> remaining = new ArrayList<JsonValue>(array2);
        for (JsonValue item1 : array1) {
            boolean found = false;
            for (JsonValue item2 : remaining) {
                found = JsonLdComparison.equals(item1, item2);
                if (!found) continue;
                remaining.remove(item2);
                break;
            }
            if (found) continue;
            return false;
        }
        return remaining.isEmpty();
    }
}

