/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaBuilder;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Alias;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Client3
extends Util {
    public static void main(String[] args) {
        Client3 theTests = new Client3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetIntIllegalArgumentExceptionTest() throws Exception {
        boolean pass;
        block8: {
            pass = false;
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            if (cquery != null) {
                this.logTrace("Obtained Non-null Criteria Query");
                Root customer = cquery.from(Customer.class);
                EntityType Customer_ = customer.getModel();
                this.logTrace("Use Tuple Query");
                cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
                TypedQuery tq = this.getEntityManager().createQuery(cquery);
                List result = tq.getResultList();
                Iterator iterator = result.iterator();
                if (iterator.hasNext()) {
                    Tuple t = (Tuple)iterator.next();
                    this.logMsg("Testing invalid index");
                    try {
                        t.get(99);
                        this.logErr("Did not get expected IllegalArgumentException for invalid index:" + t.get(99));
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Got expected IllegalArgumentException");
                        if (!this.getEntityTransaction().getRollbackOnly()) {
                            pass = true;
                            break block8;
                        }
                        this.logErr("Transaction was marked for rollback and should not have been");
                    }
                    catch (Exception ex) {
                        this.logErr("Received unexpected exception", ex);
                    }
                }
            } else {
                this.logErr("Failed to get Non-null Criteria Query");
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("tupleGetIntIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetElementsGetTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            this.logTrace("Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get(Customer_.getSingularAttribute("name", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            for (Tuple t : result) {
                String expId = (String)t.get("ID");
                String expName = (String)t.get("NAME");
                this.logTrace("Received:" + expId + ", " + expName);
                List lte = t.getElements();
                for (TupleElement te : lte) {
                    String alias = te.getAlias();
                    String type = te.getJavaType().getName();
                    if (alias.equals("ID")) {
                        String actId = (String)t.get(te);
                        if (actId.equals(expId)) {
                            this.logTrace("Received expected id:" + actId);
                            pass1 = true;
                        } else {
                            this.logErr("Expected id:" + expId + ", actual:|" + actId + "|");
                        }
                        if (type.equals("java.lang.String")) {
                            pass2 = true;
                            this.logTrace("Received expected Java Type for ID:" + type);
                            continue;
                        }
                        this.logErr("Expected java type of ID: java.lang.String, actual:|" + type + "|");
                        continue;
                    }
                    if (alias.equals("NAME")) {
                        String actName = (String)t.get(te);
                        if (actName.equals(expName)) {
                            this.logTrace("Received expected name:" + actName);
                            pass3 = true;
                        } else {
                            this.logErr("Expected name:|" + expName + "|, actual:|" + actName + "|");
                        }
                        if (type.equals("java.lang.String")) {
                            this.logTrace("Received expected Java Type for NAME:" + type);
                            pass4 = true;
                            continue;
                        }
                        this.logErr("Expected java type of NAME: java.lang.String, actual:|" + type + "|");
                        continue;
                    }
                    this.logErr("Received unexpected TupleElement:" + alias);
                }
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("tupleGetElementsGetTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetStringTest() throws Exception {
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            this.logTrace("Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Tuple t : result) {
                Integer id = Integer.valueOf((String)t.get(0));
                String name = (String)t.get(1);
                if (name != null) {
                    if (this.customerRef[id - 1].getName().equals(name)) {
                        actual.add(id);
                        continue;
                    }
                    this.logErr("Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|");
                    pass1 = false;
                    continue;
                }
                if (this.customerRef[id - 1].getName() == null) {
                    actual.add(id);
                    continue;
                }
                this.logErr("Expected name:" + this.customerRef[id - 1].getName() + ", actual:null");
                pass1 = false;
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("tupleGetStringTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass;
        block7: {
            pass = false;
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            if (cquery != null) {
                this.logTrace("Obtained Non-null Criteria Query");
                Root customer = cquery.from(Customer.class);
                EntityType Customer_ = customer.getModel();
                this.logTrace("Use Tuple Query");
                cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
                cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1"));
                TypedQuery tq = this.getEntityManager().createQuery(cquery);
                List result = tq.getResultList();
                Tuple t = (Tuple)result.get(0);
                this.logMsg("Testing valid alias");
                this.logTrace("value:" + t.get("NAME"));
                this.logMsg("Testing invalid alias");
                try {
                    t.get("doesnotexist");
                    this.logErr("Did not get expected IllegalArgumentException for TupleElement:t.get(\"doesnotexist\")");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Got expected IllegalArgumentException");
                    if (!this.getEntityTransaction().getRollbackOnly()) {
                        pass = true;
                        break block7;
                    }
                    this.logErr("Transaction was marked for rollback and should not have been");
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception:" + e);
                }
            } else {
                this.logErr("Failed to get Non-null Criteria Query");
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("tupleGetStringIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            this.logTrace("Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            Tuple t = (Tuple)result.get(0);
            this.logMsg("Testing valid index");
            this.logTrace("value:" + t.get("NAME"));
            this.logMsg("Testing a name that does not exist");
            try {
                t.get("doesnotexist", String.class);
                this.logErr("Did not throw IllegalArgumentException for TupleElement: t.get(\"doesnotexist\", String.class)");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Got expected IllegalArgumentException");
                if (!this.getEntityTransaction().getRollbackOnly()) {
                    pass1 = true;
                } else {
                    this.logErr("Transaction was marked for rollback and should not have been");
                }
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception:" + e);
            }
            this.logMsg("Testing invalid type");
            try {
                t.get("ID", Date.class);
                this.logErr("Did not throw IllegalArgumentException for TupleElement:t.get(\"ID\", Date.class)");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Got expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception:" + e);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("tupleGetStringClassIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetStringClassTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            this.logTrace("Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            pass1 = true;
            for (Tuple t : result) {
                Integer id = Integer.valueOf((String)t.get(0));
                String name = (String)t.get(1);
                if (name != null) {
                    if (this.customerRef[id - 1].getName().equals(name)) {
                        actual.add(id);
                        continue;
                    }
                    this.logErr("Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|");
                    pass2 = false;
                    continue;
                }
                if (this.customerRef[id - 1].getName() == null) {
                    actual.add(id);
                    continue;
                }
                this.logErr("Expected name:" + this.customerRef[id - 1].getName() + ", actual:null");
                pass2 = false;
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass3 = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("tupleGetStringClassTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleElementGetAliasTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            this.logTrace("Use Tuple Query");
            Path idPath = customer.get(Customer_.getSingularAttribute("id", String.class));
            String id = idPath.alias("IDID").getAlias();
            if (id.equals("IDID")) {
                this.logTrace("id=" + id);
                pass1 = true;
            } else {
                this.logErr("Expected id value:IDID, actual value:" + id);
            }
            Bindable b = idPath.getModel();
            Bindable.BindableType bbt = b.getBindableType();
            if (bbt.equals((Object)Bindable.BindableType.SINGULAR_ATTRIBUTE)) {
                this.logTrace("Received expected model:" + bbt.name());
                pass2 = true;
            } else {
                this.logErr("Expected model:" + Bindable.BindableType.SINGULAR_ATTRIBUTE.name() + ", actual:" + bbt.name());
            }
            Path p = idPath.getParentPath();
            Class parent = p.getJavaType();
            if (parent.getName().equals(Customer.class.getName())) {
                this.logTrace("Received expected parent:" + parent.getName());
                pass3 = true;
            } else {
                this.logErr("Expected parent class:" + Customer.class.getName() + ", actual:" + parent.getName());
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("tupleElementGetAliasTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void isEmpty() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[5].getId(), this.customerRef[14].getId(), this.customerRef[15].getId(), this.customerRef[16].getId(), this.customerRef[17].getId(), this.customerRef[18].getId(), this.customerRef[19].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isEmpty((Expression)customer.get("aliases")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isEmpty test failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void isNotEmpty() throws Exception {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[13];
        for (int i = 0; i < 14; ++i) {
            if (i == 5) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotEmpty((Expression)customer.get("aliases")));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isNotEmpty test failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void sizeCollectionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)cbuilder.size((Expression)customer.get("aliases")));
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("id"), (Object)"3"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedSize = 2;
            if (result.intValue() == expectedSize.intValue()) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("test returned:" + result + "expected: " + expectedSize);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("sizeCollectionTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void sizeExpTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            Path aliases = customer.get("aliases");
            cquery.select((Selection)cbuilder.size((Expression)aliases));
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("id"), (Object)"3"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedSize = 2;
            if (result.intValue() == expectedSize.intValue()) {
                this.logTrace("Successfully returned expected results:" + result);
                pass = true;
            } else {
                this.logErr("Expected: " + expectedSize + ", actual:" + result);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("sizeExpTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void isMember() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cqa = cbuilder.createQuery(Alias.class);
        Root aliasRoot = cqa.from(Alias.class);
        cqa = cqa.where((Expression)cbuilder.equal((Expression)aliasRoot.get("alias"), (Object)"aef"));
        Alias alias = (Alias)this.getEntityManager().createQuery(cqa).getSingleResult();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isMember((Object)alias, (Expression)customer.get("aliases")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            if (result.size() == 1) {
                if (((Customer)result.get(0)).equals((Object)this.customerRef[0])) {
                    this.logTrace("Successfully returned expected results" + result.toString());
                    pass = true;
                } else {
                    this.logErr("expected customer:" + this.customerRef[0].toString());
                    this.logErr("actual customer:" + result.toString());
                }
            } else {
                this.logErr("Expected number customers: 1, actual:" + result.size());
                for (Customer c : result) {
                    this.logErr("Received customer:" + c.toString());
                }
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isMember test failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void isNotMember() throws Exception {
        boolean pass = false;
        String[] expected = new String[30];
        for (int i = 0; i < 30; ++i) {
            expected[i] = this.aliasRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.isNotMember((Expression)alias.get("customerNoop"), (Expression)alias.get("customersNoop")));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isNotMember test failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void expressionAliasTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            EntityType Customer_;
            Root customer = cquery.from(Customer.class);
            Path idPath = customer.get((Customer_ = customer.getModel()).getSingularAttribute("id", String.class));
            String id = idPath.alias("IDID").getAlias();
            if (id.equals("IDID")) {
                this.logTrace("id=" + id);
                pass = true;
            } else {
                this.logErr("Expected id value:IDID, actual value:" + id);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        if (!pass) {
            throw new Exception("expressionAliasTest failed");
        }
    }
}

