/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding.convert.impl;

import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.krazo.binding.convert.ConverterResult;
import org.eclipse.krazo.binding.convert.impl.NumberConverter;

public class ShortConverter
extends NumberConverter<Short> {
    @Override
    public boolean supports(Class<Short> rawType, Annotation[] annotations) {
        return Short.class.equals(rawType) || Short.TYPE.equals(rawType);
    }

    @Override
    public ConverterResult<Short> convert(String value, Class<Short> rawType, Annotation[] annotations, Locale locale) {
        Short defaultValue = Short.TYPE.equals(rawType) ? Short.valueOf((short)0) : null;
        try {
            return ConverterResult.success(this.parseNumber(value, locale).map(Number::shortValue).orElse(defaultValue));
        }
        catch (ParseException e) {
            return ConverterResult.failed(defaultValue, e.getMessage());
        }
    }
}

