/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.resource.ResourceBundleManager;
import com.sun.jsftemplating.util.Util;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.hk2.api.ServiceLocator;

public class GuiUtil {
    public static final String I18N_RESOURCE_BUNDLE = "__i18n_resource_bundle";
    public static final String RESOURCE_NAME = "org.glassfish.admingui.core.Strings";
    public static final String COMMON_RESOURCE_NAME = "org.glassfish.common.admingui.Strings";
    public static final String LOGGER_NAME = "org.glassfish.admingui";
    public static final Locale guiLocale = new Locale("UTF-8");

    public static Logger getLogger() {
        return Logger.getLogger(LOGGER_NAME);
    }

    public static void guiLog(HandlerContext handlerCtx) {
        String level = (String)handlerCtx.getInputValue("level");
        level = level == null ? "INFO" : level.toUpperCase(guiLocale);
        GuiUtil.getLogger().log(Level.parse(level), (String)handlerCtx.getInputValue("message"));
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static String getCommonMessage(String key, Object[] args) {
        return GuiUtil.getMessage(COMMON_RESOURCE_NAME, key, args);
    }

    public static String getMessage(String resourceName, String key, Object[] args) {
        return GuiUtil.formatMessage(GuiUtil.getMessage(resourceName, key), args);
    }

    public static String getMessage(String key, Object[] args) {
        if (key == null) {
            return null;
        }
        String value = GuiUtil.getMessage(key);
        return GuiUtil.formatMessage(GuiUtil.getMessage(value), args);
    }

    private static String formatMessage(String msg, Object[] args) {
        if (args != null) {
            MessageFormat mf = new MessageFormat(msg);
            msg = mf.format(args);
        }
        return msg;
    }

    public static void initSessionAttributes() {
        Logger logger;
        block18: {
            Object request;
            logger = GuiUtil.getLogger();
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, GuiUtil.getCommonMessage("LOG_INIT_SESSION"));
            }
            ExternalContext externalCtx = FacesContext.getCurrentInstance().getExternalContext();
            Map sessionMap = externalCtx.getSessionMap();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.INFO, "SessionMap from externalCtx: " + sessionMap.toString());
            }
            if ((request = externalCtx.getRequest()) instanceof ServletRequest) {
                ServletRequest srequest = (ServletRequest)request;
                sessionMap.put("hostName", srequest.getServerName());
                String restServerName = (String)sessionMap.get("serverName");
                if (restServerName == null) {
                    throw new IllegalStateException("REST Server Name not set!");
                }
                int port = (Integer)sessionMap.get("serverPort");
                sessionMap.put("requestIsSecured", srequest.isSecure());
                sessionMap.put("REST_URL", "http" + (srequest.isSecure() ? "s" : "") + "://" + restServerName + ":" + port + "/management/domain");
                sessionMap.put("MONITOR_URL", "http" + (srequest.isSecure() ? "s" : "") + "://" + restServerName + ":" + port + "/monitoring/domain");
            } else {
                sessionMap.put("hostName", "");
            }
            String domainName = RestUtil.getPropValue((String)sessionMap.get("REST_URL"), "administrative.domain.name", null);
            sessionMap.put("domainName", domainName);
            sessionMap.put("localhostNodeName", "localhost-" + domainName);
            sessionMap.put("_noNetwork", System.getProperty("com.sun.enterprise.tools.admingui.NO_NETWORK", "false").equals("true") ? Boolean.TRUE : Boolean.FALSE);
            sessionMap.put("supportCluster", Boolean.FALSE);
            Map<String, Object> version = RestUtil.restRequest(String.valueOf(sessionMap.get("REST_URL")) + "/version", null, "GET", null, false);
            sessionMap.put("appServerVersion", ((Map)version.get("data")).get("message"));
            Map<String, Object> locations = RestUtil.restRequest(String.valueOf(sessionMap.get("REST_URL")) + "/locations", null, "GET", null, false);
            String installDir = (String)((Map)((Map)locations.get("data")).get("properties")).get("Base-Root");
            sessionMap.put("baseRootDir", installDir);
            sessionMap.put("topDir", new File(installDir).getParent());
            Map<String, Object> runtimeInfoMap = RestUtil.restRequest(String.valueOf(sessionMap.get("REST_URL")) + "/get-runtime-info", null, "GET", null, false);
            String debugFlag = (String)((Map)((Map)runtimeInfoMap.get("data")).get("properties")).get("debug");
            if ("true".equals(debugFlag)) {
                String debugPort = (String)((Map)((Map)runtimeInfoMap.get("data")).get("properties")).get("debugPort");
                sessionMap.put("debugInfo", GuiUtil.getMessage("inst.debugEnabled") + debugPort);
            } else {
                sessionMap.put("debugInfo", GuiUtil.getMessage("inst.notEnabled"));
            }
            try {
                Map secureAdminAttrs = RestUtil.getAttributesMap(String.valueOf(sessionMap.get("REST_URL")) + "/secure-admin");
                if (Boolean.parseBoolean((String)secureAdminAttrs.get("enabled"))) {
                    sessionMap.put("secureAdminEnabled", "true");
                } else {
                    sessionMap.put("secureAdminEnabled", "false");
                }
            }
            catch (Exception ex) {
                sessionMap.put("secureAdminEnabled", "false");
            }
            sessionMap.put("reqMsg", GuiUtil.getMessage("msg.JS.enterValue"));
            sessionMap.put("reqMsgSelect", GuiUtil.getMessage("msg.JS.selectValue"));
            sessionMap.put("reqInt", GuiUtil.getMessage("msg.JS.enterIntegerValue"));
            sessionMap.put("reqNum", GuiUtil.getMessage("msg.JS.enterNumericValue"));
            sessionMap.put("reqPort", GuiUtil.getMessage("msg.JS.enterPortValue"));
            sessionMap.put("_SESSION_INITIALIZED", "TRUE");
            sessionMap.put("restartRequired", Boolean.FALSE);
            try {
                Map<String, Object> result = RestUtil.restRequest(String.valueOf(GuiUtil.getSessionValue("REST_URL")) + "/configs/config/server-config/admin-service/das-config", null, "GET", null, false);
                String timeOut = (String)((Map)((Map)((Map)result.get("data")).get("extraProperties")).get("entity")).get("adminSessionTimeoutInMinutes");
                if (timeOut != null && !timeOut.equals("")) {
                    int time = Integer.parseInt(timeOut);
                    if (time == 0) {
                        ((HttpServletRequest)request).getSession().setMaxInactiveInterval(-1);
                    } else {
                        ((HttpServletRequest)request).getSession().setMaxInactiveInterval(time * 60);
                    }
                }
            }
            catch (Exception nfe) {
                ((HttpServletRequest)request).getSession().setMaxInactiveInterval(-1);
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.initSession") + nfe.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block18;
                nfe.printStackTrace();
            }
        }
        try {
            GuiUtil.setTimeStamp();
        }
        catch (Exception ex) {
            logger.log(Level.FINE, ex.getMessage());
        }
    }

    private static File getTimeStampFile() {
        Map<String, Object> result = RestUtil.restRequest(String.valueOf(GuiUtil.getSessionValue("REST_URL")) + "/locations", null, "GET", null, false);
        String configDir = (String)((Map)((Map)result.get("data")).get("properties")).get("Config-Dir");
        if (configDir != null) {
            return new File(configDir, ".consolestate");
        }
        return null;
    }

    public static void setTimeStamp() throws Exception {
        File f = GuiUtil.getTimeStampFile();
        if (!f.createNewFile()) {
            f.setLastModified(System.currentTimeMillis());
        }
    }

    public static long getTimeStamp() throws Exception {
        File f = GuiUtil.getTimeStampFile();
        if (f == null) {
            throw new Exception("Could not get TimeStamp file for admin console");
        }
        if (!f.exists()) {
            return 0L;
        }
        return f.lastModified();
    }

    public static void setSessionValue(String key, Object value) {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        sessionMap.put(key, value);
    }

    public static Object getSessionValue(String key) {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        if (sessionMap.get("_SESSION_INITIALIZED") == null) {
            GuiUtil.initSessionAttributes();
        }
        return sessionMap.get(key);
    }

    public static String encode(String value, String delim, String type) {
        if (value == null || value.equals("")) {
            return value;
        }
        if (type == null || type.equals("")) {
            type = "UTF-8";
        }
        Object encdString = "";
        if (delim != null && delim.length() > 0) {
            StringTokenizer st = new StringTokenizer(value, delim, true);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (delim.indexOf(s) >= 0) {
                    encdString = ((String)encdString).concat(s);
                    continue;
                }
                try {
                    encdString = (String)encdString + URLEncoder.encode(s, type);
                }
                catch (UnsupportedEncodingException uex) {
                    try {
                        encdString = (String)encdString + URLEncoder.encode(s, "UTF-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
        } else {
            try {
                encdString = URLEncoder.encode(value, type);
            }
            catch (UnsupportedEncodingException uex) {
                try {
                    encdString = (String)encdString + URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        }
        return encdString;
    }

    public static String genId(String uid) {
        char[] chArr = uid.toCharArray();
        int len = chArr.length;
        int newIdx = 0;
        for (int idx = 0; idx < len; ++idx) {
            int test = chArr[idx];
            chArr[newIdx++] = Character.isLetterOrDigit((char)test) || test == 95 || test == 45 ? test : 95;
        }
        Object result = new String(chArr, 0, newIdx);
        if (!Character.isLetter(chArr[0]) && chArr[0] != '_') {
            result = "_" + (String)result;
        }
        return result;
    }

    public static ResourceBundle getBundle(String resourceName) {
        Locale locale = Util.getLocale((FacesContext)FacesContext.getCurrentInstance());
        return ResourceBundleManager.getInstance().getBundle(resourceName, locale);
    }

    public static String getMessage(String key) {
        try {
            Locale locale = Util.getLocale((FacesContext)FacesContext.getCurrentInstance());
            ResourceBundle bundle = ResourceBundleManager.getInstance().getBundle(RESOURCE_NAME, locale);
            return bundle.getString(key);
        }
        catch (NullPointerException ex) {
            return key;
        }
        catch (Exception ex1) {
            return key;
        }
    }

    public static String getCommonMessage(String key) {
        return GuiUtil.getMessage(COMMON_RESOURCE_NAME, key);
    }

    public static String getMessage(String resourceName, String key) {
        try {
            return GuiUtil.getBundle(resourceName).getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String getMessage(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static Locale getLocale() {
        Locale locale = Util.getLocale((FacesContext)FacesContext.getCurrentInstance());
        return locale;
    }

    public static void prepareSuccessful(HandlerContext handlerCtx) {
        GuiUtil.prepareAlert("success", GuiUtil.getMessage("msg.saveSuccessful"), null);
    }

    public static void prepareException(HandlerContext handlerCtx, Throwable ex) {
        Throwable rootException = GuiUtil.getRootCause(ex);
        GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), rootException.getClass().getSimpleName() + ": " + rootException.getMessage());
        GuiUtil.getLogger().info(GuiUtil.getCommonMessage("LOG_EXCEPTION_OCCURED") + ex.getLocalizedMessage());
        if (GuiUtil.getLogger().isLoggable(Level.FINE)) {
            ex.printStackTrace();
        }
    }

    public static void prepareAlert(String type, String summary, String detail) {
        block6: {
            try {
                Map attrMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
                if (GuiUtil.isEmpty(type)) {
                    attrMap.put("alertType", "information");
                } else {
                    if (!(type.equals("information") || type.equals("success") || type.equals("warning") || type.equals("error"))) {
                        throw new RuntimeException("GuiUtil:prepareMessage():  type specified is not a valid type");
                    }
                    attrMap.put("alertType", type);
                }
                if (detail != null && ((String)detail).length() > 1000) {
                    detail = ((String)detail).substring(0, 1000) + " .... " + GuiUtil.getMessage("msg.seeServerLog");
                }
                attrMap.put("alertDetail", GuiUtil.isEmpty((String)detail) ? "" : URLEncoder.encode((String)detail, "UTF-8"));
                attrMap.put("alertSummary", GuiUtil.isEmpty(summary) ? "" : URLEncoder.encode(summary, "UTF-8"));
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.prepareAlert") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block6;
                ex.printStackTrace();
            }
        }
    }

    public static void handleException(HandlerContext handlerCtx, Throwable ex) {
        GuiUtil.prepareException(handlerCtx, ex);
        handlerCtx.getFacesContext().renderResponse();
    }

    public static void handleError(HandlerContext handlerCtx, String detail) {
        GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), detail);
        handlerCtx.getFacesContext().renderResponse();
    }

    public static String notNull(String test) {
        return test == null ? "" : test;
    }

    public static List<String> convertListOfStrings(List l) {
        ArrayList<String> arrList = new ArrayList<String>();
        for (Object o : l) {
            arrList.add(o.toString());
        }
        return arrList;
    }

    public static List parseStringList(String line, String sep) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (line == null) {
            return tokens;
        }
        StringTokenizer st = sep == null ? new StringTokenizer(line) : new StringTokenizer(line, sep);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String removeToken(String line, String sep, String remove) {
        StringTokenizer st;
        if (line == null) {
            return null;
        }
        if (sep == null) {
            st = new StringTokenizer(line);
        } else {
            sep = sep.trim();
            st = new StringTokenizer(line, sep);
        }
        Object result = "";
        boolean start = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0 || token.equals(remove)) continue;
            if (start) {
                result = token;
                start = false;
                continue;
            }
            result = (String)result + sep + token;
        }
        return result;
    }

    public static String[] stringToArray(String str, String delimiter) {
        String[] retString = new String[]{};
        if (str != null) {
            if (delimiter == null) {
                delimiter = " ";
            }
            StringTokenizer tokens = new StringTokenizer(str, delimiter);
            retString = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                retString[i++] = token;
            }
        }
        return retString;
    }

    public static String arrayToString(String[] str, String delimiter) {
        StringBuffer retStr = new StringBuffer();
        if (str != null) {
            for (int i = 0; i < str.length; ++i) {
                String element = str[i];
                retStr.append(element);
                if (i >= str.length - 1) continue;
                retStr.append(delimiter);
            }
        }
        return retStr.toString();
    }

    public static String listToString(List<String> list, String delimiter) {
        StringBuffer retStr = new StringBuffer();
        if (list == null || list.size() <= 0) {
            return "";
        }
        for (String oneItem : list) {
            retStr.append(oneItem);
            retStr.append(delimiter);
        }
        String ret = retStr.toString();
        ret = ret.substring(0, ret.length() - 1);
        return ret;
    }

    public static <T> T[] asArray(Object o) {
        return (Object[])Object[].class.cast(o);
    }

    public static boolean isSelected(String name, List<Map> selectedList) {
        if (selectedList == null || name == null) {
            return false;
        }
        for (Map oneRow : selectedList) {
            if (!name.equals(oneRow.get("name"))) continue;
            return true;
        }
        return false;
    }

    public static String checkEmpty(String test) {
        if (test == null) {
            return "";
        }
        return test;
    }

    public static Boolean getBooleanValue(Map pMap, String name) {
        if (pMap.get(name) == null) {
            return Boolean.FALSE;
        }
        Object val = pMap.get(name);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return Boolean.valueOf(String.valueOf(val));
    }

    public static ServiceLocator getHabitat() {
        ServletContext servletCtx = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
        ServiceLocator habitat = (ServiceLocator)servletCtx.getAttribute("org.glassfish.servlet.habitat");
        return habitat;
    }

    public static List<Map<String, Object>> convertArrayToListOfMap(Object[] values, String key) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (values != null) {
            HashMap<String, Object> map = null;
            for (Object val : values) {
                map = new HashMap<String, Object>();
                map.put(key, val);
                map.put("selected", false);
                list.add(map);
            }
        }
        return list;
    }

    public static List<Map<String, String>> convertMapToListOfMap(Map<String, String> values) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (values != null) {
            for (Map.Entry<String, String> e : values.entrySet()) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                String value = e.getValue();
                String valString = value == null ? "" : value.toString();
                oneRow.put("name", e.getKey());
                oneRow.put("value", valString);
                oneRow.put("description", "");
                list.add(oneRow);
            }
        }
        return list;
    }

    public static Object getMapValue(Map map, String mapKeys) {
        int i;
        String[] keys = mapKeys.split(",");
        for (i = 0; i < keys.length - 1; ++i) {
            if ((map = (Map)map.get(keys[i])) != null) continue;
            return null;
        }
        return map.get(keys[i]);
    }

    public static Throwable[] getCauses(Throwable start) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        boolean haveNonException = false;
        Throwable t = start;
        while (t != null) {
            Throwable temp;
            list.add(t);
            if (!(t instanceof Exception)) {
                haveNonException = true;
            }
            if ((temp = t.getCause()) == null) break;
            t = temp;
        }
        Throwable[] results = haveNonException ? new Throwable[list.size()] : new Exception[list.size()];
        list.toArray(results);
        return results;
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable[] causes = GuiUtil.getCauses(e);
        return causes[causes.length - 1];
    }
}

