/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.tag.common.xml;

import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.eclipse.tags.shaded.org.apache.xml.utils.PrefixResolver;
import org.eclipse.tags.shaded.org.apache.xpath.XPath;
import org.eclipse.tags.shaded.org.apache.xpath.XPathContext;
import org.eclipse.tags.shaded.org.apache.xpath.jaxp.JAXPExtensionsProvider;
import org.eclipse.tags.shaded.org.apache.xpath.jaxp.JAXPPrefixResolver;
import org.eclipse.tags.shaded.org.apache.xpath.jaxp.JAXPVariableStack;
import org.eclipse.tags.shaded.org.apache.xpath.objects.XNodeSet;
import org.eclipse.tags.shaded.org.apache.xpath.objects.XObject;
import org.eclipse.tags.shaded.org.apache.xpath.res.XPATHMessages;
import org.glassfish.wasp.taglibs.standard.tag.common.xml.DocumentBuilderProvider;
import org.glassfish.wasp.taglibs.standard.tag.common.xml.JSTLXPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class JSTLXPathImpl
implements javax.xml.xpath.XPath {
    private final XPathVariableResolver origVariableResolver;
    private final XPathFunctionResolver origFunctionResolver;
    private XPathVariableResolver variableResolver;
    private XPathFunctionResolver functionResolver;
    private NamespaceContext namespaceContext;
    private JAXPPrefixResolver prefixResolver;
    private boolean featureSecureProcessing;

    JSTLXPathImpl(XPathVariableResolver vr, XPathFunctionResolver fr) {
        this.origVariableResolver = this.variableResolver = vr;
        this.origFunctionResolver = this.functionResolver = fr;
    }

    JSTLXPathImpl(XPathVariableResolver vr, XPathFunctionResolver fr, boolean featureSecureProcessing) {
        this.origVariableResolver = this.variableResolver = vr;
        this.origFunctionResolver = this.functionResolver = fr;
        this.featureSecureProcessing = featureSecureProcessing;
    }

    @Override
    public void reset() {
        this.variableResolver = this.origVariableResolver;
        this.functionResolver = this.origFunctionResolver;
        this.namespaceContext = null;
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver resolver) {
        if (resolver == null) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPathVariableResolver"});
            throw new NullPointerException(fmsg);
        }
        this.variableResolver = resolver;
    }

    @Override
    public XPathVariableResolver getXPathVariableResolver() {
        return this.variableResolver;
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver resolver) {
        if (resolver == null) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPathFunctionResolver"});
            throw new NullPointerException(fmsg);
        }
        this.functionResolver = resolver;
    }

    @Override
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.functionResolver;
    }

    @Override
    public void setNamespaceContext(NamespaceContext nsContext) {
        if (nsContext == null) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"NamespaceContext"});
            throw new NullPointerException(fmsg);
        }
        this.namespaceContext = nsContext;
        this.prefixResolver = new JAXPPrefixResolver(nsContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public XPathExpression compile(String expression) throws XPathExpressionException {
        if (expression == null) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPath expression"});
            throw new NullPointerException(fmsg);
        }
        return null;
    }

    @Override
    public Object evaluate(String expression, Object item, QName returnType) throws XPathExpressionException {
        if (expression == null) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPath expression"});
            throw new NullPointerException(fmsg);
        }
        if (returnType == null) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"returnType"});
            throw new NullPointerException(fmsg);
        }
        if (!this.isSupported(returnType)) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{returnType.toString()});
            throw new IllegalArgumentException(fmsg);
        }
        try {
            XObject resultObject = this.eval(expression, item);
            return this.getResultAsType(resultObject, returnType);
        }
        catch (NullPointerException npe) {
            throw new XPathExpressionException(npe);
        }
        catch (TransformerException te) {
            Throwable nestedException = te.getException();
            if (nestedException instanceof XPathFunctionException) {
                throw (XPathFunctionException)nestedException;
            }
            throw new XPathExpressionException(te);
        }
    }

    @Override
    public String evaluate(String expression, Object item) throws XPathExpressionException {
        return (String)this.evaluate(expression, item, XPathConstants.STRING);
    }

    @Override
    public Object evaluate(String expression, InputSource source, QName returnType) throws XPathExpressionException {
        if (source == null) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"source"});
            throw new NullPointerException(fmsg);
        }
        if (expression == null) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPath expression"});
            throw new NullPointerException(fmsg);
        }
        if (returnType == null) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"returnType"});
            throw new NullPointerException(fmsg);
        }
        if (!this.isSupported(returnType)) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{returnType.toString()});
            throw new IllegalArgumentException(fmsg);
        }
        try {
            Document document = DocumentBuilderProvider.createDocumentBuilder().parse(source);
            XObject resultObject = this.eval(expression, document);
            return this.getResultAsType(resultObject, returnType);
        }
        catch (SAXException e) {
            throw new XPathExpressionException(e);
        }
        catch (IOException e) {
            throw new XPathExpressionException(e);
        }
        catch (TransformerException te) {
            Throwable nestedException = te.getException();
            if (nestedException instanceof XPathFunctionException) {
                throw (XPathFunctionException)nestedException;
            }
            throw new XPathExpressionException(te);
        }
    }

    @Override
    public String evaluate(String expression, InputSource source) throws XPathExpressionException {
        return (String)this.evaluate(expression, source, XPathConstants.STRING);
    }

    private XObject eval(String expression, Object contextItem) throws TransformerException {
        XPathContext xpathSupport;
        XPath xpath = new XPath(expression, null, this.prefixResolver, 0);
        if (this.functionResolver != null) {
            JAXPExtensionsProvider jep = new JAXPExtensionsProvider(this.functionResolver, this.featureSecureProcessing);
            xpathSupport = new XPathContext(jep);
        } else {
            xpathSupport = new XPathContext();
        }
        xpathSupport.setVarStack(new JAXPVariableStack(this.variableResolver));
        if (contextItem instanceof Node) {
            return xpath.execute(xpathSupport, (Node)contextItem, (PrefixResolver)this.prefixResolver);
        }
        return xpath.execute(xpathSupport, -1, (PrefixResolver)this.prefixResolver);
    }

    private boolean isSupported(QName returnType) {
        return returnType.equals(XPathConstants.STRING) || returnType.equals(XPathConstants.NUMBER) || returnType.equals(XPathConstants.BOOLEAN) || returnType.equals(XPathConstants.NODE) || returnType.equals(XPathConstants.NODESET) || returnType.equals(JSTLXPathConstants.OBJECT);
    }

    private Object getResultAsType(XObject resultObject, QName returnType) throws TransformerException {
        if (returnType.equals(XPathConstants.STRING)) {
            return resultObject.str();
        }
        if (returnType.equals(XPathConstants.NUMBER)) {
            return resultObject.num();
        }
        if (returnType.equals(XPathConstants.BOOLEAN)) {
            return resultObject.bool();
        }
        if (returnType.equals(XPathConstants.NODESET)) {
            return resultObject.nodelist();
        }
        if (returnType.equals(XPathConstants.NODE)) {
            NodeIterator ni = resultObject.nodeset();
            return ni.nextNode();
        }
        if (returnType.equals(JSTLXPathConstants.OBJECT)) {
            if (resultObject instanceof XNodeSet) {
                return resultObject.nodelist();
            }
            return resultObject.object();
        }
        String fmsg = XPATHMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{returnType.toString()});
        throw new IllegalArgumentException(fmsg);
    }
}

