/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="delete-domain")
@PerLookup
public final class DeleteDomainCommand
extends LocalDomainCommand {
    @Param(name="domain_name", primary=true)
    private String domainName0;
    private static final LocalStringsImpl strings = new LocalStringsImpl(DeleteDomainCommand.class);
    private HostAndPort adminAddress;

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.domainName0);
        super.validate();
        this.adminAddress = super.getAdminAddress();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            DomainConfig domainConfig = new DomainConfig(this.getDomainName(), this.getDomainsDir().getPath());
            this.checkRunning();
            this.checkRename();
            PEDomainsManager manager = new PEDomainsManager();
            manager.deleteDomain(domainConfig);
        }
        catch (Exception e) {
            throw new CommandException(e.getLocalizedMessage());
        }
        logger.fine(strings.get("DomainDeleted", new Object[]{this.getDomainName()}));
        return 0;
    }

    private void checkRunning() throws CommandException {
        this.programOpts.setInteractive(false);
        if (this.isThisDAS(this.getDomainRootDir()) && ProcessUtils.isListening((HostAndPort)this.adminAddress)) {
            String msg = strings.get("domain.is.running", new Object[]{this.getDomainName(), this.getDomainRootDir()});
            throw new IllegalStateException(msg);
        }
    }

    private void checkRename() throws CommandException {
        boolean ok = true;
        try {
            File root = this.getDomainsDir();
            File domdir = new File(root, this.getDomainName());
            File tmpdir = File.createTempFile("del-", "", root);
            ok = tmpdir.delete() && domdir.renameTo(tmpdir) && tmpdir.renameTo(domdir);
        }
        catch (IOException ioe) {
            ok = false;
        }
        if (!ok) {
            String msg = strings.get("domain.fileinuse", new Object[]{this.getDomainName(), this.getDomainRootDir()});
            throw new IllegalStateException(msg);
        }
    }
}

