/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.CursorTableReference;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public class CursorNode
extends DMLStatementNode {
    static final int UNSPECIFIED = 0;
    public static final int READ_ONLY = 1;
    static final int UPDATE = 2;
    private String name;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;
    private String statementType;
    private int updateMode;
    private boolean needTarget;
    private List<String> updatableColumns;
    private FromTable updateTable;
    private ArrayList<TableDescriptor> statsToUpdate;
    private boolean checkIndexStats;
    private int indexOfSessionTableNamesInSavedObjects = -1;
    private boolean forMergeStatement;

    CursorNode(String string, ResultSetNode resultSetNode, String string2, OrderByList orderByList, ValueNode valueNode, ValueNode valueNode2, boolean bl, int n, String[] stringArray, boolean bl2, ContextManager contextManager) {
        super(resultSetNode, contextManager);
        this.name = string2;
        this.statementType = string;
        this.orderByList = orderByList;
        this.offset = valueNode;
        this.fetchFirst = valueNode2;
        this.hasJDBClimitClause = bl;
        this.updateMode = n;
        this.updatableColumns = stringArray == null ? null : Arrays.asList(stringArray);
        this.forMergeStatement = bl2;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        return this.statementType;
    }

    private static String updateModeString(int n) {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        int n;
        Iterable<ResultSetNode> iterable;
        boolean bl = this.getCompilerContext().skipTypePrivileges(true);
        DataDictionary dataDictionary = this.getDataDictionary();
        boolean bl2 = this.checkIndexStats = dataDictionary.getIndexStatsRefresher(true) != null;
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.resultSet);
        }
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        try {
            iterable = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
            this.resultSet.rejectParameters();
            super.bind(dataDictionary);
            this.resultSet.bindResultColumns((FromList)iterable);
            this.resultSet.bindUntypedNullsToResultColumns(null);
            if (!this.forMergeStatement) {
                this.resultSet.rejectXMLValues();
            }
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
        this.collectTablesWithPossiblyStaleStats();
        if (this.orderByList != null) {
            this.orderByList.bindOrderByColumns(this.resultSet);
        }
        CursorNode.bindOffsetFetch(this.offset, this.fetchFirst);
        if (this.updateMode == 2 && this.updateMode != (n = this.determineUpdateMode(dataDictionary))) {
            throw StandardException.newException("42Y90", new Object[0]);
        }
        if (this.updateMode == 0) {
            this.updateMode = this.getLanguageConnectionContext().getStatementContext().isForReadOnly() ? 1 : this.determineUpdateMode(dataDictionary);
        }
        if (this.updateMode == 1) {
            this.updatableColumns = null;
        }
        if (this.updateMode == 2) {
            this.bindUpdateColumns(this.updateTable);
            if (this.updateTable != null) {
                this.updateTable.markUpdatableByCursor(this.updatableColumns);
                this.resultSet.getResultColumns().markColumnsInSelectListUpdatableByCursor(this.updatableColumns);
            }
        }
        this.resultSet.renameGeneratedResultNames();
        if (this.getLanguageConnectionContext().checkIfAnyDeclaredGlobalTempTablesForThisConnection() && (iterable = this.getSessionSchemaTableNamesForCursor()) != null) {
            this.indexOfSessionTableNamesInSavedObjects = this.getCompilerContext().addSavedObject(iterable);
        }
        this.getCompilerContext().skipTypePrivileges(bl);
    }

    private void collectTablesWithPossiblyStaleStats() throws StandardException {
        if (!this.checkIndexStats) {
            return;
        }
        FromList fromList = this.resultSet.getFromList();
        for (int i = 0; i < fromList.size(); ++i) {
            TableDescriptor tableDescriptor;
            FromTable fromTable = (FromTable)fromList.elementAt(i);
            if (!fromTable.isBaseTable() || (tableDescriptor = fromTable.getTableDescriptor()).getTableType() != 0) continue;
            if (this.statsToUpdate == null) {
                this.statsToUpdate = new ArrayList();
            }
            this.statsToUpdate.add(tableDescriptor);
        }
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    protected ArrayList<String> getSessionSchemaTableNamesForCursor() throws StandardException {
        FromList fromList = this.resultSet.getFromList();
        int n = fromList.size();
        ArrayList<String> arrayList = null;
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)fromList.elementAt(i);
            if (!(fromTable instanceof FromBaseTable) || !this.isSessionSchema(fromTable.getTableDescriptor().getSchemaDescriptor())) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(fromTable.getTableName().getTableName());
        }
        return arrayList;
    }

    private int determineUpdateMode(DataDictionary dataDictionary) throws StandardException {
        if (this.updateMode == 1) {
            return 1;
        }
        if (this.orderByList != null) {
            return 1;
        }
        if (!this.resultSet.isUpdatableCursor(dataDictionary)) {
            return 1;
        }
        this.updateTable = this.resultSet.getCursorTargetTable();
        if (this.updateTable.markAsCursorTargetTable()) {
            this.needTarget = true;
        }
        return 2;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        this.resultSet.pushQueryExpressionSuffix();
        if (this.orderByList != null) {
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.resultSet.pushOrderByList(this.orderByList);
            this.orderByList = null;
        }
        this.resultSet.pushOffsetFetchFirst(this.offset, this.fetchFirst, this.hasJDBClimitClause);
        this.offset = null;
        this.fetchFirst = null;
        super.optimizeStatement();
    }

    @Override
    int activationKind() {
        return 4;
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.indexOfSessionTableNamesInSavedObjects != -1) {
            MethodBuilder methodBuilder2 = activationClassBuilder.getConstructor();
            methodBuilder2.pushThis();
            methodBuilder2.push(this.indexOfSessionTableNamesInSavedObjects);
            methodBuilder2.putField("org.apache.derby.impl.sql.execute.BaseActivation", "indexOfSessionTableNamesInSavedObjects", "int");
            methodBuilder2.endStatement();
        }
        this.generateParameterValueSet(activationClassBuilder);
        this.resultSet.markStatementResultSet();
        this.resultSet.generate(activationClassBuilder, methodBuilder);
        if (this.needTarget) {
            activationClassBuilder.rememberCursor(methodBuilder);
            activationClassBuilder.addCursorPositionCode();
        }
    }

    String getUpdateBaseTableName() {
        return this.updateTable == null ? null : this.updateTable.getBaseTableName();
    }

    String getUpdateExposedTableName() throws StandardException {
        return this.updateTable == null ? null : this.updateTable.getExposedName();
    }

    String getUpdateSchemaName() throws StandardException {
        return this.updateTable == null ? null : ((FromBaseTable)this.updateTable).getTableNameField().getSchemaName();
    }

    int getUpdateMode() {
        return this.updateMode;
    }

    @Override
    public boolean needsSavepoint() {
        return false;
    }

    @Override
    public Object getCursorInfo() throws StandardException {
        if (!this.needTarget) {
            return null;
        }
        return new CursorInfo(this.updateMode, new CursorTableReference(this.getUpdateExposedTableName(), this.getUpdateBaseTableName(), this.getUpdateSchemaName()), this.updatableColumns);
    }

    private void bindUpdateColumns(FromTable fromTable) throws StandardException {
        int n = this.updatableColumns.size();
        ResultColumnList resultColumnList = this.resultSet.getResultColumns();
        for (int i = 0; i < n; ++i) {
            String string = this.updatableColumns.get(i);
            TableDescriptor tableDescriptor = fromTable.getTableDescriptor();
            if (tableDescriptor.getColumnDescriptor(string) == null) {
                throw StandardException.newException("42X04", string);
            }
            for (ResultColumn resultColumn : resultColumnList) {
                if (resultColumn.getSourceTableName() == null || resultColumn.getExpression() == null || !resultColumn.getExpression().getColumnName().equals(string) || resultColumn.getName().equals(string)) continue;
                throw StandardException.newException("42X42", string);
            }
        }
    }

    String getXML() {
        return null;
    }

    @Override
    public TableDescriptor[] updateIndexStatisticsFor() throws StandardException {
        if (!this.checkIndexStats || this.statsToUpdate == null) {
            return EMPTY_TD_LIST;
        }
        for (int i = this.statsToUpdate.size() - 1; i >= 0; --i) {
            TableDescriptor tableDescriptor = this.statsToUpdate.get(i);
            if (!tableDescriptor.getAndClearIndexStatsIsUpToDate()) continue;
            this.statsToUpdate.remove(i);
        }
        if (this.statsToUpdate.isEmpty()) {
            return EMPTY_TD_LIST;
        }
        TableDescriptor[] tableDescriptorArray = new TableDescriptor[this.statsToUpdate.size()];
        this.statsToUpdate.toArray(tableDescriptorArray);
        this.statsToUpdate.clear();
        return tableDescriptorArray;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.orderByList != null) {
            this.orderByList.acceptChildren(visitor);
        }
        if (this.offset != null) {
            this.offset.acceptChildren(visitor);
        }
        if (this.fetchFirst != null) {
            this.fetchFirst.acceptChildren(visitor);
        }
    }
}

