/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.shared.common.error.StandardException;

public class AlterConstraintConstantAction
extends ConstraintConstantAction {
    private String constraintSchemaName;
    boolean[] characteristics;

    AlterConstraintConstantAction(String string, String string2, boolean[] blArray, String string3, UUID uUID, String string4, IndexConstantAction indexConstantAction) {
        super(string, 5, string3, uUID, string4, indexConstantAction);
        this.constraintSchemaName = string2;
        this.characteristics = (boolean[])blArray.clone();
    }

    public String toString() {
        String string = this.constraintSchemaName == null ? this.schemaName : this.constraintSchemaName;
        return "ALTER CONSTRAINT " + string + "." + this.constraintName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        SchemaDescriptor schemaDescriptor = tableDescriptor.getSchemaDescriptor();
        SchemaDescriptor schemaDescriptor2 = this.constraintSchemaName == null ? schemaDescriptor : dataDictionary.getSchemaDescriptor(this.constraintSchemaName, transactionController, true);
        ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptorByName(tableDescriptor, schemaDescriptor2, this.constraintName, true);
        if (constraintDescriptor == null) {
            throw StandardException.newException("42X86", schemaDescriptor2.getSchemaName() + "." + this.constraintName, tableDescriptor.getQualifiedName());
        }
        if (!this.characteristics[2]) {
            dataDictionary.checkVersion(230, "DEFERRED CONSTRAINTS");
            if (!(this.constraintType != 6 && this.constraintType != 1 && this.characteristics[2] || PropertyUtil.getSystemProperty("derby.constraintsTesting", "false").equals("true"))) {
                throw StandardException.newException("0A000.S", "non-default enforcement");
            }
        }
        constraintDescriptor.setEnforced(this.characteristics[2]);
        int[] nArray = new int[]{6};
        dataDictionary.updateConstraintDescriptor(constraintDescriptor, constraintDescriptor.getUUID(), nArray, transactionController);
    }
}

