/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer;

import com.sun.jdo.api.persistence.enhancer.util.Support;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PersistenceLauncher {
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private static final PrintWriter out = new PrintWriter(System.out, true);
    private static final String prefix = "PersistenceLauncher.main() : ";

    private PersistenceLauncher() {
    }

    static void usage() {
        out.flush();
        err.println("PersistenceLauncher:");
        err.println("    usage: <options> ... <target class name> <args> ...");
        err.println("    options:");
        err.println("           -h | --help");
        err.println("           -q | --quiet");
        err.println("           -w | --warn");
        err.println("           -d | --debug");
        err.println("           -t | --timing");
        err.println("    class names have to be fully qualified");
        err.println("done.");
        err.println();
        err.flush();
    }

    public static void main(String[] args) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method main;
        Class<?> clazz;
        int i;
        String classpath = System.getProperty("java.class.path");
        boolean debug = false;
        boolean timing = false;
        String targetClassname = null;
        String[] targetClassArgs = null;
        for (i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                PersistenceLauncher.usage();
                return;
            }
            if (arg.equals("-t") || arg.equals("--timing")) {
                timing = true;
                continue;
            }
            if (arg.equals("-d") || arg.equals("--debug")) {
                debug = true;
                continue;
            }
            if (arg.equals("-w") || arg.equals("--warn")) {
                debug = false;
                continue;
            }
            if (arg.equals("-q") || arg.equals("--quiet")) {
                debug = false;
                continue;
            }
            targetClassname = arg;
            int length = args.length - ++i;
            targetClassArgs = new String[length];
            System.arraycopy(args, i, targetClassArgs, 0, length);
            break;
        }
        if (debug) {
            out.println("PersistenceLauncher.main() : ...");
            out.println("settings and arguments:");
            out.println("    classpath = " + classpath);
            out.println("    debug = " + debug);
            out.println("    targetClassname = " + targetClassname);
            out.print("    targetClassArgs = { ");
            for (i = 0; i < targetClassArgs.length; ++i) {
                out.print((String)targetClassArgs[i] + " ");
            }
            out.println("}");
        }
        if (targetClassname == null) {
            PersistenceLauncher.usage();
            throw new IllegalArgumentException("targetClassname == null");
        }
        if (debug) {
            out.println("PersistenceLauncher.main() : using system class loader");
        }
        ClassLoader loader = PersistenceLauncher.class.getClassLoader();
        try {
            String mname = "main";
            Class[] mparams = new Class[]{String[].class};
            boolean init = true;
            if (debug) {
                out.println("PersistenceLauncher.main() : getting method " + targetClassname + "." + mname + "(String[])");
            }
            clazz = Class.forName(targetClassname, init, loader);
            main = clazz.getDeclaredMethod(mname, mparams);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            if (debug) {
                out.flush();
                err.println("PersistenceLauncher: EXCEPTION SEEN: " + String.valueOf(e));
                e.printStackTrace(err);
                err.flush();
            }
            throw e;
        }
        try {
            Object[] margs = new Object[]{targetClassArgs};
            if (debug) {
                out.println("invoking method " + clazz.getName() + "." + main.getName() + "(String[])");
            }
            main.invoke(null, margs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            if (debug) {
                out.flush();
                err.println("PersistenceLauncher: EXCEPTION SEEN: " + String.valueOf(e));
                e.printStackTrace(err);
                err.flush();
            }
            throw e;
        }
        finally {
            if (timing) {
                Support.timer.print();
            }
        }
        if (debug) {
            out.println("PersistenceLauncher.main() : done.");
            out.flush();
            err.flush();
        }
    }
}

