/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJClassDef;
import org.jboss.jdeparser.AbstractJMethodDef;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JClassItem;
import org.jboss.jdeparser.JMod;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.SourceFileWriter;

class MethodJMethodDef
extends AbstractJMethodDef
implements JClassItem {
    private final JType returnType;
    private final String name;

    MethodJMethodDef(AbstractJClassDef clazz, int mods, JType returnType, String name) {
        super(clazz, mods);
        this.returnType = returnType;
        this.name = name;
    }

    JType getReturnType() {
        return this.returnType;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        this.writeDocComments(writer);
        this.writeComments(writer);
        this.writeAnnotations(writer, FormatPreferences.Space.AFTER_ANNOTATION);
        JMod.write(writer, this.getModifiers());
        this.writeTypeParams(writer);
        writer.write(this.returnType);
        writer.sp();
        writer.writeEscapedWord(this.name);
        super.write(writer);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return super.getModifiers();
    }

    @Override
    public JClassItem.Kind getItemKind() {
        return JClassItem.Kind.METHOD;
    }

    @Override
    public boolean hasAllModifiers(int mods) {
        return (this.getModifiers() & mods) == mods;
    }

    @Override
    public boolean hasAnyModifier(int mods) {
        return (this.getModifiers() & mods) != 0;
    }
}

